package com.elitesland.tw.tw5.server.prd.pms.workflow;

import cn.hutool.json.JSONUtil;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetAppropriationService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetService;
import com.elitesland.tw.tw5.api.prd.pms.service.*;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;

/**
 * pms模块相关流程回调
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "PMS_{procDefKey}" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class PmsWorkflowCallBackController implements WorkflowCallBack {
    private final PmsProjectBriefService pmsProjectBriefService;
    private final PmsDistributeService pmsDistributeService;
    private final PmsProjectActivityService pmsProjectActivityService;
    private final PmsInnerProjectApplyService pmsInnerProjectApplyService;
    private final PmsProjectService pmsProjectService;

    private final BudgetService budgetService;

    private final BudgetAppropriationService budgetAppropriationService;

    private final TaskInfoService taskInfoService;

    private final PmsProjectConclusionService pmsProjectConclusionService;

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {

        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     *
     * @return
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_PROJECT_ACTIVITY.getName())) {
            //项目活动
            pmsProjectActivityService.taskCreated(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_INNER_PROJECT.getName())) {
            //内部项目申请
            pmsInnerProjectApplyService.taskCreated(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_PROJECT_CLOSE.getName())) {
            log.info("调用项目结项流程的service");
            //结项流程节点在财务关账节点，且财务未审批时，项目状态为待关账
            pmsProjectConclusionService.taskCreated(payload);
        }
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     *
     * @return
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     *
     * @return
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
//        try {
        log.info("任务流程状态变化回调参数: {}", JSONUtil.toJsonStr(payload));
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_PROJECT_REPORT.getName())) {
            log.info("调用项目汇报的service");
            //调用项目汇报的service
            pmsProjectBriefService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_DISTRIBUTE.getName())) {
            log.info("调用项目指派的service");
            //项目指派
            pmsDistributeService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_PROJECT_ACTIVITY.getName())) {
            log.info("调用项目活动的service");
            //项目活动
            pmsProjectActivityService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_INNER_PROJECT.getName())) {
            log.info("调用内部项目申请的service");
            //内部项目申请
            pmsInnerProjectApplyService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_PROJECT_CHANGE.getName())) {
            log.info("调用项目汇报计划变更审批流程的service");
            //项目汇报计划变更审批流程
            pmsProjectService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_APPLY_EXTERNAL.getName())
                || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_APPLY_INTERNAL.getName())
                || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_CHANGE.getName())
                || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BGCHANGE_OUT_EQV.getName())
                || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BGCHANGE_OUT_AMT.getName())) {
            log.info("调用预算审批 或者 预算变更审批流程的service");
            budgetService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_ALLOCAT_EXTERNAL.getName())
                || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_ALLOCAT_INTERNAL.getName())) {
            log.info("调用预算拨付审批流程的service");
            budgetAppropriationService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_TASK_APPLY.getName())) {
            log.info("调用任务申请流程的service");
            //任务授权变更流程
            taskInfoService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_TASK_CHANGE.getName())) {
            log.info("调用任务变更流程的service");
            //任务授权变更流程
            taskInfoService.processChangeStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_PROJECT_CLOSE.getName())) {
            log.info("调用项目结项流程的service");
            //项目结项流程
            pmsProjectConclusionService.processStatusChange(payload);
        }
        return WorkflowResult.success(null);
//        } catch (TwException ex) {
//            WorkflowResult result = new WorkflowResult(false, ex.getErrors().toString(), null);
//            return result;
//        }
    }
}
