package com.elitesland.tw.tw5.server.prd.product.controller;

import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductClassPayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductClassQuery;
import com.elitesland.tw.tw5.api.prd.product.service.PrdProductClassService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 产品分类
 *
 * @author likunpeng
 * @date 2023-05-22
 */
@Api(tags = "产品分类")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/prdProductClass")
@Slf4j
public class PrdProductClassController {

    private final PrdProductClassService prdProductClassService;

    /**
     * 产品分类-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("产品分类-新增")
    public TwOutputUtil insert(@RequestBody PrdProductClassPayload payload){
        return TwOutputUtil.ok(prdProductClassService.insert(payload));
    }

    /**
     * 产品分类-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("产品分类-更新")
    public TwOutputUtil update(@RequestBody PrdProductClassPayload payload){
        return TwOutputUtil.ok(prdProductClassService.update(payload));
    }

    /**
     * 产品分类-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("产品分类-主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(prdProductClassService.queryByKey(key));
    }

    /**
     * 产品分类-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("产品分类-分页")
    public TwOutputUtil paging(PrdProductClassQuery query) {
        return TwOutputUtil.ok(prdProductClassService.queryPaging(query));
    }

    /**
     * 产品分类-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("产品分类-查询列表")
    public TwOutputUtil queryList(PrdProductClassQuery query) {
        return TwOutputUtil.ok(prdProductClassService.queryListDynamic(query));
    }

    /**
     * 产品分类-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("产品分类-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        prdProductClassService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 产品分类-通过上级查询小类
     *
     * @param seniorId 上级id
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/querySubClassBySeniorId")
    // @UdcNameClass
    @ApiOperation("产品分类-通过上级查询小类")
    public TwOutputUtil querySubClassBySeniorId(Long seniorId) {
        return TwOutputUtil.ok(prdProductClassService.querySubClassBySeniorId(seniorId));
    }

    @GetMapping("/tree")
    @ApiOperation("产品分类-树")
    public TwOutputUtil tree() {
        return TwOutputUtil.ok(prdProductClassService.getClassTrees(null));
    }

}
