package com.elitesland.tw.tw5.server.prd.salecon.repo;


import com.elitesland.tw.tw5.server.prd.salecon.entity.ConPurchaseDemandDDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 采购需求处理明细
 *
 * @author likunpeng
 * @date 2023-03-29
 */
public interface ConPurchaseDemandDRepo extends JpaRepository<ConPurchaseDemandDDO, Long>, JpaSpecificationExecutor<ConPurchaseDemandDDO> {
    @Query(value = " select * from con_purchase_demand_d e where e.pur_demand_id = ?1 and e.pur_contract_id is null ", nativeQuery = true)
    List<ConPurchaseDemandDDO> findConPurchaseDDOByID(Long id);

    @Transactional
    @Modifying
    @Query(value = "update ConPurchaseDemandDDO set demandStatus = ?3,purContractId= ?2 where  id =?1")
    void updatePruchaseDemandedById(Long id, Long purContractIdV5, String demandStatus);

    ConPurchaseDemandDDO findByDemandDetailIdV4(Long idV4);
}
