package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionFieldObjRoleFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.*;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.system.entity.*;
import com.elitesland.tw.tw5.server.prd.system.repo.*;
import com.querydsl.core.QueryResults;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 系统选择项dao
 *
 * @author wangding
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemRoleDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemRoleRepo repo;
    private final PrdSystemUserRoleRepo repoUserRole;
    private final PrdSystemRoleMenuRepo repoMenu;
    private final QPrdSystemRoleDO qdo = QPrdSystemRoleDO.prdSystemRoleDO;
    private final QPrdSystemRoleMenuDO qdoRoleMenu = QPrdSystemRoleMenuDO.prdSystemRoleMenuDO;
    private final QPrdSystemMenuDO qdoMenu = QPrdSystemMenuDO.prdSystemMenuDO;
    private final QPrdSystemUserRoleDO qdoUserRole = QPrdSystemUserRoleDO.prdSystemUserRoleDO;
    private final QPrdOrgEmployeeDO qdoEmployee = new QPrdOrgEmployeeDO("prdOrgEmployeeDO");
    private final QPrdOrgOrganizationDO qdoOrganization = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeRefDO qdoEmployeeRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgPersonDO qdoPerson = QPrdOrgPersonDO.prdOrgPersonDO;
    private final PrdSystemRoleGroupRoleRepo roleGroupRoleRepo;
    private final QPrdSystemBusinessObjectDO qdoBusiness = QPrdSystemBusinessObjectDO.prdSystemBusinessObjectDO;
    private final QPrdSystemBusinessObjectMenuDO qdoBusinessMenu = QPrdSystemBusinessObjectMenuDO.prdSystemBusinessObjectMenuDO;
    private final QPrdSystemNewFunctionDO qdoNewFunction = QPrdSystemNewFunctionDO.prdSystemNewFunctionDO;
    private final QPrdSystemRoleFunctionDO qdoRoleFunction = QPrdSystemRoleFunctionDO.prdSystemRoleFunctionDO;
    private final PrdSystemRoleFunctionRepo roleFunctionRepo;
    private final QPrdSystemRoleGroupDO qdoRoleGroup = QPrdSystemRoleGroupDO.prdSystemRoleGroupDO;
    private final QPrdSystemRoleGroupRoleDO qdoRoleGroupRole = QPrdSystemRoleGroupRoleDO.prdSystemRoleGroupRoleDO;
    private final QPrdSystemPermissionFieldObjRoleFunctionDO qdoPermissionField = QPrdSystemPermissionFieldObjRoleFunctionDO.prdSystemPermissionFieldObjRoleFunctionDO;
    private final QPrdSystemPermissionFieldDO fieldDO = QPrdSystemPermissionFieldDO.prdSystemPermissionFieldDO;
    private final QPrdSystemPermissionFunctionObjectDO functionObjectDO = QPrdSystemPermissionFunctionObjectDO.prdSystemPermissionFunctionObjectDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeRefVO> getJpaQuerySelectUsers() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeRefVO.class,
                qdoEmployee.userId,
                qdoEmployee.employeeName,
                qdoEmployee.sortIndex
        )).from(qdoEmployee).leftJoin(qdoUserRole).on(qdoEmployee.userId.longValue().eq(qdoUserRole.userId.longValue()));
    }

    /**
     * 查询所有
     *
     * @return 结果
     */
    public List<PrdOrgEmployeeRefVO> queryUsers(Long roleId) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQuerySelectUsers();
        jpaQuery.where(qdoUserRole.roleId.eq(roleId));
        jpaQuery.where(qdoEmployee.deleteFlag.eq(0));
        jpaQuery.where(qdoEmployee.resourceStatus.ne(SystemDefaultEnum.LeavedResourceStatus.getCode()));
        return jpaQuery.fetch();
    }

    /**
     * 调用jpa的保存
     *
     * @param ados do对象
     * @return 保存后的对象
     */
    public List<PrdSystemUserRoleDO> saveUserRoleAll(List<PrdSystemUserRoleDO> ados) {
        return repoUserRole.saveAll(ados);
    }

    /**
     * 物理删除
     *
     * @param roleId
     * @return 删除的行数
     */
    public long deleteRolesByUserId(Long roleId) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdoUserRole).where(qdoUserRole.roleId.eq(roleId));
        return delete.execute();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemRoleDO save(PrdSystemRoleDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存
     *
     * @param ados do对象
     * @return 保存后的对象
     */
    public List<PrdSystemRoleMenuDO> saveRoleMenuAll(List<PrdSystemRoleMenuDO> ados) {
        return repoMenu.saveAll(ados);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemRoleVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemRoleVO.class,
                qdo.id,
                qdo.roleCode,
                qdo.roleName,
                qdo.sortIndex,
                qdo.enabled,
                qdo.sortIndex,
                qdo.remark,
                qdo.deleteFlag,
                qdo.createUserId,
                qdo.createTime,
                qdo.modifyTime,
                qdo.modifyUserId
        )).from(qdo);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PrdSystemRolePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getRoleCode() != null) {
            update.set(qdo.roleCode, payload.getRoleCode());
        }
        if (payload.getRoleName() != null) {
            update.set(qdo.roleName, payload.getRoleName());
        }
        if (payload.getEnabled() != null) {
            update.set(qdo.enabled, payload.getEnabled());
        }

        if (payload.getSortIndex() != null) {
            update.set(qdo.sortIndex, payload.getSortIndex());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }

        // 处理要设置成空的字段
//        List<String> nullFields = payload.getNullFields();
//        if (nullFields != null && nullFields.size() > 0) {
//
////            if (nullFields.contains("remindContent")) {
////                update.setNull(qdo.remindContent);
////            }
////            if (nullFields.contains("remindContentLocale")) {
////                update.setNull(qdo.remindContentLocale);
////            }
//            if (nullFields.contains("remark")) {
//                update.setNull(qdo.remark);
//            }
//        }
        // 执行修改
        return update.execute();
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long delete(List<Long> keys) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdo).where(qdo.id.in(keys));

        return delete.execute();
    }

    /**
     * 物理删除
     *
     * @param roleId
     * @return 删除的行数
     */
    public long deleteRoleMenusByRoleId(Long roleId) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdoRoleMenu).where(qdoRoleMenu.roleId.eq(roleId));

        return delete.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 更新状态
     *
     * @param id      主键
     * @param enabled 状态
     * @return 删除的行数
     */
    public long updateStatus(Long id, Boolean enabled) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.enabled, enabled)
                .where(qdo.id.eq(id));
        return update.execute();
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdSystemRoleVO queryByKey(Long id) {
        JPAQuery<PrdSystemRoleVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 通过编号查询
     *
     * @param code 编号
     * @return vo对象
     */
    public PrdSystemRoleVO queryByCode(String code) {
        JPAQuery<PrdSystemRoleVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.roleCode.eq(code));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 编号或名称查询
     *
     * @param code
     * @param name
     * @return
     */
    public PrdSystemRoleVO queryByCodeOrName(String code, String name) {
        JPAQuery<PrdSystemRoleVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.roleCode.eq(code).or(qdo.roleName.eq(name)));
        return jpaQuery.fetchFirst();
    }

    public List<PrdSystemRoleVO> queryByCodeIn(List<String> codes) {
        JPAQuery<PrdSystemRoleVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.roleCode.in(codes));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 列表查询
     *
     * @param roleId 角色id
     * @return vo对象
     */
    public List<Long> queryRoleMenuIds(Long roleId) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoRoleMenu.menuId).from(qdoRoleMenu).leftJoin(qdoMenu).on(qdoRoleMenu.menuId.longValue().eq(qdoMenu.id.longValue()));
        jpaQuery.where(qdoMenu.menuStatus.eq(0));
        jpaQuery.where(qdoMenu.deleteFlag.eq(0));
        jpaQuery.where(qdoRoleMenu.roleId.eq(roleId));
        return jpaQuery.fetch();
    }

    /**
     * 列表查询
     *
     * @return vo对象
     */
    public List<PrdSystemRoleVO> queryList() {
        JPAQuery<PrdSystemRoleVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.enabled.eq(true));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }


    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemRoleVO> getJpaQueryWhere(PrdSystemRoleQuery query) {
        JPAQuery<PrdSystemRoleVO> jpaQuery = getJpaQuerySelect0();
        if (!ObjectUtils.isEmpty(query.getRoleCode())) {
            jpaQuery.where(qdo.roleCode.eq(query.getRoleCode()));
        }

        if (!ObjectUtils.isEmpty(query.getRoleName())) {
            jpaQuery.where(qdo.roleName.like(SqlUtil.toSqlLikeString(query.getRoleName())));
        }
        if (!ObjectUtils.isEmpty(query.getEnabled())) {
            jpaQuery.where(qdo.enabled.eq(query.getEnabled()));
        }
        if (!ObjectUtils.isEmpty(query.getUserId())) {
            jpaQuery.where(qdoUserRole.userId.eq(query.getUserId()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, SqlUtil.getOrderse()));
        return jpaQuery;
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdSystemRoleVO> queryPaging(PrdSystemRoleQuery query) {
        JPAQuery<PrdSystemRoleVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PrdSystemRoleVO> result = jpaQuery.groupBy(qdo.id).offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdSystemRoleVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemRoleVO> getJpaQuerySelect0() {
        StringTemplate stringTemplate = Expressions.stringTemplate("CONCAT(GROUP_CONCAT({0}),'')", qdoEmployee.employeeName);
        return jpaQueryFactory.select(Projections.bean(PrdSystemRoleVO.class,
                qdo.id,
                qdo.roleCode,
                qdo.roleName,
                qdo.sortIndex,
                qdo.enabled,
                stringTemplate.as("userNames"),
                qdo.sortIndex,
                qdo.remark,
                qdo.deleteFlag,
                qdo.createUserId,
                qdo.createTime
        )).from(qdo).leftJoin(qdoUserRole).on(qdoUserRole.roleId.eq(qdo.id)).leftJoin(qdoEmployee).on(qdoEmployee.userId.eq(qdoUserRole.userId).and(qdoEmployee.resourceStatus.ne(SystemDefaultEnum.LeavedResourceStatus.getCode())));
    }

    /**
     * 根据角色获取用户id列表
     *
     * @return
     */
    public List<Long> queryUserIdByRoleCode(String roleNo) {
        return repoUserRole.queryUserIdByRoleCode(roleNo);
    }

    /**
     * 根据角色获取用户id列表
     *
     * @return
     */
    public List<Long> queryUserIdByRoleCodeAndModifyTime(String roleNo, LocalDateTime time) {
        return repoUserRole.queryUserIdByRoleCodeAndModifyTimeGt(roleNo, time);
    }

    /**
     * 根据角色获取用户id列表
     *
     * @return
     */
    public List<Long> queryUserIdByRoleCodes(List<String> roleNos) {
        return repoUserRole.queryUserIdByRoleCodes(roleNos);
    }

    /**
     * 获取用户的所有角色
     *
     * @return
     */
    public List<String> queryUserRoleCodes(Long userId) {
        return repoUserRole.queryUserRoleCodes(userId);
    }


    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeVO> getJpaQuerySelectUsersByRole() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeVO.class,
                        qdoEmployee.userId,
                        qdoEmployee.employeeName,
                        qdoEmployee.sortIndex,
                        qdoOrganization.orgName,
                        qdoPerson.userName,
                        qdoPerson.foreignName
                )).from(qdoEmployee).leftJoin(qdoUserRole).on(qdoEmployee.userId.longValue().eq(qdoUserRole.userId.longValue()))
                .leftJoin(qdoEmployeeRef).on(qdoEmployee.userId.longValue().eq(qdoEmployeeRef.userId.longValue()).and(qdoEmployeeRef.deleteFlag.eq(0)).and(qdoEmployeeRef.isDefault.eq(0)))
                .leftJoin(qdoOrganization).on(qdoEmployeeRef.orgId.longValue().eq(qdoOrganization.id.longValue()))
                .leftJoin(qdoPerson).on(qdoEmployee.personId.longValue().eq(qdoPerson.id.longValue()))
                .groupBy(qdoPerson.userName);
    }

    /**
     * 获取角色下所有的用户 模糊分页
     *
     * @param query
     * @return
     */
    public PagingVO<PrdOrgEmployeeVO> queryPagingUserList(PrdSystemRoleFunctionQuery query) {
        long total = countUserList(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PrdOrgEmployeeVO> jpaQuerySelect = getJpaUserListQueryWhere(query);
        List<PrdOrgEmployeeVO> result = jpaQuerySelect.offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PrdOrgEmployeeVO>builder().records(result).total(total).build();
    }

    /**
     * 拼接条件
     *
     * @param query
     * @return
     */
    private JPAQuery<PrdOrgEmployeeVO> getJpaUserListQueryWhere(PrdSystemRoleFunctionQuery query) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQuerySelectUsersByRole();
        //条件封装
        jpaQuery.where(where(query));
        //基础查询条件拼接
        //SqlUtil.handleCommonJpaQuery(jpaQuery, qdoEmployee._super, query);
        //动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoEmployee, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query
     * @return
     */
    private long countUserList(PrdSystemRoleFunctionQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoEmployee.countDistinct())
                .from(qdoEmployee).leftJoin(qdoUserRole).on(qdoEmployee.userId.longValue().eq(qdoUserRole.userId.longValue()))
                .leftJoin(qdoEmployeeRef).on(qdoEmployee.userId.longValue().eq(qdoEmployeeRef.userId.longValue()).and(qdoEmployeeRef.deleteFlag.eq(0)).and(qdoEmployeeRef.isDefault.eq(0)))
                .leftJoin(qdoOrganization).on(qdoEmployeeRef.orgId.longValue().eq(qdoOrganization.id.longValue()))
                .leftJoin(qdoPerson).on(qdoEmployee.personId.longValue().eq(qdoPerson.id.longValue()));

        jpaQuery.where(where(query));
        //常用查询条件拼接
        //SqlUtil.handleCommonJpaQuery(jpaQuery, qdoEmployee._super, query);
        Long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 条件拼接
     *
     * @param query
     * @return
     */
    private Predicate where(PrdSystemRoleFunctionQuery query) {
        List<Predicate> list = new ArrayList<>();
        if (!ObjectUtils.isEmpty(query.getRoleId())) {
            list.add(qdoUserRole.roleId.longValue().eq(query.getRoleId()));
        }
        if (StringUtils.hasText(query.getKeyword())) {
            list.add(qdoEmployee.employeeName.like(SqlUtil.toSqlLikeString(query.getKeyword()))
                    .or(qdoPerson.foreignName.like(SqlUtil.toSqlLikeString(query.getKeyword())))
                    .or(qdoOrganization.orgName.like(SqlUtil.toSqlLikeString(query.getKeyword()))));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 维护角色组与角色的关系
     *
     * @param roleGroupRoleDO
     */
    public void saveRoleGroupRole(PrdSystemRoleGroupRoleDO roleGroupRoleDO) {
        roleGroupRoleRepo.save(roleGroupRoleDO);
    }

    /**
     * 角色下 展示的用户列表需要提供一个关系移除
     * 物理删除
     *
     * @param roleId
     * @param userId
     * @return
     */
    public long deleteRoleByUserId(Long roleId, Long userId) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdoUserRole).where(qdoUserRole.roleId.longValue().eq(roleId)
                .and(qdoUserRole.userId.longValue().eq(userId)));
        return delete.execute();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemRoleFunctionVO> getJpaQuerySelectBusinessObject() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemRoleFunctionVO.class,
                qdoBusiness.id,
                qdoBusiness.objectName,
                qdoBusiness.objectCode
        )).from(qdoBusiness);
    }

    /**
     * 查找角色菜单下的业务对象
     *
     * @return
     */
    public PagingVO<PrdSystemRoleFunctionVO> queryByBusinessObject(PrdSystemRoleFunctionQuery query) {
        long total = countBusinessObject(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PrdSystemRoleFunctionVO> jpaQuery = getJpaBusinessObjectQueryWhere(query);
        List<PrdSystemRoleFunctionVO> result = jpaQuery.offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PrdSystemRoleFunctionVO>builder().records(result).total(total).build();
    }

    /**
     * 拼接条件
     *
     * @param query
     * @return
     */
    private JPAQuery<PrdSystemRoleFunctionVO> getJpaBusinessObjectQueryWhere(PrdSystemRoleFunctionQuery query) {
        JPAQuery<PrdSystemRoleFunctionVO> jpaQuery = getJpaQuerySelectBusinessObject();
        //条件封装
        jpaQuery.where(whereBusinessObject(query));
        //动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoBusiness, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query
     * @return
     */
    private long countBusinessObject(PrdSystemRoleFunctionQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoBusiness.count()).from(qdoBusiness);
        jpaQuery.where(whereBusinessObject(query));
        Long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件拼接
     *
     * @param query
     * @return
     */
    private Predicate whereBusinessObject(PrdSystemRoleFunctionQuery query) {
        List<Predicate> list = new ArrayList<>();
        if (StringUtils.hasText(query.getKeyword())) {
            list.add(qdoBusiness.objectName.like(SqlUtil.toSqlLikeString(query.getKeyword())));
        }
        list.add(qdoBusiness.objectStatus.eq(0));
        list.add(qdoBusiness.deleteFlag.eq(0));
        return ExpressionUtils.allOf(list);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemNewFunctionVO> getJpaQuerySelectNewFunction() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemNewFunctionVO.class,
                qdoNewFunction.id,
                qdoNewFunction.functionType,
                qdoNewFunction.functionName,
                qdoNewFunction.functionCode
        )).from(qdoNewFunction);
    }

    /**
     * 查询角色下 对应菜单 挂在的业务对象的 功能
     *
     * @param objectId
     * @param clientType
     * @return
     */
    public List<PrdSystemNewFunctionVO> queryByNewFunction(Long objectId, String clientType) {
        JPAQuery<PrdSystemNewFunctionVO> jpaQuery = getJpaQuerySelectNewFunction();
        jpaQuery.where(qdoNewFunction.objectId.longValue().eq(objectId));
        if (StringUtils.hasText(clientType)) {
            jpaQuery.where(qdoNewFunction.clientType.eq(clientType));
        }
        jpaQuery.where(qdoNewFunction.functionStatus.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 物理删除
     *
     * @param roleId
     */
    public long deleteRoleFunctionsByRoleId(Long roleId) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdoRoleFunction).where(qdoRoleFunction.roleId.longValue().eq(roleId));
        return delete.execute();
    }

    /**
     * 维护角色与功能的关系
     *
     * @param functionDOS
     */
    public void saveRoleFunctionAll(List<PrdSystemRoleFunctionDO> functionDOS) {
        roleFunctionRepo.saveAll(functionDOS);
    }

    /**
     * 查询角色功能关系是否存在
     *
     * @param query
     * @param prdSystemNewFunctionVO
     * @return
     */
    public boolean queryByRoleFunction(PrdSystemRoleFunctionQuery query, PrdSystemNewFunctionVO prdSystemNewFunctionVO) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoRoleFunction.id).from(qdoRoleFunction).where(qdoRoleFunction.roleId.longValue().eq(query.getRoleId())
                .and(qdoRoleFunction.functionId.longValue().eq(prdSystemNewFunctionVO.getId())));
        Long id = jpaQuery.fetchOne();
        return !ObjectUtils.isEmpty(id);
    }

    /**
     * 查询角色对应的角色组主键
     *
     * @param key
     * @return
     */
    public Long queryRoleGroupId(Long key) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoRoleGroup.id).from(qdoRoleGroup).leftJoin(qdoRoleGroupRole)
                .on(qdoRoleGroup.id.longValue().eq(qdoRoleGroupRole.roleGroupId.longValue()));
        jpaQuery.where(qdoRoleGroupRole.roleId.longValue().eq(key));
        return jpaQuery.fetchOne();
    }

    /**
     * 角色下 字段列表的 模糊查询
     *
     * @param query
     * @return
     */
    public PagingVO<PrdSystemPermissionFieldObjRoleFunctionVO> queryObjectByRoleId(PrdSystemPermissionFieldObjRoleFunctionQuery query) {
        long total = countFieldByRoleId(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PrdSystemPermissionFieldObjRoleFunctionVO> jpaQuery = getJpaFieldByRoleIdQueryWhere(query);
        List<PrdSystemPermissionFieldObjRoleFunctionVO> result = jpaQuery.offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PrdSystemPermissionFieldObjRoleFunctionVO>builder().records(result).total(total).build();
    }

    /**
     * 拼装条件
     *
     * @param query
     * @return
     */
    private JPAQuery<PrdSystemPermissionFieldObjRoleFunctionVO> getJpaFieldByRoleIdQueryWhere(PrdSystemPermissionFieldObjRoleFunctionQuery query) {
        JPAQuery<PrdSystemPermissionFieldObjRoleFunctionVO> jpaQuery = getJpaQuerySelectFieldByRoleId();
        //条件封装
        jpaQuery.where(whereFieldByRoleId(query));
        //动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoBusiness, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 查询字段
     *
     * @return
     */
    private JPAQuery<PrdSystemPermissionFieldObjRoleFunctionVO> getJpaQuerySelectFieldByRoleId() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemPermissionFieldObjRoleFunctionVO.class,
                qdoBusiness.id.as("objectId"),
                qdoBusiness.objectName,
                qdoBusiness.objectCode
        )).from(qdoBusiness);
    }

    /**
     * 统计数量
     *
     * @param query
     * @return
     */
    private long countFieldByRoleId(PrdSystemPermissionFieldObjRoleFunctionQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoBusiness.count()).from(qdoBusiness);
        jpaQuery.where(whereFieldByRoleId(query));
        Long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 拼接查询参数
     *
     * @param query
     * @return
     */
    private Predicate whereFieldByRoleId(PrdSystemPermissionFieldObjRoleFunctionQuery query) {
        List<Predicate> list = new ArrayList<>();
        if (StringUtils.hasText(query.getKeyword())) {
            list.add(qdoBusiness.objectName.like(SqlUtil.toSqlLikeString(query.getKeyword())));
        }
        list.add(qdoBusiness.objectStatus.eq(0));
        list.add(qdoBusiness.deleteFlag.eq(0));
        return ExpressionUtils.allOf(list);
    }

    /**
     * 业务/管理角色列表查询
     *
     * @param query
     * @return
     */
    public List<PrdSystemRoleVO> differentList(PrdSystemRoleQuery query) {
        JPAQuery<PrdSystemRoleVO> jpaQuery = getJpaQuerySelectDifferentList();
        if (StringUtils.hasText(query.getRoleGroupType())) {
            jpaQuery.where(qdoRoleGroup.roleGroupType.eq(query.getRoleGroupType()));
        }
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemRoleVO> getJpaQuerySelectDifferentList() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemRoleVO.class,
                        qdo.id,
                        qdo.roleCode,
                        qdo.roleName,
                        qdo.sortIndex,
                        qdo.enabled,
                        qdo.sortIndex,
                        qdo.remark,
                        qdo.deleteFlag,
                        qdo.createUserId,
                        qdo.createTime,
                        qdo.modifyTime,
                        qdo.modifyUserId
                )).from(qdo).leftJoin(qdoRoleGroupRole).on(qdoRoleGroupRole.roleId.longValue().eq(qdo.id.longValue()))
                .leftJoin(qdoRoleGroup).on(qdoRoleGroup.id.longValue().eq(qdoRoleGroupRole.roleGroupId));
    }

    /**
     * 根据角色主键查询功能
     *
     * @param query
     * @return
     */
    public List<PrdSystemPermissionFieldObjRoleFunctionVO> queryFunctionByRoleId(PrdSystemPermissionFieldObjRoleFunctionQuery query) {
        JPAQuery<PrdSystemPermissionFieldObjRoleFunctionVO> jpaQuery = getJpaQuerySelectFunction();
        jpaQuery.where(qdoRoleFunction.roleId.longValue().eq(query.getRoleId()));
        return jpaQuery.fetch();
    }

    /**
     * 根据角色查询功能 拼装查询条件
     *
     * @return
     */
    private JPAQuery<PrdSystemPermissionFieldObjRoleFunctionVO> getJpaQuerySelectFunction() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemPermissionFieldObjRoleFunctionVO.class,
                qdoRoleFunction.functionId,
                qdoNewFunction.clientType
        )).from(qdoNewFunction).leftJoin(qdoRoleFunction).on(qdoRoleFunction.functionId.longValue().eq(qdoNewFunction.id));
    }

    /**
     * 根据功能主键 查询功能对象
     *
     * @param collect
     * @return
     */
    public List<PrdSystemPermissionFieldObjRoleFunctionVO> queryFunctionObjectByFunctionIds(List<Long> collect) {
        JPAQuery<PrdSystemPermissionFieldObjRoleFunctionVO> jpaQuery = getJpaQuerySelectFunctionObject();
        jpaQuery.where(functionObjectDO.functionId.in(collect));
        return jpaQuery.fetch();
    }

    /**
     * 根据功能主键 查询功能对象 构建查询参数
     *
     * @return
     */
    private JPAQuery<PrdSystemPermissionFieldObjRoleFunctionVO> getJpaQuerySelectFunctionObject() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemPermissionFieldObjRoleFunctionVO.class,
                qdoNewFunction.objectId,
                functionObjectDO.classPathName,
                functionObjectDO.classPathCode,
                functionObjectDO.className,
                functionObjectDO.id.as("functionObjectId"),
                qdoNewFunction.clientType
        )).from(functionObjectDO).leftJoin(qdoNewFunction).on(functionObjectDO.functionId.longValue().eq(qdoNewFunction.id.longValue()));
    }

    /**
     * 根据功能对象主键 查询字段
     *
     * @param collect
     * @return
     */
    public List<PrdSystemPermissionFieldObjRoleFunctionVO> queryFunctionObjectFieldByFunctionObjectIds(List<Long> collect) {
        JPAQuery<PrdSystemPermissionFieldObjRoleFunctionVO> jpaQuery = getJpaQuerySelectFunctionObjectField();
        jpaQuery.where(fieldDO.functionObjectId.in(collect));
        return jpaQuery.fetch();
    }

    /**
     * 根据功能对象主键 查询字段 拼接查询参数
     *
     * @return
     */
    private JPAQuery<PrdSystemPermissionFieldObjRoleFunctionVO> getJpaQuerySelectFunctionObjectField() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemPermissionFieldObjRoleFunctionVO.class,
                fieldDO.fieldName,
                fieldDO.fieldType,
                fieldDO.id.as("fieldId"),
                fieldDO.functionObjectId
        )).from(fieldDO);
    }

    /**
     * 根据角色查询 字段规则
     *
     * @param query
     * @return
     */
    public List<PrdSystemPermissionFieldObjRoleFunctionVO> queryFieldRuleByRoleId(PrdSystemPermissionFieldObjRoleFunctionQuery query) {
        JPAQuery<PrdSystemPermissionFieldObjRoleFunctionVO> jpaQuery = getJpaQuerySelectFieldRule();
        jpaQuery.where(qdoPermissionField.roleId.longValue().eq(query.getRoleId()));
        return jpaQuery.fetch();
    }

    /**
     * 根据角色查询 字段规则 拼接查询参数
     *
     * @return
     */
    private JPAQuery<PrdSystemPermissionFieldObjRoleFunctionVO> getJpaQuerySelectFieldRule() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemPermissionFieldObjRoleFunctionVO.class,
                qdoPermissionField.isVisible,
                qdoPermissionField.isEdit,
                qdoPermissionField.fieldId,
                qdoPermissionField.id.as("roleObjFunctionFieldId")
        )).from(qdoPermissionField);
    }

    /**
     * 根据角色查询对应的角色组关系
     *
     * @param id
     * @return
     */
    public PrdSystemRoleGroupRoleVO queryRoleGroupRoleByRoleId(Long id) {
        JPAQuery<PrdSystemRoleGroupRoleVO> jpaQuery = getJpaQuerySelectRoleGroupRole();
        jpaQuery.where(qdoRoleGroupRole.roleId.longValue().eq(id));
        return jpaQuery.fetchOne();
    }

    /**
     * 根据角色查询对应的角色组关系 查询条件拼接
     *
     * @return
     */
    private JPAQuery<PrdSystemRoleGroupRoleVO> getJpaQuerySelectRoleGroupRole() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemRoleGroupRoleVO.class,
                qdoRoleGroupRole.id,
                qdoRoleGroupRole.roleId,
                qdoRoleGroupRole.roleGroupId
        )).from(qdoRoleGroupRole);
    }

    /**
     * 根据编号查询userId
     *
     * @param roleCodes 角色编号
     * @return 用户IDList
     */
    public Map<String, List<Long>> queryUserIdMapByRoleCodes(List<String> roleCodes) {
        JPAQuery<Tuple> jpaQuery = jpaQueryFactory.select(
                        qdo.roleCode,
                        qdoUserRole.userId
                ).from(qdoUserRole)
                .leftJoin(qdo).on(qdo.id.eq(qdoUserRole.roleId)
                        .and(qdo.deleteFlag.eq(0)))
                .leftJoin(qdoEmployee).on(qdoEmployee.userId.eq(qdoUserRole.userId))
                .where(qdo.roleCode.in(roleCodes)
                        .and(qdoUserRole.deleteFlag.eq(0)).and(qdoEmployee.resourceStatus.ne(SystemDefaultEnum.LeavedResourceStatus.getCode())));
        return jpaQuery.fetch().stream()
                .collect(Collectors.groupingBy(
                        tuple -> tuple.get(0, String.class),
                        Collectors.mapping(tuple -> tuple.get(1, Long.class), Collectors.toList())
                ));
    }
}
