package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_system_function_special", indexes = {@Index(name = "function_index", columnList = "function_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_system_function_special", comment = "系统功能关键行为表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemFunctionSpecialDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1L;

    @Comment("功能ID")
    @Column(name = "function_id")
    private Long functionId;

    @Comment("关键行为名称")
    @Column()
    private String specialName;

    @Comment("后端接口")
    @Column()
    private String specialUrl;

    @Comment("关键行为类型")
    @Column()
    private Integer specialType;

    @Comment("关键行为编码")
    @Column()
    private String specialCode;

    @Comment("允许操作角色或职位")
    @Column()
    private String specialRoles;

    @Comment("允许操作的安全等级")
    @Column()
    private Integer systemLevel;

}
