package com.elitesland.tw.tw5.server.prd.task.service;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.cal.query.CalResourcePriceQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalResourceService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskSettleTimesheetPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskSettleTimesheetVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetRepo;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskSourceTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectMembersDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.task.common.AcceptMethodEnum;
import com.elitesland.tw.tw5.server.prd.task.common.PricingMethodEnum;
import com.elitesland.tw.tw5.server.prd.task.convert.TaskInfoConvert;
import com.elitesland.tw.tw5.server.prd.task.convert.TaskPackageConvert;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskInfoDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskPackageDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskSettleTimesheetDAO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskInfoDO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskPackageDO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskSettleTimesheetDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 任务
 *
 * @author xxb
 * @date 2023-12-1
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TaskCommonServiceImpl extends BaseServiceImpl implements TaskCommonService {

    private final TaskInfoDAO taskInfoDAO;
    //    private final BudgetCommonService budgetCommonService;
    private final TaskPackageDAO taskPackageDAO;
    private final PmsProjectDAO pmsProjectDAO;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;
    private final PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService;
    private final CalResourceService calResourceService;
    private final CacheUtil cacheUtil;
    private final PmsProjectMembersDAO pmsProjectMembersDAO;
    private final TimesheetRepo timesheetRepo;
    private final TaskSettleTimesheetDAO taskSettleTimesheetDAO;


    @Override
    public List<TaskInfoVO> queryTaskByReason(String reasonType, Long reasonId) {
        return taskInfoDAO.queryTaskByReason(reasonType, reasonId);
    }

    @Override
    public List<TaskPackageVO> queryTaskPackageList(TaskPackageQuery taskPackageQuery) {
        return taskPackageDAO.queryListDynamic(taskPackageQuery);
    }

    @Override
    public long taskPackageCount(TaskPackageQuery taskPackageQuery) {
        return taskPackageDAO.count(taskPackageQuery);
    }

    /**
     * 数据校验
     *
     * @param timesheetPayload
     * @param taskId
     * @param userId
     * @param workHour
     * @param type
     */
    TaskInfoVO checkData(TimesheetPayload timesheetPayload, Long taskId, Long userId, BigDecimal workHour, String type) {
        if (workHour == null || workHour.compareTo(BigDecimal.ZERO) == 0 || taskId == null) {
            throw TwException.error("", "工时数据不合规");
        }
        log.info("工时提交或审批操作调用参数：" + " \n taskId:", +taskId + " \n workHour:" + workHour + "\n type：" + type);

        TaskInfoVO taskInfoVO = taskInfoDAO.queryByKey(taskId);
        if (taskInfoVO == null) {
            throw TwException.error("", "操作任务不存在");
        }
        if (!userId.equals(taskInfoVO.getTaskResId())) {
            throw TwException.error("", "任务负责人和工时填写人不匹配");
        }
        if (type.equals("1") && workHour.compareTo(BigDecimal.ZERO) > 0) {
            //奖励假不处理
            if (!StringUtils.hasText(taskInfoVO.getSourceType()) || !TaskSourceTypeEnum.REWARD.getCode().equals(taskInfoVO.getSourceType())) {
                List<String> statuss = Arrays.asList(TaskStatusEnum.INPROCESS.getCode(), TaskStatusEnum.VALIDATING.getCode(), TaskStatusEnum.FINISHED.getCode());
                if (!statuss.contains(taskInfoVO.getTaskStatus())) {
                    throw TwException.error("", taskInfoVO.getTaskName() + "-任务不可用");
                }
            }
        }
        if (taskInfoVO.getEqvaRatio() == null) {
            // 231231 之前的老数据 大部分任务包都是没有当量系数的，需要实时查询一次
            LocalDate searchDate = null;
            if (null != timesheetPayload && null != timesheetPayload.getWorkDate()) {
                searchDate = timesheetPayload.getWorkDate();
            }
            BigDecimal eqvaRatio = prdOrgEmployeeEqvaRatioService.getEqvaRatio(userId, searchDate);
            taskInfoVO.setEqvaRatio(eqvaRatio);
            // throw TwException.error("", "当量系数不可为空");
        }
        if (taskInfoVO.getEqvaRatio() == null) {
            throw TwException.error("", "当量系数不可为空");
        }

        return taskInfoVO;
    }

    /**
     * 工时提交或审批操作调用
     * 提交或审批通过工时传正数
     * 撤回或驳回传负数
     *
     * @param taskId   任务id
     * @param type     操作类型（ 1：提交或提交撤回及驳回，2：审批通过或审批通过撤回）
     * @param workHour 填写工时数
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateTimeSheet(TimesheetPayload timesheetPayload, Long taskId, Long userId, BigDecimal workHour, String type) {
        /**
         * 1.数据校验
         *
         * 2.提交工时
         *  2.1 有工时和任务关系记录，不能提交（重复提交）
         *  2.1 无关系记录可以提交，生成关系记录
         * 3.提交撤回
         *  3.1 有关系记录并状态是提交中 可以撤回，并删除关系记录
         *  3.2 无关系记录不可以撤回（重复撤回）
         * 4.审批通过
         *  4.1 无关系记录 不能通过，说明工时数据出问题了
         *  4.2 有关系记录但状态不是提交状态不能通过，（重复通过）
         *  4.3 正常数据 提交后更新关系状态
         * 5.审批通过或已结算撤回
         *  5.1 无关系记录不能撤回
         *  5.2 有关系记录状态为已提交不能撤回
         *  5.3 有关系记录状态为审批通过直接撤回，删除工时关联关系
         *  5.4 有关系记录状态为已结算直接撤回，反向结算工时对应当量和任务，删除工时关联关系
         */
        //1.数据校验
        TaskInfoVO taskInfoVO = checkData(timesheetPayload, taskId, userId, workHour, type);
        //历史数据不校验
        LocalDate localDate = DateUtil.strToLocalDate("2024-08-10");
        LocalDate now = LocalDate.now();
        Boolean isCheckRef = false;
        if (now.isAfter(localDate)) {
            isCheckRef = true;
        }
        //true正向操作，false反向操作
        boolean isForward = true;
        if (workHour.compareTo(BigDecimal.ZERO) < 0) {
            isForward = false;
        }
        //操作人天
        BigDecimal divide = workHour.divide(BigDecimal.valueOf(8), 4, RoundingMode.DOWN);
        //操作当量绝对值
        BigDecimal upEqva = divide.multiply(taskInfoVO.getEqvaRatio()).abs();
        //工时和任务关系记录
        TaskSettleTimesheetVO taskSettleTimesheetVO = taskSettleTimesheetDAO.queryByTimesheetId(timesheetPayload.getId());
        if (taskSettleTimesheetVO != null && taskSettleTimesheetVO.getEqva() != null) {
            upEqva = taskSettleTimesheetVO.getEqva();
        }
        //已提交工时
        BigDecimal usedEqva = taskInfoVO.getUsedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getUsedEqva();
        //已审批工时
        BigDecimal approvedEqva = taskInfoVO.getApprovedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getApprovedEqva();

        TaskInfoPayload payload = new TaskInfoPayload();
        payload.setId(taskId);

        //提交或撤回提交
        BigDecimal newUsedEqva = null;
        if (type.equals("1")) {
            if (isForward) {
                // 2.提交工时
                //加当量
                newUsedEqva = usedEqva.add(upEqva);
                if (newUsedEqva.compareTo(taskInfoVO.getTotalEqva()) > 0) {
                    throw TwException.error("", "任务剩余当量不足");
                }
                if (taskSettleTimesheetVO != null) {
                    throw TwException.error("", "该工时重复提交");
                }
                //增加关系数据
                TaskSettleTimesheetDO timesheetDO = new TaskSettleTimesheetDO();
                timesheetDO.setEqva(upEqva);
                timesheetDO.setTaskId(taskInfoVO.getId());
                timesheetDO.setTimesheetId(timesheetPayload.getId());
                timesheetDO.setWorkHour(workHour);
                timesheetDO.setWorkDate(timesheetPayload.getWorkDate());
                timesheetDO.setWorkDesc(timesheetPayload.getWorkDesc());
                timesheetDO.setSettleFlag(-1);
                taskSettleTimesheetDAO.save(timesheetDO);
            } else {
                //3.提交撤回
                //扣减当量
                newUsedEqva = usedEqva.subtract(upEqva);
                if (newUsedEqva.compareTo(BigDecimal.ZERO) < 0 || newUsedEqva.compareTo(approvedEqva) < 0) {
                    throw TwException.error("", "已提交和已审批工时校验异常，请联系管理员");
                }
                if (taskSettleTimesheetVO == null) {
                    if (isCheckRef) {
                        throw TwException.error("", "该工时提交记录异常，不可撤回，请联系管理员");
                    }

                } else {
                    //删除关系数据
                    taskSettleTimesheetDAO.deleteSoft(Arrays.asList(taskSettleTimesheetVO.getId()));
                }
            }

        }
        if (type.equals("2")) {
            //审批通过或撤回审批通过
            BigDecimal newApprovedEqva = null;
            if (isForward) {
                //4.审批通过
                newApprovedEqva = approvedEqva.add(upEqva);
                if (newApprovedEqva.compareTo(usedEqva) > 0 || newApprovedEqva.compareTo(taskInfoVO.getTotalEqva()) > 0) {
                    throw TwException.error("", "已审批工时和已提交工时校验异常，请联系管理员");
                }
                if (taskSettleTimesheetVO == null) {
                    if (isCheckRef) {
                        throw TwException.error("", "该工时审批异常，请联系管理员");
                    }
                    //补充增加关系数据
                    TaskSettleTimesheetDO timesheetDO = new TaskSettleTimesheetDO();
                    timesheetDO.setEqva(upEqva);
                    timesheetDO.setTaskId(taskInfoVO.getId());
                    timesheetDO.setTimesheetId(timesheetPayload.getId());
                    timesheetDO.setWorkHour(workHour);
                    timesheetDO.setWorkDate(timesheetPayload.getWorkDate());
                    timesheetDO.setWorkDesc(timesheetPayload.getWorkDesc());
                    timesheetDO.setSettleFlag(0);
                    taskSettleTimesheetDAO.save(timesheetDO);
                } else {
                    Integer settleFlag = taskSettleTimesheetVO.getSettleFlag();
                    if (settleFlag != null && settleFlag.intValue() != -1) {
                        throw TwException.error("", "该工时审批状态异常，请联系管理员");
                    }
                    //更新关系类型操作状态
                    TaskSettleTimesheetPayload taskSettleTimesheetPayload = new TaskSettleTimesheetPayload();
                    taskSettleTimesheetPayload.setId(taskSettleTimesheetVO.getId());
                    taskSettleTimesheetPayload.setSettleFlag(0);
                    taskSettleTimesheetDAO.updateByKeyDynamic(taskSettleTimesheetPayload);
                }

            } else {
                //5.审批通过或已结算撤回
                newApprovedEqva = approvedEqva.subtract(upEqva);
                newUsedEqva = usedEqva.subtract(upEqva);
                if (taskSettleTimesheetVO == null) {
                    if (isCheckRef) {
                        throw TwException.error("", "该工时任务关系异常，请联系管理员");
                    } else {
                        if (taskInfoVO.getPricingMethod().equals(PricingMethodEnum.SINGLE.getCode())) {
                            throw TwException.error("", "该工时未审批通过，不可撤回");
                        }
                    }
                } else {
                    Integer settleFlag = taskSettleTimesheetVO.getSettleFlag();
                    if (settleFlag == null || settleFlag.intValue() == -1) {
                        throw TwException.error("", "该工时审批中请联系相关人员处理");
                    }
                    if (taskSettleTimesheetVO.getSettleId() != null) {
                        //已结算工时撤回
                        //反向结算
                        CalTaskSettleService bean = SpringUtil.getBean(CalTaskSettleService.class);
                        bean.reverseTaskSettle(taskInfoVO.getTaskNo(), upEqva.negate(), timesheetPayload.getWorkDate() + "-工时撤回反向结算");
                    }
                    //删除关系数据
                    taskSettleTimesheetDAO.deleteSoft(Arrays.asList(taskSettleTimesheetVO.getId()));
                }

            }
            payload.setApprovedEqva(newApprovedEqva);
        }
        payload.setUsedEqva(newUsedEqva);
        taskInfoDAO.updateByKeyDynamic(payload);
    }

    /**
     * 工时提交或审批操作调用
     * 提交或审批通过工时传正数
     * 撤回或驳回传负数
     */

//    @Transactional(rollbackFor = Exception.class)
//    public void updateTimeSheet0(TimesheetPayload timesheetPayload, Long taskId, Long userId, BigDecimal workHour, String type) {
//
//        if (workHour == null || workHour.compareTo(BigDecimal.ZERO) == 0) {
//            throw TwException.error("", "工时数据不合规");
//        }
//        log.info("工时提交或审批操作调用参数：" + " \n taskId:", +taskId + " \n workHour:" + workHour + "\n type：" + type);
//
//        TaskInfoVO taskInfoVO = taskInfoDAO.queryByKey(taskId);
//        if (taskInfoVO == null) {
//            throw TwException.error("", "操作任务不存在");
//        }
//        if (!userId.equals(taskInfoVO.getTaskResId())) {
//            throw TwException.error("", "任务负责人和工时填写人不匹配");
//        }
//        if (type.equals("1") && workHour.compareTo(BigDecimal.ZERO) > 0) {
//            //奖励假不处理
//            if (!StringUtils.hasText(taskInfoVO.getSourceType()) || !TaskSourceTypeEnum.REWARD.getCode().equals(taskInfoVO.getSourceType())) {
//                List<String> statuss = Arrays.asList(TaskStatusEnum.INPROCESS.getCode(), TaskStatusEnum.VALIDATING.getCode(), TaskStatusEnum.FINISHED.getCode());
//                if (!statuss.contains(taskInfoVO.getTaskStatus())) {
//                    throw TwException.error("", taskInfoVO.getTaskName() + "-任务不可用");
//                }
//            }
//        }
//        TaskInfoPayload payload = new TaskInfoPayload();
//        payload.setId(taskId);
//        BigDecimal divide = workHour.divide(BigDecimal.valueOf(8), 4, RoundingMode.DOWN);
//        if (taskInfoVO.getEqvaRatio() == null) {
//            // 231231 之前的老数据 大部分任务包都是没有当量系数的，需要实时查询一次
//            LocalDate searchDate = null;
//            if (null != timesheetPayload && null != timesheetPayload.getWorkDate()) {
//                searchDate = timesheetPayload.getWorkDate();
//            }
//            BigDecimal eqvaRatio = prdOrgEmployeeEqvaRatioService.getEqvaRatio(userId, searchDate);
//            taskInfoVO.setEqvaRatio(eqvaRatio);
//            // throw TwException.error("", "当量系数不可为空");
//        }
//        if (taskInfoVO.getEqvaRatio() == null) {
//            throw TwException.error("", "当量系数不可为空");
//        }
//        //操作当量
//        BigDecimal upEqva = divide.multiply(taskInfoVO.getEqvaRatio());
//        if (type.equals("1")) {
//            //提交或撤回提交
//            BigDecimal usedEqva = taskInfoVO.getUsedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getUsedEqva();
//            BigDecimal newUsedEqva = usedEqva.add(upEqva);
//            if (upEqva.compareTo(BigDecimal.ZERO) > 0 && newUsedEqva.compareTo(taskInfoVO.getTotalEqva()) > 0) {
//                throw TwException.error("", "任务当量不足");
//            }
//            payload.setUsedEqva(newUsedEqva);
//            //加一层保险，防止数据问题
//            BigDecimal approvedEqva = taskInfoVO.getApprovedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getApprovedEqva();
//            BigDecimal newApprovedEqva = approvedEqva.add(upEqva);
//            if (usedEqva.compareTo(newApprovedEqva) < 0) {
//                payload.setUsedEqva(newApprovedEqva);
//            }
//        }
//        if (type.equals("2")) {
//            BigDecimal approvedEqva = taskInfoVO.getApprovedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getApprovedEqva();
//            BigDecimal newApprovedEqva = approvedEqva.add(upEqva);
//
//            //审批通过或审批通过撤回
//            if (timesheetPayload != null && taskInfoVO.getPricingMethod().equals(PricingMethodEnum.SINGLE.getCode())) {
//                TaskSettleTimesheetVO taskSettleTimesheetVO = taskSettleTimesheetDAO.queryByTimesheetId(timesheetPayload.getId());
//
//                if (taskSettleTimesheetVO != null && taskSettleTimesheetVO.getSettleId() != null) {
//                    throw TwException.error("", "工时任务已结算不可操作");
//                }
//                if (upEqva.compareTo(BigDecimal.ZERO) > 0) {
//                    Long id = null;
//                    if (taskSettleTimesheetVO != null) {
//                        //正常流程不会出现这个数据存在的场景，为了直接在数据库中把审批通过的数据改为审批中准备的
//                        //减去之前审批通过当量
//                        newApprovedEqva = newApprovedEqva.subtract(taskSettleTimesheetVO.getEqva());
//                        id = taskSettleTimesheetVO.getId();
//                        // throw TwException.error("", "该工时已审批通过，不可再次发起");
//                    }
//                    //增加关系数据
//                    TaskSettleTimesheetDO timesheetDO = new TaskSettleTimesheetDO();
//                    timesheetDO.setId(id);
//                    timesheetDO.setEqva(upEqva);
//                    timesheetDO.setTaskId(taskInfoVO.getId());
//                    timesheetDO.setTimesheetId(timesheetPayload.getId());
//                    timesheetDO.setWorkHour(workHour);
//                    timesheetDO.setWorkDate(timesheetPayload.getWorkDate());
//                    timesheetDO.setWorkDesc(timesheetPayload.getWorkDesc());
//                    timesheetDO.setSettleFlag(0);
//                    taskSettleTimesheetDAO.save(timesheetDO);
//                } else {
//                    if (taskSettleTimesheetVO == null) {
//                        throw TwException.error("", "该工时未审批通过，不可撤回");
//                    }
//                    //如果撤回删除关系记录
//                    taskSettleTimesheetDAO.deleteSoft(List.of(taskSettleTimesheetVO.getId()));
//                }
//            }
//            BigDecimal usedEqva = taskInfoVO.getUsedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getUsedEqva();
//            BigDecimal newUsedEqva = usedEqva.add(upEqva);
//            if (upEqva.compareTo(BigDecimal.ZERO) < 0) {
//                //已审批数据撤回后为新建状态，所以已使用当量数也要更新
//                payload.setUsedEqva(newUsedEqva);
//            }
//            if (newUsedEqva.compareTo(newApprovedEqva) < 0) {
//                //如果已使用比审批通过的小，是不正常的，应该
//                payload.setUsedEqva(newApprovedEqva);
//            }
//            payload.setApprovedEqva(newApprovedEqva);
//        }
//        taskInfoDAO.updateByKeyDynamic(payload);
//    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<TimesheetVO> bw8TimeSheetSubmit(List<TimesheetPayload> payloads) {
        /**
         * 1.先判断项目是不是帮我吧项目
         * 2.校验任务包存不存在
         *   2.1.如果任务包存在
         *     2.1.1校验帮我吧任务在不在
         *       2.1.1.1 任务存在，直接变更当量
         *       2.1.1.2 任务不存在，创建帮我吧任务
         *   2.2 任务包不存在
         *     2.2.1 创建任务包
         *     2.2.2 创建任务
         *     2.2.3 检查项目成员存不存在，不存在创建项目成员并把任务包id赋值到项目成员中
         * 3.校验预算够不够
         */
        //返回数据
        List<TimesheetVO> timesheetVOS = new ArrayList<>();

        Long userId = GlobalUtil.getLoginUserId();
        //按照项目分组
        Map<Long, List<TimesheetPayload>> projTimeSheetMap = payloads.stream().filter(pay -> pay.getProjId() != null).collect(Collectors.groupingBy(TimesheetPayload::getProjId));
        if (ObjectUtils.isEmpty(projTimeSheetMap)) {
            throw TwException.error("", "工时归属项目不存在");
        }
        List<PmsProjectVO> pmsProjectVOS = pmsProjectDAO.queryByKeys(projTimeSheetMap.keySet().stream().collect(Collectors.toList()));
        if (ObjectUtils.isEmpty(pmsProjectVOS)) {
            throw TwException.error("", "项目不存在");
        }
        List<TaskInfoDO> saveTaskInfoS = new ArrayList<>();
        List<PmsProjectMembersDO> saveProjMemberS = new ArrayList<>();
        //初始化当量系数
        BigDecimal eqvaRatio = prdOrgEmployeeEqvaRatioService.getEqvaRatio(userId, null);
        projTimeSheetMap.forEach((projectId, timeSheets) -> {
            Optional<PmsProjectVO> first = pmsProjectVOS.stream().filter(vo -> vo.getId().equals(projectId)).findFirst();
            if (!first.isPresent()) {
                throw TwException.error("", "项目不存在");
            }
            //1.先判断项目是不是帮我吧项目
            PmsProjectVO pmsProjectVO = first.get();
            if (!pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                throw TwException.error("", "非激活项目不可操作");
            }
            if (!StringUtils.hasText(pmsProjectVO.getExt1()) || !pmsProjectVO.getExt1().equals("DEV_OPS")) {
                throw TwException.error("", "非运维项目不可操作");
            }
            //查询改项目下任务包
            TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
            taskPackageQuery.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
            taskPackageQuery.setReasonId(projectId);
            taskPackageQuery.setReceiverResId(userId);
            taskPackageQuery.setTaskPackageStatus(TaskStatusEnum.INPROCESS.getCode());
            List<TaskPackageVO> taskPackageVOS = taskPackageDAO.queryListDynamic(taskPackageQuery);
            TaskPackageVO taskPackageVO = null;
            //实际当量系数
            BigDecimal eqvaRatio0 = eqvaRatio;
            if (!ObjectUtils.isEmpty(taskPackageVOS)) {
                taskPackageVO = taskPackageVOS.get(0);
                eqvaRatio0 = taskPackageVO.getEqvaRatio();
                // 兼容231231 迁移过来的老数据老数据
                if (null == eqvaRatio0) {
                    eqvaRatio0 = eqvaRatio;
                }
            }
            //总的工时
            BigDecimal workHour = timeSheets.stream()
                    .map(TimesheetPayload::getWorkHour)
                    .filter(Objects::nonNull)
                    .reduce(BigDecimal::add)
                    .orElse(BigDecimal.ZERO);
            /**
             * 为了记录创建任务来源哪一个工时，因为工时是按照项目分组创建的任务，任务表里存的是主键是Long类型，
             * 所以只能取第一个工时主键存储，一般一个项目下只有一个一天只有一个工时，应该问题不大
             */
            Long timeSheetId = timeSheets.get(0).getId();
            //操作当量
            BigDecimal divide = workHour.divide(BigDecimal.valueOf(8), 4, RoundingMode.DOWN);
            BigDecimal upEqva = divide.multiply(eqvaRatio0);
            //3 校验当量
            BudgetCommonService bean = SpringUtil.getBean(BudgetCommonService.class);
            bean.checkBudgetEqva(projectId, PmsReasonTypeEnum.PROJ_CONTRACT.getCode(), null, upEqva);
            TaskPackageDO taskPackageDO;

            TaskInfoDO taskInfo = null;
            //2.校验任务包
            if (taskPackageVO == null) {
                // 创建任务包
                TaskPackageDO taskPackage = createTaskPackage(pmsProjectVO, userId, eqvaRatio0);
                taskPackageDO = taskPackageDAO.save(taskPackage);
                PmsProjectMembersDO projMember = createProjMember(taskPackageDO);
                saveProjMemberS.add(projMember);
            } else {
                taskPackageDO = TaskPackageConvert.INSTANCE.voToDo(taskPackageVO);
                //查询该帮我吧工时是否已经创建过任务
                TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
                taskInfoQuery.setSourceType(TaskSourceTypeEnum.BANGWO8.getCode());
                taskInfoQuery.setSourceId(timeSheetId);
                List<TaskInfoVO> taskInfoVOS = taskInfoDAO.queryTaskSimpleList(taskInfoQuery);
                if (!ObjectUtils.isEmpty(taskInfoVOS)) {
                    taskInfo = TaskInfoConvert.INSTANCE.toEntity(taskInfoVOS.get(0));
                }
            }
            if (taskInfo == null) {
                // 创建任务
                taskInfo = createTaskInfo(taskPackageDO, upEqva, timeSheetId);
                saveTaskInfoS.add(taskInfo);
            }
            Long taskPackageId = taskPackageDO.getId();
            String taskPackageName = taskPackageDO.getTaskPackageName();
            Long reasonId = taskPackageDO.getReasonId();
            String reasonName = taskPackageDO.getReasonName();
            String reasonType = taskPackageDO.getReasonType();
            Long taskId = taskInfo.getId();
            String taskName = taskInfo.getTaskName();
            //优先处理已有的任务包和任务值
            timeSheets.forEach(timesheetPayload -> {
                timesheetPayload.setTaskPackageId(taskPackageId);
                timesheetPayload.setTaskPackageName(taskPackageName);
                timesheetPayload.setTaskId(taskId);
                timesheetPayload.setTaskName(taskName);
                timesheetPayload.setReasonName(reasonName);
                timesheetPayload.setReasonId(reasonId);
                timesheetPayload.setReasonType(reasonType);
            });
        });
        //保存成员
        if (saveProjMemberS.size() > 0) {
            pmsProjectMembersDAO.saveAll(saveProjMemberS);
        }
        //保存任务
        List<TaskInfoDO> taskInfoDOS = new ArrayList<>();
        if (saveTaskInfoS.size() > 0) {
            taskInfoDOS = taskInfoDAO.saveAll(saveTaskInfoS);
        }
        //处理返回值
        List<TaskInfoDO> finalTaskInfoDOS = taskInfoDOS;
        payloads.forEach(payload -> {
            TimesheetVO vo = new TimesheetVO();
            vo.setId(payload.getId());
            vo.setTaskPackageId(payload.getTaskPackageId());
            vo.setTaskPackageName(payload.getTaskPackageName());
            vo.setReasonId(payload.getReasonId());
            vo.setReasonName(payload.getReasonName());
            vo.setReasonType(payload.getReasonType());
            Optional<TaskInfoDO> first = finalTaskInfoDOS.stream().filter(taskInfoDO -> taskInfoDO.getTaskPackageId().equals(payload.getTaskPackageId())).findFirst();
            if (first.isPresent()) {
                TaskInfoDO taskInfoDO = first.get();
                vo.setTaskId(taskInfoDO.getId());
                vo.setTaskNo(taskInfoDO.getTaskNo());
                vo.setTaskName(taskInfoDO.getTaskName());
            } else {
                vo.setTaskId(payload.getTaskId());
                vo.setTaskNo(payload.getTaskNo());
                vo.setTaskName(payload.getTaskName());
            }
            timesheetVOS.add(vo);
        });
        return timesheetVOS;
    }

    @Override
    public List<TimesheetVO> queryTaskTimeSheets(List<Long> taskIds, List<String> tsStatusList) {
        TimesheetQuery query = new TimesheetQuery();
        query.setTaskIdList(taskIds);
        query.setTsStatusList(tsStatusList);
        List<TimesheetDO> all = timesheetRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
        return TimesheetConvert.INSTANCE.toVoList(all);
    }

    /**
     * 创建项目成员
     *
     * @return
     */
    PmsProjectMembersDO createProjMember(TaskPackageDO taskPackage) {
        PmsProjectMembersDO memberDO = new PmsProjectMembersDO();
        memberDO.setTaskPackageId(taskPackage.getId());
        memberDO.setPlanStartDate(taskPackage.getStartDate());
        memberDO.setPlanEndDate(taskPackage.getEndDate());
        memberDO.setCapasetLevelId(taskPackage.getCompositeAbilityId());
        memberDO.setResId(taskPackage.getReceiverResId());
        memberDO.setProjId(taskPackage.getReasonId());
        return memberDO;
    }

    /**
     * 创建任务
     *
     * @return
     */
    TaskInfoDO createTaskInfo(TaskPackageDO taskPackage, BigDecimal upEqva, Long timeSheetId) {
        BigDecimal zero = BigDecimal.ZERO;
        TaskInfoDO taskInfoDO = new TaskInfoDO();
        // TK+两位年份+两位月份+两位日期+三位序列号 TK231130001
        taskInfoDO.setTaskNo(generateSeqNum("TASK_NO"));
        taskInfoDO.setTaskPackageId(taskPackage.getId());
        taskInfoDO.setTaskName(taskPackage.getTaskPackageName());
        taskInfoDO.setDisterResId(taskPackage.getDisterResId());
        taskInfoDO.setTaskResId(taskPackage.getReceiverResId());
        taskInfoDO.setPlanStartDate(taskPackage.getStartDate());
        taskInfoDO.setPlanEndDate(taskPackage.getEndDate());
        taskInfoDO.setTotalEqva(upEqva);
        taskInfoDO.setSettledEqva(zero);
        taskInfoDO.setSplitEqva(zero);
        taskInfoDO.setOriginalEqva(upEqva);
        taskInfoDO.setPlanEqva(upEqva);
        taskInfoDO.setTaskStatus(TaskStatusEnum.INPROCESS.getCode());
        taskInfoDO.setBw8Flag(1);
        taskInfoDO.setSourceType(TaskSourceTypeEnum.BANGWO8.getCode());
        taskInfoDO.setSourceId(timeSheetId);
        return taskInfoDO;
    }

    /**
     * 创建任务包
     *
     * @return
     */
    TaskPackageDO createTaskPackage(PmsProjectVO pmsProjectVO, Long userId, BigDecimal eqvaRatio) {
        //获取主能力
        PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery = new PrdEmployeCompositeAbilityQuery();
        prdEmployeCompositeAbilityQuery.setUserId(userId);
        prdEmployeCompositeAbilityQuery.setMainFlag(true);
        List<PrdEmployeCompositeAbilityVO> employeCompositeAbilityVOS = prdEmployeCompositeAbilityService.getList(prdEmployeCompositeAbilityQuery);
        Long compositeAbilityId = null;

        if (!ObjectUtils.isEmpty(employeCompositeAbilityVOS)) {
            compositeAbilityId = employeCompositeAbilityVOS.get(0).getId();
        }
        //获取资源收入价格
        CalResourcePriceQuery query = new CalResourcePriceQuery();
        query.setResId(userId);
        query.setProjId(pmsProjectVO.getId());
        BigDecimal bigDecimal = calResourceService.queryIncomePrice(query);

        TaskPackageDO taskPackageDO = new TaskPackageDO();
        taskPackageDO.setAcceptMethod(AcceptMethodEnum.TASK_PACKAGE.getCode());
        taskPackageDO.setAcceptorId(pmsProjectVO.getPmResId());
        taskPackageDO.setAutoSettleFlag(1);
        taskPackageDO.setCompositeAbilityId(compositeAbilityId);
        taskPackageDO.setDisterResId(pmsProjectVO.getPmResId());
        taskPackageDO.setEndDate(pmsProjectVO.getPlanEndDate());
        taskPackageDO.setEqvaRatio(eqvaRatio);
        taskPackageDO.setGuaranteeRate(BigDecimal.ZERO);
        taskPackageDO.setIncomePrice(bigDecimal);
        taskPackageDO.setPricingMethod(PricingMethodEnum.SINGLE.getCode());
        taskPackageDO.setReasonId(pmsProjectVO.getId());
        taskPackageDO.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
        taskPackageDO.setReasonName(pmsProjectVO.getProjName());
        taskPackageDO.setReceiverResId(userId);
        taskPackageDO.setReceiverBuId(cacheUtil.getDefaultOrgIdByUserId(userId));
        taskPackageDO.setSettlePrice(pmsProjectVO.getEqvaPrice());
        taskPackageDO.setTaskPackageDes("帮我吧自动生成任务包");
        taskPackageDO.setStartDate(pmsProjectVO.getPlanStartDate());
        taskPackageDO.setTaskPackageStatus(TaskStatusEnum.INPROCESS.getCode());
        taskPackageDO.setTaskPackageType("CONVENTION_TASK_PACKAGE");
        //任务包名称：系统自动生成，生成规则：项目名称+任务包+资源姓名+开始日期~结束日期，举例：柠萌项目任务包-丁元梦-2023/11/01~2023/11/20
        String taskPackageName = pmsProjectVO.getProjName() + "任务包-" + cacheUtil.getUserName(userId) + "-" + taskPackageDO.getStartDate().toString() + "~" + taskPackageDO.getEndDate().toString();
        taskPackageDO.setTaskPackageName(taskPackageName);
        return taskPackageDO;
    }
}
