package com.elitesland.tw.tw5.server.prd.ts.controller;


import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingPayload;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsNotaskApprovalConfigPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsNotaskApprovalConfigQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsNotaskApprovalConfigService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsNotaskApprovalConfigVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

/**
 * 无任务工时审批配置
 *
 * @author zoey
 * @date 2024-04-30
 */
@Api(tags = "无任务工时审批配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/tsNotaskApprovalConfig")
@Slf4j
public class TsNotaskApprovalConfigController {

private final TsNotaskApprovalConfigService tsNotaskApprovalConfigService;

    /**
     * TsNotaskApprovalConfigController-新增前置校验
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/insertCheck")
    @UdcNameClass
    @ApiOperation("TsNotaskApprovalConfigController-新增前置校验")
    public TwOutputUtil<Integer> insertCheck(@RequestBody TsNotaskApprovalConfigPayload payload){
        return TwOutputUtil.ok(tsNotaskApprovalConfigService.insertCheck(payload));
    }


    /**
     * 无任务工时审批配置-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("无任务工时审批配置-新增")
    public TwOutputUtil<TsNotaskApprovalConfigVO> insert(@RequestBody TsNotaskApprovalConfigPayload payload){
         return TwOutputUtil.ok(tsNotaskApprovalConfigService.insert(payload));
    }

    /**
     * 无任务工时审批配置-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("无任务工时审批配置-更新")
    public TwOutputUtil<TsNotaskApprovalConfigVO> update(@RequestBody TsNotaskApprovalConfigPayload payload){
        return TwOutputUtil.ok(tsNotaskApprovalConfigService.update(payload));
    }

    /**
     * 无任务工时审批配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("无任务工时审批配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TsNotaskApprovalConfigPayload payload){
        return TwOutputUtil.ok(tsNotaskApprovalConfigService.updateByKeyDynamic(payload));
    }

    /**
     * 无任务工时审批配置-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("无任务工时审批配置-主键查询")
    public TwOutputUtil<TsNotaskApprovalConfigVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(tsNotaskApprovalConfigService.queryByKey(key));
    }

    /**
     * 无任务工时审批配置-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("无任务工时审批配置-分页")
    public TwOutputUtil<PagingVO<TsNotaskApprovalConfigVO>> paging(TsNotaskApprovalConfigQuery query) {
        return TwOutputUtil.ok(tsNotaskApprovalConfigService.queryPaging(query));
    }

    /**
     * 无任务工时审批配置-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("无任务工时审批配置-查询列表")
    public TwOutputUtil<List<TsNotaskApprovalConfigVO>> queryList(TsNotaskApprovalConfigQuery query) {
        return TwOutputUtil.ok(tsNotaskApprovalConfigService.queryListDynamic(query));
    }

    /**
     * 无任务工时审批配置-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("无任务工时审批配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         tsNotaskApprovalConfigService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 读取当前用户的无任务活动列表
     * 注意： tsYear前端要根据工时的workDate去动态计算
     *
     * @param workDate 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/noTaskActivityList")
    @UdcNameClass
    @ApiOperation("无任务工时审批配置-查询列表")
    public TwOutputUtil<List<PrdSystemSelectionVO>> noTaskActivityList(@RequestParam String workDate) {
        LocalDate workDateLocalDate = LocalDate.parse(workDate);
        return TwOutputUtil.ok(tsNotaskApprovalConfigService.noTaskActivityList(workDateLocalDate));
    }

}

