package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigAllowRolePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigAllowRoleQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeConfigAllowRoleService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigAllowRoleVO;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessDocTypeConfigAllowRoleConvert;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessDocTypeConfigAllowRoleDAO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessDocTypeConfigAllowRoleDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessDocTypeConfigAllowRoleRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 通用文档-文档类型访问权限
 *
 * @author duwh
 * @date 2023-12-10
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessDocTypeConfigAllowRoleServiceImpl extends BaseServiceImpl implements BusinessDocTypeConfigAllowRoleService {

    private final BusinessDocTypeConfigAllowRoleRepo businessDocTypeConfigAllowRoleRepo;
    private final BusinessDocTypeConfigAllowRoleDAO businessDocTypeConfigAllowRoleDAO;

    @Override
    public PagingVO<BusinessDocTypeConfigAllowRoleVO> queryPaging(BusinessDocTypeConfigAllowRoleQuery query){
        return businessDocTypeConfigAllowRoleDAO.queryPaging(query);
    }

    @Override
    public List<BusinessDocTypeConfigAllowRoleVO> queryListDynamic(BusinessDocTypeConfigAllowRoleQuery query){
        return businessDocTypeConfigAllowRoleDAO.queryListDynamic(query);
    }

    @Override
    public Long count(BusinessDocTypeConfigAllowRoleQuery query) {
        return businessDocTypeConfigAllowRoleDAO.count(query);
    }

    @Override
    public BusinessDocTypeConfigAllowRoleVO queryByKey(Long key) {
        BusinessDocTypeConfigAllowRoleDO entity = businessDocTypeConfigAllowRoleRepo.findById(key).orElseGet(BusinessDocTypeConfigAllowRoleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessDocTypeConfigAllowRoleVO vo = BusinessDocTypeConfigAllowRoleConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypeConfigAllowRoleVO insert(BusinessDocTypeConfigAllowRolePayload payload) {
        BusinessDocTypeConfigAllowRoleDO entityDo = BusinessDocTypeConfigAllowRoleConvert.INSTANCE.toDo(payload);
        return BusinessDocTypeConfigAllowRoleConvert.INSTANCE.toVo(businessDocTypeConfigAllowRoleRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypeConfigAllowRoleVO update(BusinessDocTypeConfigAllowRolePayload payload) {
        BusinessDocTypeConfigAllowRoleDO entity = businessDocTypeConfigAllowRoleRepo.findById(payload.getId()).orElseGet(BusinessDocTypeConfigAllowRoleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessDocTypeConfigAllowRoleDO entityDo = BusinessDocTypeConfigAllowRoleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessDocTypeConfigAllowRoleConvert.INSTANCE.toVo(businessDocTypeConfigAllowRoleRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessDocTypeConfigAllowRolePayload payload) {
        BusinessDocTypeConfigAllowRoleDO entity = businessDocTypeConfigAllowRoleRepo.findById(payload.getId()).orElseGet(BusinessDocTypeConfigAllowRoleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessDocTypeConfigAllowRoleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessDocTypeConfigAllowRoleDAO.deleteSoft(keys);
        }
    }

}
