package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccBusinessItemPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccBusinessItemQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccBusinessItemService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBusinessItemVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 核算项目管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Api(tags = "核算项目管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/acc/accBusinessItem")
@Slf4j
public class AccBusinessItemController {

    private final AccBusinessItemService accBusinessItemService;

    /**
     * 核算项目管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("核算项目管理-新增")
    public TwOutputUtil<AccBusinessItemVO> insert(@RequestBody AccBusinessItemPayload payload) {
        return TwOutputUtil.ok(accBusinessItemService.insert(payload));
    }


    /**
     * 核算项目管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("核算项目管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccBusinessItemPayload payload) {
        return TwOutputUtil.ok(accBusinessItemService.updateByKeyDynamic(payload));
    }

    /**
     * 核算项目管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("核算项目管理-主键查询")
    public TwOutputUtil<AccBusinessItemVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accBusinessItemService.queryByKey(key));
    }

    /**
     * 核算项目管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("核算项目管理-分页")
    public TwOutputUtil<PagingVO<AccBusinessItemVO>> paging(AccBusinessItemQuery query) {
        return TwOutputUtil.ok(accBusinessItemService.queryPaging(query));
    }

    /**
     * 核算项目管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("核算项目管理-查询列表")
    public TwOutputUtil<List<AccBusinessItemVO>> queryList(AccBusinessItemQuery query) {
        return TwOutputUtil.ok(accBusinessItemService.queryListDynamic(query));
    }

    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/batchExport")
    public void batchExport(HttpServletResponse response, AccBusinessItemQuery query) {
        accBusinessItemService.downloadPlus(response, query);
    }

    /**
     * 批量导入excel
     *
     * @return result
     */
    @ApiOperation("批量导入excel")
    @PostMapping(value = "/batchImport", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public TwOutputUtil batchImport(MultipartFile file) {
        accBusinessItemService.batchImport(file);
        return TwOutputUtil.ok();
    }
//    /**
//     * 核算项目管理-删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("核算项目管理-删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        accBusinessItemService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }

}

