package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 预算项目管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Entity
@Table(name = "acc_budget_item", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_budget_item", comment = "预算项目管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccBudgetItemDO extends BaseModel implements Serializable {
    /**
     * 预算编码
     */
    @Comment("预算编码")
    @Column()
    private String budgetCode;
    /**
     * 预算名称
     */
    @Comment("预算名称")
    @Column()
    private String budgetName;
    /**
     * 上级id
     */
    @Comment("上级id")
    @Column()
    private Long parentId;
    /**
     * 上级编号
     */
    @Comment("上级编号")
    @Column()
    private String parentCode;
    /**
     * 科目状态
     */
    @Comment("科目状态")
    @Column()
    private String budgetStatus;
    /**
     * 级别
     */
    @Comment("级别")
    @Column()
    private Integer budgetLevel;
    /**
     * 汇总科目（0：否，1：是）
     */
    @Comment("汇总科目（0：否，1：是）")
    @Column()
    private Integer sumFlag;
    /**
     * 明细账
     */
    @Comment("明细账")
    @Column()
    private String dtlAcc;
    /**
     * 处理码
     */
    @Comment("处理码")
    @Column()
    private String procCode;
    /**
     * 子账标记
     */
    @Comment("子账标记")
    @Column()
    private Integer ledgerFlag;
    /**
     * 子账类型
     */
    @Comment("子账类型")
    @Column()
    private String ledgerType;
    /**
     * 大类
     */
    @Comment("大类")
    @Column()
    private String budgetType1;
    /**
     * 明细类1
     */
    @Comment("明细类1")
    @Column()
    private String budgetType2;
    /**
     * 明细类2
     */
    @Comment("明细类2")
    @Column()
    private String budgetType3;
    /**
     * 可配置字段1
     */
    @Comment("可配置字段1")
    @Column()
    private String extStr1;
    /**
     * 可配置字段2
     */
    @Comment("可配置字段2")
    @Column()
    private String extStr2;
    /**
     * 可配置字段3
     */
    @Comment("可配置字段3")
    @Column()
    private String extStr3;
    /**
     * 可配置字段4
     */
    @Comment("可配置字段4")
    @Column()
    private String extStr4;
    /**
     * 可配置字段5
     */
    @Comment("可配置字段5")
    @Column()
    private String extStr5;

    public void copy(AccBudgetItemDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
