package com.elitesland.tw.tw5.server.prd.budget.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 预算拨付基本信息
 *
 * @author xxb
 * @date 2023-11-01
 */
@Entity
@Table(name = "pms_budget_appropriation", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_budget_appropriation", comment = "预算拨付基本信息")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BudgetAppropriationDO extends BaseModel implements Serializable {
    /**
     * 预算ID
     */
    @Comment("预算ID")
    @Column()
    private Long budgetId;
    /**
     * 拨付单号
     */
    @Comment("拨付单号")
    @Column()
    private String appropriationNo;
    /**
     * 拨付状态
     */
    @Comment("拨付状态")
    @Column()
    private String appropriationStatus;
    /**
     * 申请人资源ID
     */
    @Comment("申请人资源ID")
    @Column()
    private Long resId;

    /**
     * 申请费用金额
     */
    @Comment("申请费用金额")
    @Column()
    private BigDecimal applyFeeAmt;

    /**
     * 申请拨付当量数
     */
    @Comment("申请拨付当量数")
    @Column()
    private BigDecimal applyEqva;
    /**
     * 申请拨付当量金额
     */
    @Comment("申请拨付当量金额")
    @Column()
    private BigDecimal applyEqvaAmt;

    /**
     * 申请总金额
     */
    @Comment("申请总金额")
    @Column()
    private BigDecimal applyAmt;

//    /** 拨付金额 */
//    @Comment("拨付金额")
//    @Column()
//    private BigDecimal amt;

    /**
     * 申请日期
     */
    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;
    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /**
     * 流程审批状态
     */
    @Comment("流程审批状态")
    @Column()
    private Integer procInstStatus;
    /**
     * 审批时间
     */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;
    /**
     * 拨款名称
     */
    @Comment("拨款名称")
    @Column()
    private String appropriationName;
    /**
     * 拨款日期
     */
    @Comment("拨款日期")
    @Column()
    private LocalDate appropriationDate;
    /**
     * 拨付附件
     */
    @Comment("拨付附件")
    @Column()
    private String appropriationFiles;
    /**
     * 流程定义的KEY
     */
    @Comment("流程定义的KEY")
    @Column()
    private String procDefKey;
    /**
     * 拨付类型：科目、活动
     */
    @Comment("拨付类型：科目、活动")
    @Column()
    private String appropriationType;
    /**
     * 拨付当量
     */
    @Comment("拨付当量")
    @Column()
    private BigDecimal allocateEqva;
    /**
     * 拨付费用
     */
    @Comment("拨付费用")
    @Column()
    private BigDecimal allocateCost;

    public void copy(BudgetAppropriationDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
