package com.elitesland.tw.tw5.server.prd.cal.controller;

import com.elitesland.tw.tw5.api.prd.cal.query.CalResourcePriceQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalResourceService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 核算通用配置管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Api(tags = "核算通用配置管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/cal/calResource")
@Slf4j
public class CalResourceController {

    private final CalResourceService calResourceService;


    /**
     * 核算--获取结算价格
     *
     * @param query 查询条件
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/querySettlePrice")
    @ApiOperation("核算--获取结算价格")
    public TwOutputUtil querySettlePrice(CalResourcePriceQuery query) {
        return TwOutputUtil.ok(calResourceService.querySettlePrice(query));
    }

    /**
     * 核算--获取任务包资源收入价格
     *
     * @param query 查询条件
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryIncomePrice")
    @ApiOperation("核算--获取任务包资源收入价格")
    public TwOutputUtil queryIncomePrice(CalResourcePriceQuery query) {
        return TwOutputUtil.ok(calResourceService.queryIncomePrice(query));
    }

    /**
     * 核算--重置账户数据
     *
     * @param
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/resetAccount")
    @ApiOperation("核算--重置账户数据")
    public TwOutputUtil resetAccount(String auType, String operType, String remark) {
        calResourceService.resetAccount(auType, operType, remark);
        return TwOutputUtil.ok();
    }

}

