package com.elitesland.tw.tw5.server.prd.cas.service;


import com.elitesland.tw.tw5.api.prd.cas.service.PrdCasSettingService;
import com.elitesland.tw.tw5.server.prd.cas.convert.PrdCasSettingConvert;
import com.elitesland.tw.tw5.server.prd.cas.dao.PrdCasSettingDAO;
import com.elitesland.tw.tw5.server.prd.cas.entity.PrdCasSettingDO;
import com.elitesland.tw.tw5.api.prd.cas.payload.PrdCasSettingPayload;
import com.elitesland.tw.tw5.api.prd.cas.query.PrdCasSettingQuery;
import com.elitesland.tw.tw5.server.prd.cas.repo.PrdCasSettingRepo;
import com.elitesland.tw.tw5.api.prd.cas.vo.PrdCasSettingVO;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;

import java.util.*;

/**
 * cas_setting
 *
 * @author zoey
 * @date 2024-01-25
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdCasSettingServiceImpl extends BaseServiceImpl implements PrdCasSettingService {

    private final PrdCasSettingRepo prdCasSettingRepo;
    private final PrdCasSettingDAO prdCasSettingDAO;

    @Override
    public PagingVO<PrdCasSettingVO> queryPaging(PrdCasSettingQuery query){
        return prdCasSettingDAO.queryPaging(query);
    }

    @Override
    public List<PrdCasSettingVO> queryListDynamic(PrdCasSettingQuery query){
        return prdCasSettingDAO.queryListDynamic(query);
    }

    @Override
    public PrdCasSettingVO queryByKey(Long key) {
        PrdCasSettingDO entity = prdCasSettingRepo.findById(key).orElseGet(PrdCasSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdCasSettingVO vo = PrdCasSettingConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    public PrdCasSettingVO queryByAppId(String appId) {
        PrdCasSettingDO entity = prdCasSettingDAO.queryByAppId(appId);
        Assert.notNull(entity.getId(), "不存在");
        PrdCasSettingVO vo = PrdCasSettingConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdCasSettingVO insert(PrdCasSettingPayload payload) {
        PrdCasSettingDO entityDo = PrdCasSettingConvert.INSTANCE.toDo(payload);
        return PrdCasSettingConvert.INSTANCE.toVo(prdCasSettingRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdCasSettingVO update(PrdCasSettingPayload payload) {
        PrdCasSettingDO entity = prdCasSettingRepo.findById(payload.getId()).orElseGet(PrdCasSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdCasSettingDO entityDo = PrdCasSettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdCasSettingConvert.INSTANCE.toVo(prdCasSettingRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PrdCasSettingPayload payload) {
        PrdCasSettingDO entity = prdCasSettingRepo.findById(payload.getId()).orElseGet(PrdCasSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = prdCasSettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            prdCasSettingDAO.deleteSoft(keys);
        }
    }

}
