package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshorePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOffshoreService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author zoey
 * 近海管理
 * @date 2022/5/20 - 16:15
 */
@Api("近海管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmOffshoreController {

    private final CrmOffshoreService service;
    private final CrmLeadsService leadsService;
    /**
     * 新建或修改
     * @param payload po类
     * @return result
     */
    @ApiOperation("新增和修改")
    @PostMapping("/offshore/saveOne")
    public TwOutputUtil insert(@RequestBody CrmOffshorePayload payload) {
        CrmOffshoreVO vo = service.saveOne(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 局部字段更新
     * @param payload po类
     * @return result
     */
    @PostMapping("/offshore/dynamicUpdate")
    public TwOutputUtil dynamicUpdate(@RequestBody CrmOffshorePayload payload) {
        service.dynamicUpdate(payload);
        return TwOutputUtil.ok();
    }



    /**
     * 列表查询不分页(默认列表)
     * @param query 查询参数
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/offshore/list")
    public TwOutputUtil queryList(CrmOffshoreQuery query) {
        List<CrmOffshoreListVO> list = service.queryList(query);
        return TwOutputUtil.ok(list);
    }

    /**
     * 分页查询
     *
     * @return result
     */
    @GetMapping("/offshore/paging")
    public TwOutputUtil paging(CrmOffshoreQuery query) {

        return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 详情查询
     * @param id 主键
     * @return result
     */
    @ApiOperation("详情查询")
    @GetMapping("/offshore/detail/{id}")
    public TwOutputUtil queryDetail(@PathVariable Long id) {
        CrmOffshoreVO vo= service.queryDetail(id);
        return TwOutputUtil.ok(vo);
    }






    /**
     * 逻辑删除
     * @param offshoreId 主键
     * @param newOffshoreId 新主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @DeleteMapping("/offshore/delete")
    public TwOutputUtil delete(@RequestParam Long offshoreId,@RequestParam Long newOffshoreId) {
        leadsService.deleteOffshoreSoft(offshoreId,newOffshoreId);
        return TwOutputUtil.ok();
    }




    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @PostMapping("/offshore/batchExport")
    public void batchExport(HttpServletResponse response, CrmOffshoreQuery query) {
        service.downloadOffshores(response, query);
    }

    /**
     * 批量导入excel
     *
     * @return result
     */
    @ApiOperation("批量导入excel")
    @PostMapping(value = "/offshore/batchImport", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    @Transactional
    public TwOutputUtil batchImport(MultipartFile file) {
        service.importOffshores(file);
        return TwOutputUtil.ok();
    }

//    /**
//     * 测试动态发起定时任务
//     * @return result
//     */
//    @GetMapping("/offshore/scheduling")
//    public void scheduling() {
//        //新建一个定时任务
//        TimedTaskDO timedTaskDO = new TimedTaskDO();
//        timedTaskDO.setStatus(1);
//        timedTaskDO.setCron("*/5 * * * * ?");//每30秒执行一次
//        timedTaskDO.setJobName("testJob");
//        timedTaskDO.setClassName("com.elitesland.tw.tw5.server.common.scheduling.ScheduleMethodsConfig");
//        timedTaskDO.setMethod("method1");
//        TimedTaskDO add = jobService.add(timedTaskDO);
//        jobService.start(add);
//    }


}
