package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanDetailMemberListPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanDetailMemberPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailMemberQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailMemberService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailMemberVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 客户经营-经营计划参与者
 *
 * @author duwh
 * @date 2022/11/21
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmOperationPlanDetailMemberController {

    private final CrmOperationPlanDetailMemberService service;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/operationPlanDetailMember")
    public TwOutputUtil insert(CrmOperationPlanDetailMemberPayload payload) {
        return TwOutputUtil.ok(service.insert(payload));
    }

    /**
     * 批量新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/operationPlanDetailMember/saveAll")
    public TwOutputUtil saveAll(@RequestBody CrmOperationPlanDetailMemberListPayload payload) {
        return TwOutputUtil.ok(service.savaAll(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/operationPlanDetailMember")
    public TwOutputUtil update(CrmOperationPlanDetailMemberPayload payload) {
        return TwOutputUtil.ok(service.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/operationPlanDetailMember/{key}")
    @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        CrmOperationPlanDetailMemberVO prdFileVO = service.queryByKey(key);
        return TwOutputUtil.ok(prdFileVO);
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/operationPlanDetailMember/paging")
    @UdcNameClass
    public TwOutputUtil paging(CrmOperationPlanDetailMemberQuery query) {
        PagingVO<CrmOperationPlanDetailMemberVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/operationPlanDetailMember/list")
    @UdcNameClass
    public TwOutputUtil queryList(CrmOperationPlanDetailMemberQuery query) {
        List<CrmOperationPlanDetailMemberVO> vos = service.queryList(query);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/operationPlanDetailMember/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


}
