package com.elitesland.tw.tw5.server.prd.humanresources.ability.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdLevelConfigQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdLevelConfigVO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.PrdLevelConfigDO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.QPrdLevelConfigDO;

import com.querydsl.core.types.ExpressionUtils;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-10-18
 * @desc : 级别维护表RepoProc
 */

@Component
public class PrdLevelConfigDao extends BaseRepoProc<PrdLevelConfigDO> {

    private static final QPrdLevelConfigDO qPrdLevelConfigDO = QPrdLevelConfigDO.prdLevelConfigDO;


    protected PrdLevelConfigDao() {

        super(qPrdLevelConfigDO);

    }


    public PagingVO<PrdLevelConfigVO> page(PrdLevelConfigQuery prdLevelConfigQuery) {

        JPAQuery<PrdLevelConfigVO> query =
                select(PrdLevelConfigVO.class)
                        .where(bulidPredicate(prdLevelConfigQuery));
        prdLevelConfigQuery.setPaging(query);
        prdLevelConfigQuery.fillOrders(query, qPrdLevelConfigDO);
        return PagingVO.<PrdLevelConfigVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdLevelConfigDO)
                .set(qPrdLevelConfigDO.deleteFlag, 1)
                .where(qPrdLevelConfigDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdLevelConfigVO get(Long id) {

        PrdLevelConfigVO prdLevelConfigVO = select(PrdLevelConfigVO.class)
                .where(qPrdLevelConfigDO.id.eq(id))
                .fetchOne();

        return prdLevelConfigVO;

    }


    public List<PrdLevelConfigVO> getList(PrdLevelConfigQuery prdLevelConfigQuery) {

        List<PrdLevelConfigVO> res =
                select(PrdLevelConfigVO.class)
                        .where(bulidPredicate(prdLevelConfigQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdLevelConfigDO.name,
                        qPrdLevelConfigDO.state,
                        qPrdLevelConfigDO.defFlag,
                        qPrdLevelConfigDO.docNo,
                        qPrdLevelConfigDO.id,
                        qPrdLevelConfigDO.sort,
                        qPrdLevelConfigDO.createTime,
                        qPrdLevelConfigDO.remark

                )).from(qPrdLevelConfigDO);

    }


    private Predicate bulidPredicate(PrdLevelConfigQuery prdLevelConfigQuery) {

        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andLike(StringUtils.isNotBlank(prdLevelConfigQuery.getName()), qPrdLevelConfigDO.name, prdLevelConfigQuery.getName())
                .andEq(null != prdLevelConfigQuery.getState(), qPrdLevelConfigDO.state, prdLevelConfigQuery.getState())
                .andEq(null != prdLevelConfigQuery.getDefFlag(), qPrdLevelConfigDO.defFlag, prdLevelConfigQuery.getDefFlag())
                .andEq(StringUtils.isNotBlank(prdLevelConfigQuery.getDocNo()), qPrdLevelConfigDO.docNo, prdLevelConfigQuery.getDocNo())
                .build();

        return predicate;

    }


    private Predicate bulidPredicates(PrdLevelConfigQuery prdLevelConfigQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 级别名称
        if (StringUtils.isNotEmpty(prdLevelConfigQuery.getName())) {
            predicates.add(qPrdLevelConfigDO.name.eq(prdLevelConfigQuery.getName()));
        }
        // 状态
        if (null != prdLevelConfigQuery.getState()) {
            predicates.add(qPrdLevelConfigDO.state.eq(prdLevelConfigQuery.getState()));
        }
        // 是否默认
        if (null != prdLevelConfigQuery.getDefFlag()) {
            predicates.add(qPrdLevelConfigDO.defFlag.eq(prdLevelConfigQuery.getDefFlag()));
        }
        // 级别编号
        if (StringUtils.isNotEmpty(prdLevelConfigQuery.getDocNo())) {
            predicates.add(qPrdLevelConfigDO.docNo.eq(prdLevelConfigQuery.getDocNo()));
        }

        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }


    public void changeDef() {
        jpaQueryFactory.update(qPrdLevelConfigDO)
                .set(qPrdLevelConfigDO.defFlag, false)
                .where(qPrdLevelConfigDO.deleteFlag.eq(0))
                .execute();
    }

    public Long count(PrdLevelConfigQuery prdLevelConfigQuery) {
        long res = select(PrdLevelConfigVO.class)
                .where(bulidPredicates(prdLevelConfigQuery))
                .fetchCount();

        return res;
    }

}

