package com.elitesland.tw.tw5.server.prd.humanresources.examination.dao;

import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdExamTempPointDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.QPrdExamTempPointDO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdExamTempPointPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempPointVO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板-绩效考核点RepoProc
 */

@Component
public class PrdExamTempPointDao extends BaseRepoProc<PrdExamTempPointDO> {

    private static final QPrdExamTempPointDO qPrdExamTempPointDO = QPrdExamTempPointDO.prdExamTempPointDO;


    protected PrdExamTempPointDao() {

        super(qPrdExamTempPointDO);

    }


    public PagingVO<PrdExamTempPointVO> page(PrdExamTempPointQuery prdExamTempPointQuery) {

        JPAQuery<PrdExamTempPointVO> query =
                select(PrdExamTempPointVO.class)
                        .where(bulidPredicate(prdExamTempPointQuery));
        prdExamTempPointQuery.setPaging(query);
        prdExamTempPointQuery.fillOrders(query, qPrdExamTempPointDO);
        return PagingVO.<PrdExamTempPointVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdExamTempPointDO)
                .set(qPrdExamTempPointDO.deleteFlag, 1)
                .where(qPrdExamTempPointDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdExamTempPointVO get(Long id) {

        PrdExamTempPointVO prdExamTempPointVO = select(PrdExamTempPointVO.class)
                .where(qPrdExamTempPointDO.id.eq(id))
                .fetchOne();

        return prdExamTempPointVO;

    }


    public List<PrdExamTempPointVO> getList(PrdExamTempPointQuery prdExamTempPointQuery) {

        List<PrdExamTempPointVO> res =
                select(PrdExamTempPointVO.class)
                        .where(bulidPredicate(prdExamTempPointQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdExamTempPointDO.tempId,
                        qPrdExamTempPointDO.source,
                        qPrdExamTempPointDO.name,
                        qPrdExamTempPointDO.scoreType,
                        qPrdExamTempPointDO.weightRatio,
                        qPrdExamTempPointDO.standardDesc,
                        qPrdExamTempPointDO.id,
                        qPrdExamTempPointDO.createTime,
                        qPrdExamTempPointDO.remark

                )).from(qPrdExamTempPointDO);

    }


    private Predicate bulidPredicate(PrdExamTempPointQuery prdExamTempPointQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != prdExamTempPointQuery.getTempId(), qPrdExamTempPointDO.tempId, prdExamTempPointQuery.getTempId())
                .andEq(StringUtils.isNotBlank(prdExamTempPointQuery.getSource()), qPrdExamTempPointDO.source, prdExamTempPointQuery.getSource())
                .andEq(StringUtils.isNotBlank(prdExamTempPointQuery.getName()), qPrdExamTempPointDO.name, prdExamTempPointQuery.getName())
                .andEq(StringUtils.isNotBlank(prdExamTempPointQuery.getScoreType()), qPrdExamTempPointDO.scoreType, prdExamTempPointQuery.getScoreType())
                .andEq(null != prdExamTempPointQuery.getWeightRatio(), qPrdExamTempPointDO.weightRatio, prdExamTempPointQuery.getWeightRatio())
                .andEq(StringUtils.isNotBlank(prdExamTempPointQuery.getStandardDesc()), qPrdExamTempPointDO.standardDesc, prdExamTempPointQuery.getStandardDesc())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdExamTempPointQuery prdExamTempPointQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 模板id
        if (null != prdExamTempPointQuery.getTempId()) {
            predicates.add(qPrdExamTempPointDO.tempId.eq(prdExamTempPointQuery.getTempId()));
        }
        // 考核点来源
        if (StringUtils.isNotEmpty(prdExamTempPointQuery.getSource())) {
            predicates.add(qPrdExamTempPointDO.source.eq(prdExamTempPointQuery.getSource()));
        }
        // 考核点名称
        if (StringUtils.isNotEmpty(prdExamTempPointQuery.getName())) {
            predicates.add(qPrdExamTempPointDO.name.eq(prdExamTempPointQuery.getName()));
        }
        // 评分类型
        if (StringUtils.isNotEmpty(prdExamTempPointQuery.getScoreType())) {
            predicates.add(qPrdExamTempPointDO.scoreType.eq(prdExamTempPointQuery.getScoreType()));
        }
        // 权重比率
        if (null != prdExamTempPointQuery.getWeightRatio()) {
            predicates.add(qPrdExamTempPointDO.weightRatio.eq(prdExamTempPointQuery.getWeightRatio()));
        }
        // 评分标准说明
        if (StringUtils.isNotEmpty(prdExamTempPointQuery.getStandardDesc())) {
            predicates.add(qPrdExamTempPointDO.standardDesc.eq(prdExamTempPointQuery.getStandardDesc()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdExamTempPointQuery prdExamTempPointQuery) {

        long res = select(PrdExamTempPointVO.class)
                .where(bulidPredicate(prdExamTempPointQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdExamTempPointPayload prdExamTempPointPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdExamTempPointDO);

        // 模板id
        if (null != prdExamTempPointPayload.getTempId()) {
            update.set(qPrdExamTempPointDO.tempId, prdExamTempPointPayload.getTempId());
        }
        // 考核点来源
        if (StringUtils.isNotEmpty(prdExamTempPointPayload.getSource())) {
            update.set(qPrdExamTempPointDO.source, prdExamTempPointPayload.getSource());
        }
        // 考核点名称
        if (StringUtils.isNotEmpty(prdExamTempPointPayload.getName())) {
            update.set(qPrdExamTempPointDO.name, prdExamTempPointPayload.getName());
        }
        // 评分类型
        if (StringUtils.isNotEmpty(prdExamTempPointPayload.getScoreType())) {
            update.set(qPrdExamTempPointDO.scoreType, prdExamTempPointPayload.getScoreType());
        }
        // 权重比率
        if (null != prdExamTempPointPayload.getWeightRatio()) {
            update.set(qPrdExamTempPointDO.weightRatio, prdExamTempPointPayload.getWeightRatio());
        }
        // 评分标准说明
        if (StringUtils.isNotEmpty(prdExamTempPointPayload.getStandardDesc())) {
            update.set(qPrdExamTempPointDO.standardDesc, prdExamTempPointPayload.getStandardDesc());
        }
        long res = update.where(qPrdExamTempPointDO.id.eq(prdExamTempPointPayload.getId()))
                .execute();
        return res;

    }

    public Long delByTempId(Long id) {
        long res = jpaQueryFactory.update(qPrdExamTempPointDO)
                .set(qPrdExamTempPointDO.deleteFlag, 1)
                .where(qPrdExamTempPointDO.tempId.eq(id))
                .execute();
        return res;
    }

}

