package com.elitesland.tw.tw5.server.prd.inv.controller;


import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceVerDetailPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceVerDetailQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceVerDetailService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVerDetailVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 发票核销明细表
 *
 * @author zoey
 * @date 2023-12-05
 */
@Api(tags = "发票核销明细表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/invInvoiceVerDetail")
@Slf4j
public class InvInvoiceVerDetailController {

private final InvInvoiceVerDetailService invInvoiceVerDetailService;

    /**
     * 发票核销明细表-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("发票核销明细表-新增")
    public TwOutputUtil<InvInvoiceVerDetailVO> insert(@RequestBody InvInvoiceVerDetailPayload payload){
         return TwOutputUtil.ok(invInvoiceVerDetailService.insert(payload));
    }

    /**
     * 发票核销明细表-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("发票核销明细表-更新")
    public TwOutputUtil<InvInvoiceVerDetailVO> update(@RequestBody InvInvoiceVerDetailPayload payload){
        return TwOutputUtil.ok(invInvoiceVerDetailService.update(payload));
    }

    /**
     * 发票核销明细表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("发票核销明细表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody InvInvoiceVerDetailPayload payload){
        return TwOutputUtil.ok(invInvoiceVerDetailService.updateByKeyDynamic(payload));
    }

    /**
     * 发票核销明细表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("发票核销明细表-主键查询")
    public TwOutputUtil<InvInvoiceVerDetailVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(invInvoiceVerDetailService.queryByKey(key));
    }

    /**
     * 发票核销明细表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("发票核销明细表-分页")
    public TwOutputUtil<PagingVO<InvInvoiceVerDetailVO>> paging(InvInvoiceVerDetailQuery query) {
        return TwOutputUtil.ok(invInvoiceVerDetailService.queryPaging(query));
    }

    /**
     * 发票核销明细表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("发票核销明细表-查询列表")
    public TwOutputUtil<List<InvInvoiceVerDetailVO>> queryList(InvInvoiceVerDetailQuery query) {
        return TwOutputUtil.ok(invInvoiceVerDetailService.queryListDynamic(query));
    }

    /**
     * 发票核销明细表-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("发票核销明细表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         invInvoiceVerDetailService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

