package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TBusinessRulesPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TBusinessRulesQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TBusinessRulesService;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusinessRulesVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

@Api(tags = "业务规则配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/tBusinessRules")
@Slf4j
public class TBusinessRulesController {

    private final TBusinessRulesService tBusinessRulesService;

    /**
     * 业务规则配置-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/insert")
    @ApiOperation("业务规则配置-新增")
    public TwOutputUtil<TBusinessRulesVO> insert(@RequestBody TBusinessRulesPayload payload) {
        return TwOutputUtil.ok(tBusinessRulesService.insert(payload));
    }

    /**
     * 业务规则配置-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/update")
    @ApiOperation("业务规则配置-更新")
    public TwOutputUtil<TBusinessRulesVO> update(@RequestBody TBusinessRulesPayload payload) {
        return TwOutputUtil.ok(tBusinessRulesService.update(payload));
    }

    /**
     * 业务规则配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/updateDynamic")
    @ApiOperation("业务规则配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TBusinessRulesPayload payload) {
        return TwOutputUtil.ok(tBusinessRulesService.updateByKeyDynamic(payload));
    }

    /**
     * 业务规则配置-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("业务规则配置-主键查询")
    public TwOutputUtil<TBusinessRulesVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(tBusinessRulesService.queryByKey(key));
    }

    /**
     * 业务规则配置-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("业务规则配置-分页")
    public TwOutputUtil<PagingVO<TBusinessRulesVO>> paging(TBusinessRulesQuery query) {
        return TwOutputUtil.ok(tBusinessRulesService.queryPaging(query));
    }

    /**
     * 业务规则配置-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("业务规则配置-查询列表")
    public TwOutputUtil<List<TBusinessRulesVO>> queryList(TBusinessRulesQuery query) {
        return TwOutputUtil.ok(tBusinessRulesService.queryListDynamic(query));
    }

    /**
     * 业务规则配置-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务规则配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        tBusinessRulesService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
}