package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TServerApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TServerApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TServerApplyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QTServerApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TServerApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TServerApplyRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;


/**
 * 服务器申请
 *
 * @author lemon
 * @date 2023-09-23
 */
@Repository
@RequiredArgsConstructor
public class TServerApplyDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TServerApplyRepo repo;
    private final QTServerApplyDO qdo = QTServerApplyDO.tServerApplyDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TServerApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TServerApplyVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                //qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 申请人
                qdo.applyResId,
                // 申请时间
                qdo.applyDate,
                // 申请bu
                qdo.applyBuId,
                // 使用人姓名
                qdo.userResId,
                // 使用bu
                qdo.userBuId,
                // 用途
                qdo.purpose,
                // 服务器类型
                qdo.type,
                // 服务器品牌
                qdo.brand,
                // 使用范围
                qdo.useScope,
                // 预计费用
                qdo.expectAmt,
                // 费用承担bu
                qdo.expenseBuId,
                // CPU
                qdo.cpu,
                // 内存
                qdo.memory,
                // 硬盘
                qdo.hardDisk,
                // 系统类型
                qdo.sysType,
                // 生效日期
                qdo.effectiveDate,
                // 使用日期开始
                qdo.useDateStart,
                // 使用日期结束
                qdo.useDateEnd,
                // 采购合同id
                qdo.purchaseConId,
                // 申请编号
                qdo.applyNo,
                // 申请状态
                qdo.applyStatus,
                // 服务器名称
                qdo.serverName,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 提交时间
                qdo.submitTime,
                // 审批时间
                qdo.approvedTime
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TServerApplyVO> getJpaQueryWhere(TServerApplyQuery query) {
        JPAQuery<TServerApplyVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TServerApplyQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TServerApplyQuery query){
        List<Predicate> list = new ArrayList<>();
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 申请人 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyResId())) {
            list.add(qdo.applyResId.eq(query.getApplyResId()));
        }
        /** 申请时间 精确 */
        if ((!ObjectUtils.isEmpty(query.getApplyDateStart())) && (!ObjectUtils.isEmpty(query.getApplyDateEnd()))) {
            list.add(qdo.applyDate.between(query.getApplyDateStart(), query.getApplyDateEnd()));
        }
        /** 申请bu 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyBuId())) {
            list.add(qdo.applyBuId.eq(query.getApplyBuId()));
        }
        /** 使用人姓名 精确 */
        if (!ObjectUtils.isEmpty(query.getUserResId())) {
            list.add(qdo.userResId.eq(query.getUserResId()));
        }
        /** 使用bu 精确 */
        if (!ObjectUtils.isEmpty(query.getUserBuId())) {
            list.add(qdo.userBuId.eq(query.getUserBuId()));
        }
        /** 用途 精确 */
        if (!ObjectUtils.isEmpty(query.getPurpose())) {
            list.add(qdo.purpose.eq(query.getPurpose()));
        }
        /** 服务器类型 精确 */
        if (!ObjectUtils.isEmpty(query.getType())) {
            list.add(qdo.type.eq(query.getType()));
        }
        /** 服务器品牌 精确 */
        if (!ObjectUtils.isEmpty(query.getBrand())) {
            list.add(qdo.brand.eq(query.getBrand()));
        }
        /** 使用范围 精确 */
        if (!ObjectUtils.isEmpty(query.getUseScope())) {
            list.add(qdo.useScope.eq(query.getUseScope()));
        }
        /** 预计费用 精确 */
        if (!ObjectUtils.isEmpty(query.getExpectAmt())) {
            list.add(qdo.expectAmt.eq(query.getExpectAmt()));
        }
        /** 费用承担bu 精确 */
        if (!ObjectUtils.isEmpty(query.getExpenseBuId())) {
            list.add(qdo.expenseBuId.eq(query.getExpenseBuId()));
        }
        /** CPU 精确 */
        if (!ObjectUtils.isEmpty(query.getCpu())) {
            list.add(qdo.cpu.eq(query.getCpu()));
        }
        /** 内存 精确 */
        if (!ObjectUtils.isEmpty(query.getMemory())) {
            list.add(qdo.memory.eq(query.getMemory()));
        }
        /** 硬盘 精确 */
        if (!ObjectUtils.isEmpty(query.getHardDisk())) {
            list.add(qdo.hardDisk.eq(query.getHardDisk()));
        }
        /** 系统类型 精确 */
        if (!ObjectUtils.isEmpty(query.getSysType())) {
            list.add(qdo.sysType.eq(query.getSysType()));
        }
        /** 生效日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEffectiveDate())) {
            list.add(qdo.effectiveDate.eq(query.getEffectiveDate()));
        }
        /** 使用日期开始 精确 */
        if (!ObjectUtils.isEmpty(query.getUseDateStart())) {
            list.add(qdo.useDateStart.eq(query.getUseDateStart()));
        }
        /** 使用日期结束 精确 */
        if (!ObjectUtils.isEmpty(query.getUseDateEnd())) {
            list.add(qdo.useDateEnd.eq(query.getUseDateEnd()));
        }
        /** 采购合同id 精确 */
        if (!ObjectUtils.isEmpty(query.getPurchaseConId())) {
            list.add(qdo.purchaseConId.eq(query.getPurchaseConId()));
        }
        /** 申请编号 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyNo())) {
            list.add(qdo.applyNo.eq(query.getApplyNo()));
        }
        /** 申请状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyStatus())) {
            list.add(qdo.applyStatus.eq(query.getApplyStatus()));
        }
        /** 服务器名称 精确 */
        if (!ObjectUtils.isEmpty(query.getServerName())) {
            list.add(qdo.serverName.eq(query.getServerName()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 流程审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 提交时间 精确 */
        if (!ObjectUtils.isEmpty(query.getSubmitTime())) {
            list.add(qdo.submitTime.eq(query.getSubmitTime()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            list.add(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TServerApplyVO queryByKey(Long id) {
        JPAQuery<TServerApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TServerApplyVO> queryListDynamic(TServerApplyQuery query) {
        JPAQuery<TServerApplyVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TServerApplyVO> queryPaging(TServerApplyQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<TServerApplyVO> jpaQuery = getJpaQueryWhere(query);
        List<TServerApplyVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TServerApplyVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TServerApplyDO save(TServerApplyDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TServerApplyDO> saveAll(List<TServerApplyDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TServerApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 申请人
        if (payload.getApplyResId() != null) {
            update.set(qdo.applyResId, payload.getApplyResId());
        }
        // 申请时间
        if (payload.getApplyDate() != null) {
            update.set(qdo.applyDate, payload.getApplyDate());
        }
        // 申请bu
        if (payload.getApplyBuId() != null) {
            update.set(qdo.applyBuId, payload.getApplyBuId());
        }
        // 使用人姓名
        if (payload.getUserResId() != null) {
            update.set(qdo.userResId, payload.getUserResId());
        }
        // 使用bu
        if (payload.getUserBuId() != null) {
            update.set(qdo.userBuId, payload.getUserBuId());
        }
        // 用途
        if (payload.getPurpose() != null) {
            update.set(qdo.purpose, payload.getPurpose());
        }
        // 服务器类型
        if (payload.getType() != null) {
            update.set(qdo.type, payload.getType());
        }
        // 服务器品牌
        if (payload.getBrand() != null) {
            update.set(qdo.brand, payload.getBrand());
        }
        // 使用范围
        if (payload.getUseScope() != null) {
            update.set(qdo.useScope, payload.getUseScope());
        }
        // 预计费用
        if (payload.getExpectAmt() != null) {
            update.set(qdo.expectAmt, payload.getExpectAmt());
        }
        // 费用承担bu
        if (payload.getExpenseBuId() != null) {
            update.set(qdo.expenseBuId, payload.getExpenseBuId());
        }
        // CPU
        if (payload.getCpu() != null) {
            update.set(qdo.cpu, payload.getCpu());
        }
        // 内存
        if (payload.getMemory() != null) {
            update.set(qdo.memory, payload.getMemory());
        }
        // 硬盘
        if (payload.getHardDisk() != null) {
            update.set(qdo.hardDisk, payload.getHardDisk());
        }
        // 系统类型
        if (payload.getSysType() != null) {
            update.set(qdo.sysType, payload.getSysType());
        }
        // 生效日期
        if (payload.getEffectiveDate() != null) {
            update.set(qdo.effectiveDate, payload.getEffectiveDate());
        }
        // 使用日期开始
        if (payload.getUseDateStart() != null) {
            update.set(qdo.useDateStart, payload.getUseDateStart());
        }
        // 使用日期结束
        if (payload.getUseDateEnd() != null) {
            update.set(qdo.useDateEnd, payload.getUseDateEnd());
        }
        // 采购合同id
        if (payload.getPurchaseConId() != null) {
            update.set(qdo.purchaseConId, payload.getPurchaseConId());
        }
        // 申请编号
        if (payload.getApplyNo() != null) {
            update.set(qdo.applyNo, payload.getApplyNo());
        }
        // 申请状态
        if (payload.getApplyStatus() != null) {
            update.set(qdo.applyStatus, payload.getApplyStatus());
        }
        // 服务器名称
        if (payload.getServerName() != null) {
            update.set(qdo.serverName, payload.getServerName());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 提交时间
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 申请人
            if (nullFields.contains("applyResId")) {
                update.setNull(qdo.applyResId);
            }
            // 申请时间
            if (nullFields.contains("applyDate")) {
                update.setNull(qdo.applyDate);
            }
            // 申请bu
            if (nullFields.contains("applyBuId")) {
                update.setNull(qdo.applyBuId);
            }
            // 使用人姓名
            if (nullFields.contains("userResId")) {
                update.setNull(qdo.userResId);
            }
            // 使用bu
            if (nullFields.contains("userBuId")) {
                update.setNull(qdo.userBuId);
            }
            // 用途
            if (nullFields.contains("purpose")) {
                update.setNull(qdo.purpose);
            }
            // 服务器类型
            if (nullFields.contains("type")) {
                update.setNull(qdo.type);
            }
            // 服务器品牌
            if (nullFields.contains("brand")) {
                update.setNull(qdo.brand);
            }
            // 使用范围
            if (nullFields.contains("useScope")) {
                update.setNull(qdo.useScope);
            }
            // 预计费用
            if (nullFields.contains("expectAmt")) {
                update.setNull(qdo.expectAmt);
            }
            // 费用承担bu
            if (nullFields.contains("expenseBuId")) {
                update.setNull(qdo.expenseBuId);
            }
            // CPU
            if (nullFields.contains("cpu")) {
                update.setNull(qdo.cpu);
            }
            // 内存
            if (nullFields.contains("memory")) {
                update.setNull(qdo.memory);
            }
            // 硬盘
            if (nullFields.contains("hardDisk")) {
                update.setNull(qdo.hardDisk);
            }
            // 系统类型
            if (nullFields.contains("sysType")) {
                update.setNull(qdo.sysType);
            }
            // 生效日期
            if (nullFields.contains("effectiveDate")) {
                update.setNull(qdo.effectiveDate);
            }
            // 使用日期开始
            if (nullFields.contains("useDateStart")) {
                update.setNull(qdo.useDateStart);
            }
            // 使用日期结束
            if (nullFields.contains("useDateEnd")) {
                update.setNull(qdo.useDateEnd);
            }
            // 采购合同id
            if (nullFields.contains("purchaseConId")) {
                update.setNull(qdo.purchaseConId);
            }
            // 申请编号
            if (nullFields.contains("applyNo")) {
                update.setNull(qdo.applyNo);
            }
            // 申请状态
            if (nullFields.contains("applyStatus")) {
                update.setNull(qdo.applyStatus);
            }
            // 服务器名称
            if (nullFields.contains("serverName")) {
                update.setNull(qdo.serverName);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 提交时间
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
            if (nullFields.contains("deleteFlag")) {
                update.setNull(qdo.deleteFlag);
            }
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}
