package com.elitesland.tw.tw5.server.prd.my.repo;

import com.elitesland.tw.tw5.api.prd.my.query.MonthlyTimesheetQuery;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetDO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
* 工时表
*
* @author duwh
* @date 2022-12-09
*/
@Transactional
public interface TimesheetRepo extends JpaRepository<TimesheetDO, Long>, JpaSpecificationExecutor<TimesheetDO> {

    @Query(value = "update TimesheetDO set taskId = ?2,taskNo= ?3,taskName = ?4,actId=?5,actNo=?6,actName=?7 where  id =?1")
    @Modifying
    void updateByTaskId(Long timesheetId, Long taskIdV4, String taskNo, String taskName, Long actIdV4, String actNo, String actName);

    //特别注意：必须使用List<Object[]>接收
    @Query(value = "SELECT GROUP_CONCAT(id) AS groupIds,SUM(work_hour) as workHour," +
            " proj_id as projId, proj_no as projNo,proj_name as projName, " +
            " ts_status as tsStatus, appr_user_id as apprUserId,week_start_date as weekStartDate, " +
            " task_id as taskId,task_no as taskNo, task_name as taskName, " +
            " ts_user_id as tsUserId,ts_user_bu_id as tsUserBuId, ts_user_bu_name as tsUserBuName " +
            " FROM t_timesheet where delete_flag = 0 " +
            " and  if(?1 != NULL or ?1!='',ts_user_id=?1,1=1) " +
            " and  if(?2 != NULL or ?2!='',appr_user_id=?2,1=1) " +
            " and  if(?3 != NULL or ?3!='',ts_status=?3,1=1) " +
            " and  if(?4 != NULL or ?4!='',ts_user_bu_id=?4,1=1) " +
            " and  if(?5 != NULL or ?5!='',timesheet_id_v4 is null,1=1) " +
            " and  if(?6 != NULL or ?6!='',proj_name like CONCAT('%', ?6, '%') or task_name like CONCAT('%', ?6, '%'),1=1) " +
            " and  if(COALESCE (?7) IS NOT NULL ,ts_user_id in (?7),1=1) " +
            "  GROUP BY proj_id,year_week,ts_user_id,ts_status " +
            "  order by year_week desc,ts_user_id asc ",
            countQuery = "select count(*) " +
                    " FROM t_timesheet  where delete_flag = 0 " +
                    " and  if(?1 != NULL or ?1!='',ts_user_id=?1,1=1) " +
                    " and  if(?2 != NULL or ?2!='',appr_user_id=?2,1=1) " +
                    " and  if(?3 != NULL or ?3!='',ts_status=?3,1=1) " +
                    " and  if(?4 != NULL or ?4!='',ts_user_bu_id=?4,1=1) " +
                    " and  if(?5 != NULL,timesheet_id_v4 is null,1=1) " +
                    " and  if(?6 != NULL or ?6!='',proj_name like CONCAT('%', ?6, '%') or task_name like CONCAT('%', ?6, '%'),1=1) " +
                    " and  if(COALESCE (?7) IS NOT NULL,ts_user_id in (?7),1=1) " +
                    " GROUP BY proj_id,year_week,ts_user_id,ts_status " +
                    " ORDER BY work_date desc ",
            nativeQuery = true)
    Page<Object[]> pagingGroup(Long tsUserId, Long apprUserId, String tsStatus, Long tsUserBuId, Boolean timesheetIdV4IsNull, Pageable pageable, String blurryQuery, Set<Long> userIdList);

    @Query(value = "select * from t_timesheet e where e.modify_time>=?1 and (e.ts_task_iden is null or e.ts_task_iden <> 'VACATION' or (e.ts_task_iden = 'VACATION' and e.timesheet_id_v4 is null) or e.delete_flag=1)", nativeQuery = true)
    List<TimesheetDO> findByModifyTimeAfter(LocalDateTime time);

    @Query(value = "select * from t_timesheet e where e.modify_time>=?1 and e.modify_time<=?2 and (e.ts_task_iden is null or e.ts_task_iden <> 'VACATION' or (e.ts_task_iden = 'VACATION' and e.timesheet_id_v4 is null) or e.delete_flag=1)", nativeQuery = true)
    List<TimesheetDO> findByModifyTimeBetween(LocalDateTime time,LocalDateTime endTime);

    @Query(value = "select * from t_timesheet e where e.modify_time>=?1 and e.proj_id=?2 and e.delete_flag = 0 and e.ts_status<>'CREATE'", nativeQuery = true)
    List<TimesheetDO> findByProjectIdAndModifyTimeAfter(LocalDateTime time, Long projectId);

    List<TimesheetDO> queryByTimesheetIdV4In(List<Long> tw4TimesheetIds);

    @Query("select id as timesheetId,workPlanId as workPlanId from TimesheetDO where deleteFlag=0")
    List<Map<String, Object>> getTimesheetAndPlanIds();

    @Query(value = "update TimesheetDO set workPlanId = ?2 where  id =?1")
    @Modifying
    void updatePlan(Long timesheetId, Long planId);

    @Query("select id as timesheetId,timesheetIdV4 as timesheetIdV4 from TimesheetDO where deleteFlag=0")
    List<Map<String, Object>> getV4AndV5TimesheetIds();

    int countByBangwo8NoAndDeleteFlag(Long no, Integer deleteFlag);

    @Query(value = "update TimesheetDO set apprUserId = ?2,modifyTime=current_time where id in ?1")
    @Modifying
    void updateApprovingUser(List<Long> keys,Long apprUserId);

    @Query("SELECT workDate FROM TimesheetDO WHERE deleteFlag=0 AND tsUserId = ?3 AND workDate between ?1 and ?2 GROUP BY workDate")
    List<LocalDate> queryTsDateList(LocalDate firstDay, LocalDate lastDay, Long tsUserId);

    @Query(value = "SELECT id,proj_id as projId,TS_USER_ID as tsUserId FROM T_TIMESHEET WHERE TIMESHEET_ID_V4 IS NULL AND TS_STATUS<>'APPROVED' AND proj_id IS NOT NULL AND PROJ_ID<>0 AND task_id IS NULL AND DELETE_FLAG=0 AND WORK_DATE BETWEEN '2023-01-01' AND '2023-06-31'",nativeQuery = true)
    List<Map<String,Object>> queryTimeSheetToRepair();

    @Query(value = "SELECT TASK_ID as taskId,TASK_NO as taskNo,task_name as taskName,act_id as actId,act_no as actNo,act_name as actName FROM t_timesheet WHERE proj_id=?1 " +
            "AND ts_user_id=?2 AND delete_flag=0 AND TASK_ID IS NOT NULL ORDER BY MODIFY_TIME desc limit 1",nativeQuery = true)
    Map<String,Object> queryTimeSheetToCopy(BigInteger projId, BigInteger tsUserId);

    @Query(value = "UPDATE T_TIMESHEET SET TASK_ID=?1,TASK_NO=?2,task_name=?3,act_id=?4,act_no=?5,act_name=?6,MODIFY_TIME=NOW(),TS_STATUS='APPROVED' WHERE id=?7 ",nativeQuery = true)
    @Modifying
    void updateTimesheetByCopy(BigInteger taskId,String taskNo,String taskName,BigInteger actId,String actNo,String actName,BigInteger id);

    @Query("select sum(workHour) from TimesheetDO where deleteFlag=0 and tsUserId=?1 and workDate=?2")
    BigDecimal queryWorkHour(Long userId, LocalDate workDate);

    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update T_TIMESHEET set modify_time=now()  where id=?1",nativeQuery = true)
    @Modifying
    void updateModifyTime(Long id);

    @Query(value = """
    SELECT
            concat('00', O2.JDE_OU_NO) as prjAscriptionOuNO,
            concat('00', O2.JDE_OU_NO) as resAscriptionOuNO,
            TS_D.year,
            TS_D.monthly,
            TS_D.resNo,
            B3.org_name as resBu,
            TS_D.employeeName,
            case
                when length(trim(productNo)) > 0 then productNo
                when TS_D.REASON_TYPE = 'PROJ_CONTRACT' then ifnull(replace(TS_D.USERDEFINED_NO, 'PJ', ''), TS_D.CONTRACT_NO)
                else concat(O2.JDE_OU_NO, B1.jde_org_code)
            end as refContractNo,
            TS_D.prjName,
            B2.org_name as deliverBu,
            TS_D.contractNo,
            ROUND(SUM(TS_D.WORK_HOUR) / 8, 2) as days,
            TS_D.EQVA_RATIO as eqvaRatio,
            ROUND(TS_D.EQVA_RATIO * SUM(TS_D.WORK_HOUR) / 8, 2) as settleEqva,
            TS_D.productNo,
            TS_D.PJTYPE as pjType,
            TS_D.PJTYPE1 as pjType1
        FROM
            (
            SELECT
                right(year(TS.WORK_DATE),2) as year,
                month(TS.WORK_DATE) as monthly,
                if(RES.ext_string6 = 'EXTERNAL_RES',CONCAT('外部: ', RES.employee_name),RES.employee_name) as employeeName,
                res.book_id,
                RES.eqva_ratio,
                SO.code as contractNo,
                replace(CONCAT(left(RES.RES_NO, 3), right(RES.RES_NO, 4)), 'R', '80') as resNo,
                case
                    when TS.REASON_TYPE = 'PROJ_CONTRACT' then PJ.PROJ_NAME
                    when TS.task_package_id is not null then TS.task_package_name
                    else '无项目'
                end as prjName,
                if(TS.REASON_TYPE = 'PROJ_CONTRACT' and SO.WORK_TYPE in ('DEVELOP', 'MANAGE', 'SPECIAL'), PJ.product_no,'') as productNo,
                TS.REASON_TYPE,
                SO.refer_code as USERDEFINED_NO,
                SO.code as CONTRACT_NO,
                case
                    when TS.REASON_TYPE = 'PROJ_CONTRACT' then 4   
                    when TS.REASON_TYPE = 'PROJ_OPPO' then 1     
                    when TS.REASON_TYPE = 'PROJ_BU' then 2   
                    else 3
                end as PJTYPE1,
                case
                    when TS.REASON_TYPE = 'PROJ_CONTRACT' then '项目'
                    WHEN TS.REASON_TYPE = 'PROJ_OPPO' THEN '售前'
                    when TS.REASON_TYPE = 'PROJ_BU' then 'BU任务'
                    ELSE '无项目'
                end as PJTYPE,
                case
                    when TS.REASON_TYPE = 'PROJ_CONTRACT' then SO.DELI_BU_ID
                    when TS.REASON_TYPE in ('PROJ_OPPO') then op.pre_sale_org_id
                    when TS.REASON_TYPE in ('PROJ_BU') then PJ1.deli_bu_id
                    else t3.org_id
                end as COST_BUID,
                RES.company_id as RE_OUID,
                TS.ts_user_id as TS_RES_ID,
                t3.org_id as BASE_BU_ID,
                case
                    when TS.REASON_TYPE = 'PROJ_CONTRACT' then SO.DELI_BU_ID
                    else null
                end as DELI_BU_ID,
                sum(TS.WORK_HOUR) as WORK_HOUR,
                DC1.selection_name as TS_STATUS
            from
                T_TIMESHEET TS
            inner join T_VACATION VC on TS.WORK_DATE = VC.NATURAL_DATE
            left join prd_org_employee RES on TS.ts_user_id = RES.user_id and RES.delete_flag = 0
            left join (
                select
                    distinct ref1.user_id,
                    ref1.org_id
                from
                    prd_org_employee_ref ref1
                inner join (
                    select
                        user_id,
                        max(modify_time) as modify_time
                    from
                        prd_org_employee_ref ref21
                    where
                        ref21.is_default = 0
                    group by user_id
                ) ref2 on ref1.user_id = ref2.user_id and ref1.modify_time = ref2.modify_time and ref1.is_default = 0
            ) t3 on RES.user_id = t3.user_id
            left join prd_org_organization t2 on t3.org_id = t2.ID
            left join pms_task_package TSK1 on TSK1.id = ts.task_package_id
            left join pms_project PJ on TSK1.reason_id = PJ.ID and PJ.delete_flag = 0 and TSK1.REASON_TYPE = 'PROJ_CONTRACT'
            left join bu_project PJ1 on PJ1.id = TSK1.reason_id and pj1.delete_flag = 0 and TSK1.REASON_TYPE = 'PROJ_BU'
            left join prj_project PJ2 on PJ2.id = TSK1.reason_id and pj2.delete_flag = 0 and TSK1.REASON_TYPE = 'PROJ_OPPO'
            left join crm_opportunity op on op.project_id = PJ2.id
            left join sale_con_contract SO on PJ.CONTRACT_ID = SO.ID and SO.delete_flag = 0
            left join prd_system_selection DC1 on DC1.parent_id = 636587649485772223 and DC1.selection_value = TS.TS_STATUS
            where
                TS.WORK_DATE between :#{#query.workDateStart} and :#{#query.workDateEnd}
                and TS.TS_STATUS in :#{#query.status}
                and (:#{#query.resType} is null OR RES.ext_string6 = :#{#query.resType})
                and (:#{#query.tsUserId} is null OR TS.TS_USER_ID = :#{#query.tsUserId})
                and not(TS.TS_TASK_IDEN = 'VACATION' and ifnull(TS.TS_ACT_IDEN, ' ') in ('PERSONAL', 'MATERNITYLEAVE'))
                and VC.delete_flag = 0
                and VC.WORK_HOURS = 8
                and TS.delete_flag = 0
                and t2.organization_type <> 'BS'
            group by
                year,
                monthly,
                employeeName,
                book_id,
                RES.eqva_ratio,
                contractNo,
                resNo,
                prjName,
                productNo,
                PJTYPE,
                COST_BUID,
                RE_OUID,
                TS.ts_user_id,
                t3.org_id,
                SO.DELI_BU_ID,
                DC1.selection_name
            ) TS_D
        left join prd_org_organization B1 on TS_D.COST_BUID = B1.id and B1.delete_flag = 0
        left join prd_org_organization B2 on TS_D.DELI_BU_ID = B2.ID and B2.delete_flag = 0
        left join prd_org_organization B3 on TS_D.BASE_BU_ID = B3.ID and B3.delete_flag = 0
        left join fin_db.TW_JDE_OU O2 on o2.TW_OU_ID = TS_D.book_id
        group by
            prjAscriptionOuNO,
        	resAscriptionOuNO,
        	year,
        	monthly,
        	employeeName,
        	resNo,
        	B3.org_name,
        	B2.org_name,
        	productNo,
        	pjType,
        	refContractNo,
        	pjType1
        having (:#{#query.refContractNo} is null OR refContractNo = :#{#query.refContractNo})
        order by
            year,
            monthly,
            resNo,
            refContractNo,
            days
    """
            , nativeQuery = true)
    List<Object[]> queryMonthlyTimesheetVO(@Param("query") MonthlyTimesheetQuery query);

    @Query(value = "SELECT work_date from ( SELECT work_date,SUM(work_hour) sumWorkHour FROM T_TIMESHEET WHERE delete_flag=0 AND ts_user_id = ?3 AND work_date between ?1 and ?2 AND ts_status in (\"APPROVED\",\"APPROVING\") GROUP BY work_date) temp where sumWorkHour>=8",nativeQuery = true)
    List<Date> queryWritedTsDateList(LocalDate startDate, LocalDate endDate, Long userId);
}
