package com.elitesland.tw.tw5.server.prd.partner.identity.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCollaboratePartnerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCollaboratePartnerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCollaboratePartnerInfoVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessCollaboratePartnerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessCollaboratePartnerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessCollaboratePartnerInfoRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 业务伙伴-合作伙伴
 *
 * @author wangly
 * @date 2023-05-16
 */
@Repository
@RequiredArgsConstructor
public class BusinessCollaboratePartnerInfoDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessCollaboratePartnerInfoRepo repo;
    private final QBusinessCollaboratePartnerInfoDO qdo = QBusinessCollaboratePartnerInfoDO.businessCollaboratePartnerInfoDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessCollaboratePartnerInfoVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessCollaboratePartnerInfoVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                //qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 业务伙伴id
                qdo.partnerId,
                // 合作状态 udc[BUSINESS:CUSTOMER:STATUS]
                qdo.collaborateStatus,
                // 合作等级 udc[crm:customer_grade]
                qdo.collaborateGradle,
                // 合作产品
                qdo.collaborateProduct,
                // 合作开始时间
                qdo.startTime,
                // 合作结束时间
                qdo.endTime,
                // 合作期间说明
                qdo.collaborateDescription,
                // 产品介绍附件
                qdo.fileCodes1,
                // 合作协议附件
                qdo.fileCodes2,
                // 扩展字段1
                qdo.ext1,
                // 扩展字段2
                qdo.ext2,
                // 扩展字段3
                qdo.ext3,
                // 扩展字段4
                qdo.ext4,
                // 扩展字段5
                qdo.ext5,
                // 合作形式
                qdo.collaborateForm,
                // 合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE]
                qdo.collaborateType,
                // 伙伴服务行业
                qdo.collaborateServiceIndustry,
                // 服务典型客户
                qdo.collaborateCustomer,
                // 服务客户规模
                qdo.serviceCustomerScale,
                // 渠道负责人
                qdo.channelUserId,
                // 合作区域 udc[crm:customer_region]
                qdo.collaborateRegion,
                // 对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE]
                qdo.contactPeopleType,
                // 我司负责人bu
                qdo.buManageUserId,
                // 我司负责人电话
                qdo.buManagePhone,
                // 我司负责人邮箱
                qdo.buManageEmail,
                // 合作伙伴标签
                qdo.collaborateTag,
                // 合作伙伴关键词
                qdo.collaborateKeyword,
                // 公司介绍附件
                qdo.fileCodes3
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessCollaboratePartnerInfoVO> getJpaQueryWhere(BusinessCollaboratePartnerInfoQuery query) {
        JPAQuery<BusinessCollaboratePartnerInfoVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessCollaboratePartnerInfoQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessCollaboratePartnerInfoQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 业务伙伴id 精确 */
        if (!ObjectUtils.isEmpty(query.getPartnerId())) {
            list.add(qdo.partnerId.eq(query.getPartnerId()));
        }
        /** 合作状态 udc[BUSINESS:CUSTOMER:STATUS] 精确 */
        if (!ObjectUtils.isEmpty(query.getCollaborateStatus())) {
            list.add(qdo.collaborateStatus.eq(query.getCollaborateStatus()));
        }
        /** 合作等级 udc[crm:customer_grade] 精确 */
        if (!ObjectUtils.isEmpty(query.getCollaborateGradle())) {
            list.add(qdo.collaborateGradle.eq(query.getCollaborateGradle()));
        }
        /** 合作产品 精确 */
        if (!ObjectUtils.isEmpty(query.getCollaborateProduct())) {
            list.add(qdo.collaborateProduct.eq(query.getCollaborateProduct()));
        }
        /** 合作开始时间 精确 */
        if (!ObjectUtils.isEmpty(query.getStartTime())) {
            list.add(qdo.startTime.eq(query.getStartTime()));
        }
        /** 合作结束时间 精确 */
        if (!ObjectUtils.isEmpty(query.getEndTime())) {
            list.add(qdo.endTime.eq(query.getEndTime()));
        }
        /** 合作期间说明 精确 */
        if (!ObjectUtils.isEmpty(query.getCollaborateDescription())) {
            list.add(qdo.collaborateDescription.eq(query.getCollaborateDescription()));
        }
        /** 产品介绍附件 精确 */
        if (!ObjectUtils.isEmpty(query.getFileCodes1())) {
            list.add(qdo.fileCodes1.eq(query.getFileCodes1()));
        }
        /** 合作协议附件 精确 */
        if (!ObjectUtils.isEmpty(query.getFileCodes2())) {
            list.add(qdo.fileCodes2.eq(query.getFileCodes2()));
        }
        /** 扩展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 扩展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 扩展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 扩展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 扩展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        /** 合作形式 精确 */
        if (!ObjectUtils.isEmpty(query.getCollaborateForm())) {
            list.add(qdo.collaborateForm.eq(query.getCollaborateForm()));
        }
        /** 合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE] 精确 */
        if (!ObjectUtils.isEmpty(query.getCollaborateType())) {
            list.add(qdo.collaborateType.eq(query.getCollaborateType()));
        }
        /** 伙伴服务行业 精确 */
        if (!ObjectUtils.isEmpty(query.getCollaborateServiceIndustry())) {
            list.add(qdo.collaborateServiceIndustry.eq(query.getCollaborateServiceIndustry()));
        }
        /** 服务典型客户 精确 */
        if (!ObjectUtils.isEmpty(query.getCollaborateCustomer())) {
            list.add(qdo.collaborateCustomer.eq(query.getCollaborateCustomer()));
        }
        /** 服务客户规模 精确 */
        if (!ObjectUtils.isEmpty(query.getServiceCustomerScale())) {
            list.add(qdo.serviceCustomerScale.eq(query.getServiceCustomerScale()));
        }
        /** 渠道负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getChannelUserId())) {
            list.add(qdo.channelUserId.eq(query.getChannelUserId()));
        }
        /** 合作区域 udc[crm:customer_region] 精确 */
        if (!ObjectUtils.isEmpty(query.getCollaborateRegion())) {
            list.add(qdo.collaborateRegion.eq(query.getCollaborateRegion()));
        }
        /** 对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE] 精确 */
        if (!ObjectUtils.isEmpty(query.getContactPeopleType())) {
            list.add(qdo.contactPeopleType.eq(query.getContactPeopleType()));
        }
        /** 我司负责人bu 精确 */
        if (!ObjectUtils.isEmpty(query.getBuManageUserId())) {
            list.add(qdo.buManageUserId.eq(query.getBuManageUserId()));
        }
        /** 我司负责人电话 精确 */
        if (!ObjectUtils.isEmpty(query.getBuManagePhone())) {
            list.add(qdo.buManagePhone.eq(query.getBuManagePhone()));
        }
        /** 我司负责人邮箱 精确 */
        if (!ObjectUtils.isEmpty(query.getBuManageEmail())) {
            list.add(qdo.buManageEmail.eq(query.getBuManageEmail()));
        }
        /** 合作伙伴关键词 精确 */
        if (!ObjectUtils.isEmpty(query.getCollaborateTag())) {
            list.add(qdo.collaborateTag.eq(query.getCollaborateTag()));
        }
        /** 合作伙伴关键词 精确 */
        if (!ObjectUtils.isEmpty(query.getCollaborateKeyword())) {
            list.add(qdo.collaborateKeyword.eq(query.getCollaborateKeyword()));
        }
        /** 公司介绍附件 精确 */
        if (!ObjectUtils.isEmpty(query.getFileCodes3())) {
            list.add(qdo.fileCodes3.eq(query.getFileCodes3()));
        }
        return ExpressionUtils.allOf(list);
    }


    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessCollaboratePartnerInfoVO queryByKey(Long id) {
        JPAQuery<BusinessCollaboratePartnerInfoVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessCollaboratePartnerInfoVO> queryListDynamic(BusinessCollaboratePartnerInfoQuery query) {
        JPAQuery<BusinessCollaboratePartnerInfoVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessCollaboratePartnerInfoVO> queryPaging(BusinessCollaboratePartnerInfoQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessCollaboratePartnerInfoVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessCollaboratePartnerInfoVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessCollaboratePartnerInfoVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessCollaboratePartnerInfoDO save(BusinessCollaboratePartnerInfoDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessCollaboratePartnerInfoDO> saveAll(List<BusinessCollaboratePartnerInfoDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessCollaboratePartnerInfoPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 业务伙伴id
        if (payload.getPartnerId() != null) {
            update.set(qdo.partnerId, payload.getPartnerId());
        }
        // 合作状态 udc[BUSINESS:CUSTOMER:STATUS]
        if (payload.getCollaborateStatus() != null) {
            update.set(qdo.collaborateStatus, payload.getCollaborateStatus());
        }
        // 合作等级 udc[crm:customer_grade]
        if (payload.getCollaborateGradle() != null) {
            update.set(qdo.collaborateGradle, payload.getCollaborateGradle());
        }
        // 合作产品
        if (payload.getCollaborateProduct() != null) {
            update.set(qdo.collaborateProduct, payload.getCollaborateProduct());
        }
        // 合作开始时间
        if (payload.getStartTime() != null) {
            update.set(qdo.startTime, payload.getStartTime());
        }
        // 合作结束时间
        if (payload.getEndTime() != null) {
            update.set(qdo.endTime, payload.getEndTime());
        }
        // 合作期间说明
        if (payload.getCollaborateDescription() != null) {
            update.set(qdo.collaborateDescription, payload.getCollaborateDescription());
        }
        // 产品介绍附件
        if (payload.getFileCodes1() != null) {
            update.set(qdo.fileCodes1, payload.getFileCodes1());
        }
        // 合作协议附件
        if (payload.getFileCodes2() != null) {
            update.set(qdo.fileCodes2, payload.getFileCodes2());
        }
        // 扩展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 扩展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 扩展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 扩展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 扩展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 合作形式
        if (payload.getCollaborateForm() != null) {
            update.set(qdo.collaborateForm, payload.getCollaborateForm());
        }
        // 合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE]
        if (payload.getCollaborateType() != null) {
            update.set(qdo.collaborateType, payload.getCollaborateType());
        }
        // 伙伴服务行业
        if (payload.getCollaborateServiceIndustry() != null) {
            update.set(qdo.collaborateServiceIndustry, payload.getCollaborateServiceIndustry());
        }
        // 服务典型客户
        if (payload.getCollaborateCustomer() != null) {
            update.set(qdo.collaborateCustomer, payload.getCollaborateCustomer());
        }
        // 服务客户规模
        if (payload.getServiceCustomerScale() != null) {
            update.set(qdo.serviceCustomerScale, payload.getServiceCustomerScale());
        }
        // 渠道负责人
        if (payload.getChannelUserId() != null) {
            update.set(qdo.channelUserId, payload.getChannelUserId());
        }
        // 合作区域 udc[crm:customer_region]
        if (payload.getCollaborateRegion() != null) {
            update.set(qdo.collaborateRegion, payload.getCollaborateRegion());
        }
        // 对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE]
        if (payload.getContactPeopleType() != null) {
            update.set(qdo.contactPeopleType, payload.getContactPeopleType());
        }
        // 我司负责人bu
        if (payload.getBuManageUserId() != null) {
            update.set(qdo.buManageUserId, payload.getBuManageUserId());
        }
        // 我司负责人电话
        if (payload.getBuManagePhone() != null) {
            update.set(qdo.buManagePhone, payload.getBuManagePhone());
        }
        // 我司负责人邮箱
        if (payload.getBuManageEmail() != null) {
            update.set(qdo.buManageEmail, payload.getBuManageEmail());
        }
        // 合作伙伴关键词
        if (payload.getCollaborateKeyword() != null) {
            update.set(qdo.collaborateKeyword, payload.getCollaborateKeyword());
        }
        // 公司介绍附件
        if (payload.getFileCodes3() != null) {
            update.set(qdo.fileCodes3, payload.getFileCodes3());
        }

        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 提交时间
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 业务伙伴id
            if (nullFields.contains("partnerId")) {
                update.setNull(qdo.partnerId);
            }
            // 合作状态 udc[BUSINESS:CUSTOMER:STATUS]
            if (nullFields.contains("collaborateStatus")) {
                update.setNull(qdo.collaborateStatus);
            }
            // 合作等级 udc[crm:customer_grade]
            if (nullFields.contains("collaborateGradle")) {
                update.setNull(qdo.collaborateGradle);
            }
            // 合作产品
            if (nullFields.contains("collaborateProduct")) {
                update.setNull(qdo.collaborateProduct);
            }
            // 合作开始时间
            if (nullFields.contains("startTime")) {
                update.setNull(qdo.startTime);
            }
            // 合作结束时间
            if (nullFields.contains("endTime")) {
                update.setNull(qdo.endTime);
            }
            // 合作期间说明
            if (nullFields.contains("collaborateDescription")) {
                update.setNull(qdo.collaborateDescription);
            }
            // 产品介绍附件
            if (nullFields.contains("fileCodes1")) {
                update.setNull(qdo.fileCodes1);
            }
            // 合作协议附件
            if (nullFields.contains("fileCodes2")) {
                update.setNull(qdo.fileCodes2);
            }
            // 扩展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 扩展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 扩展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 扩展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 扩展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
            // 合作形式
            if (nullFields.contains("collaborateForm")) {
                update.setNull(qdo.collaborateForm);
            }
            // 合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE]
            if (nullFields.contains("collaborateType")) {
                update.setNull(qdo.collaborateType);
            }
            // 伙伴服务行业
            if (nullFields.contains("collaborateServiceIndustry")) {
                update.setNull(qdo.collaborateServiceIndustry);
            }
            // 服务典型客户
            if (nullFields.contains("collaborateCustomer")) {
                update.setNull(qdo.collaborateCustomer);
            }
            // 服务客户规模
            if (nullFields.contains("serviceCustomerScale")) {
                update.setNull(qdo.serviceCustomerScale);
            }
            // 渠道负责人
            if (nullFields.contains("channelUserId")) {
                update.setNull(qdo.channelUserId);
            }
            // 合作区域 udc[crm:customer_region]
            if (nullFields.contains("collaborateRegion")) {
                update.setNull(qdo.collaborateRegion);
            }
            // 对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE]
            if (nullFields.contains("contactPeopleType")) {
                update.setNull(qdo.contactPeopleType);
            }
            // 我司负责人bu
            if (nullFields.contains("buManageUserId")) {
                update.setNull(qdo.buManageUserId);
            }
            // 我司负责人电话
            if (nullFields.contains("buManagePhone")) {
                update.setNull(qdo.buManagePhone);
            }
            // 我司负责人邮箱
            if (nullFields.contains("buManageEmail")) {
                update.setNull(qdo.buManageEmail);
            }
            // 合作伙伴关键词
            if (nullFields.contains("collaborateKeyword")) {
                update.setNull(qdo.collaborateKeyword);
            }
            // 公司介绍附件
            if (nullFields.contains("fileCodes3")) {
                update.setNull(qdo.fileCodes3);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 提交时间
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

