package com.elitesland.tw.tw5.server.prd.partner.strategy.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyRefPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyRefQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyCustomerVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyRefVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyRefDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.QBusinessStrategyRefDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyRefRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 分级策略业务伙伴映射关系
 *
 * @author wanlgy
 * @date 2023-06-19
 */
@Repository
@RequiredArgsConstructor
public class BusinessStrategyRefDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessStrategyRefRepo repo;
    private final QBusinessStrategyRefDO qdo = QBusinessStrategyRefDO.businessStrategyRefDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QBusinessCustomerInfoDO qBusinessCustomerInfoDO = QBusinessCustomerInfoDO.businessCustomerInfoDO;
    private final QCrmCustomerOperationDO qCrmCustomerOperationDO = QCrmCustomerOperationDO.crmCustomerOperationDO;
    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessStrategyRefVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessStrategyRefVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 分级策略id business_strategy.id
                qdo.strategyId,
                // 业务伙伴id business_partner.id
                qdo.partnerId,
                // 选项分数
                qdo.optionScore,
                // 排序号
                qdo.sortNo,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3,
                // 拓展字段4
                qdo.ext4,
                // 拓展字段5
                qdo.ext5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessStrategyRefVO> getJpaQueryWhere(BusinessStrategyRefQuery query) {
        JPAQuery<BusinessStrategyRefVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessStrategyRefQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessStrategyRefQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 分级策略id business_strategy.id 精确 */
        if (!ObjectUtils.isEmpty(query.getStrategyId())) {
            list.add(qdo.strategyId.eq(query.getStrategyId()));
        }
        /** 业务伙伴id business_partner.id 精确 */
        if (!ObjectUtils.isEmpty(query.getPartnerId())) {
            list.add(qdo.partnerId.eq(query.getPartnerId()));
        }
        /** 选项分数 精确 */
        if (!ObjectUtils.isEmpty(query.getOptionScore())) {
            list.add(qdo.optionScore.eq(query.getOptionScore()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessStrategyRefVO queryByKey(Long id) {
        JPAQuery<BusinessStrategyRefVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessStrategyRefVO> queryListDynamic(BusinessStrategyRefQuery query) {
        JPAQuery<BusinessStrategyRefVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessStrategyRefVO> queryPaging(BusinessStrategyRefQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessStrategyRefVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessStrategyRefVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessStrategyRefVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessStrategyRefDO save(BusinessStrategyRefDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessStrategyRefDO> saveAll(List<BusinessStrategyRefDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessStrategyRefPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 分级策略id business_strategy.id
        if (payload.getStrategyId() != null) {
            update.set(qdo.strategyId, payload.getStrategyId());
        }
        // 业务伙伴id business_partner.id
        if (payload.getPartnerId() != null) {
            update.set(qdo.partnerId, payload.getPartnerId());
        }
        // 选项分数
        if (payload.getOptionScore() != null) {
            update.set(qdo.optionScore, payload.getOptionScore());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 分级策略id business_strategy.id
            if (nullFields.contains("strategyId")) {
                update.setNull(qdo.strategyId);
            }
            // 业务伙伴id business_partner.id
            if (nullFields.contains("partnerId")) {
                update.setNull(qdo.partnerId);
            }
            // 选项分数
            if (nullFields.contains("optionScore")) {
                update.setNull(qdo.optionScore);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public long deleteSoftByStrategyId(Long strategyId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.strategyId.eq(strategyId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public List<BusinessStrategyRefVO> findByStrategyId(Long stratrgyId){
        JPAQuery<BusinessStrategyRefVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BusinessStrategyRefVO.class,
                qdo.id,
                qdo.strategyId,
                // 业务伙伴id business_partner.id
                qdo.partnerId,
                // 业务伙伴名称
                qBusinessPartnerDO.partnerName

        )).from(qdo).leftJoin(qBusinessPartnerDO).on(qdo.partnerId.eq(qBusinessPartnerDO.id));
        jpaQuery.where(qdo.strategyId.eq(stratrgyId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }
    //查询指定的业务伙伴信息
    public List<BusinessStrategyCustomerVO> queryAppointCustomerInfoByStrategyId(Long stratrgyId){

        JPAQuery<BusinessStrategyCustomerVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BusinessStrategyCustomerVO.class,
                qBusinessCustomerInfoDO.id,
                        //业务伙伴id
                        qBusinessPartnerDO.id.as("partnerId"),
                        //性质
                        qBusinessPartnerDO.partnerNature,
                        //组织规模
                        qBusinessPartnerDO.organizationScale,
                        //与公司紧密度
                        qCrmCustomerOperationDO.companyTightness,
                        //行业地位
                        qCrmCustomerOperationDO.industryStand,
                        //经营策略
                        qCrmCustomerOperationDO.businessStrategy

        )).from(qdo).leftJoin(qBusinessPartnerDO).on(qdo.partnerId.eq(qBusinessPartnerDO.id)).
                leftJoin(qCrmCustomerOperationDO).on(qdo.partnerId.eq(qCrmCustomerOperationDO.customerId)).
                leftJoin(qBusinessCustomerInfoDO).on(qdo.partnerId.eq(qBusinessCustomerInfoDO.partnerId)).
                where(qBusinessPartnerDO.deleteFlag.eq(0)).
                where(qBusinessCustomerInfoDO.deleteFlag.eq(0));
                jpaQuery.where(qdo.strategyId.eq(stratrgyId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }
}

