package com.elitesland.tw.tw5.server.prd.partner.team.repo;

import com.elitesland.tw.tw5.server.prd.partner.team.entity.BusinessTeamMemberDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

/**
 * 业务伙伴-团队成员
 *
 * @author wangly
 * @date 2023-05-16
 */
public interface BusinessTeamMemberRepo extends JpaRepository<BusinessTeamMemberDO, Long>, JpaSpecificationExecutor<BusinessTeamMemberDO> {

    /**
     * 通过objectId删除团队成员
     *
     * @param objectId
     * @return jpaQuery对象
     */
    void deleteByObjectId(Long objectId);

    List<BusinessTeamMemberDO> findByDeleteFlagAndMemberRoleAndObjectIdIn(Integer deleteFlag, String memberRole, List<Long> ids);
}
