package com.elitesland.tw.tw5.server.prd.pms.common.functionEnum;

import lombok.Getter;

/**
 * 拨付类型
 */
public enum ProjActivityAllocateTypeEnum {

    ACTIVITY("ACTIVITY", "活动"),
    SUBJECT("SUBJECT", "科目");

    @Getter
    private String type;

    @Getter
    private String desc;

    ProjActivityAllocateTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDesc(String type) {
        ProjActivityAllocateTypeEnum[] twRelatedDocTypeEnum = values();
        for (ProjActivityAllocateTypeEnum docType : twRelatedDocTypeEnum) {
            if (docType.getType().equalsIgnoreCase(type)) {
                return docType.getDesc();
            }
        }
        return null;
    }
}
