package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectActivityPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectActivityQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectActivityDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectActivityDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectActivityRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目活动
 *
 * @author xxb
 * @date 2023-08-17
 */
@Repository
@RequiredArgsConstructor
public class PmsProjectActivityDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectActivityRepo repo;
    private final QPmsProjectActivityDO qdo = QPmsProjectActivityDO.pmsProjectActivityDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectActivityVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectActivityVO.class,
                qdo.id,
                qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 项目id
                qdo.projId,
                // 活动编号
                qdo.actNo,
                // 活动名称
                qdo.actName,
                // 是否里程碑标志
                qdo.milestoneFlag,
                // 是否阶段标志
                qdo.phaseFlag,
                // 是否来自模板标志
                qdo.fromtmplFlag,
                // 起日期
                qdo.startDate,
                // 止日期
                qdo.endDate,
                // 排序号
                qdo.sortNo,
                // 工作台显示标志
                qdo.workbenchFlag,
                // 收款计划ID
                qdo.receivePlanId,
                // 拨付状态
                qdo.allocateStatus,
                // 拨付费用
                qdo.allocateCost,
                // 拨付当量
                qdo.allocateEqva,
                // 已派发当量
                qdo.distedEqva,
                // 规划当量
                qdo.planEqva,
                // 原始规划当量
                qdo.originalPlanEqva,
                // 明细控制标志
                qdo.detailControlFlag,
                // 占用当量数
                qdo.occupyEqva,
                // 已使用当量数
                qdo.usedEqva,
                qdo.usedEqvaProportion,
                qdo.usedAmtProportion
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectActivityVO> getJpaQueryWhere(PmsProjectActivityQuery query) {
        JPAQuery<PmsProjectActivityVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        List<OrderItem> orderse = new ArrayList<>();
        orderse.add(OrderItem.asc("sortNo"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, orderse));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PmsProjectActivityQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        Long total = jpaQuery.fetchOne();
        total=total==null?0L:total;
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PmsProjectActivityQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        if (!ObjectUtils.isEmpty(query.getIds())) {
            list.add(qdo.id.in(query.getIds()));
        }
        /** 项目id 精确 */
        if (!ObjectUtils.isEmpty(query.getProjId())) {
            list.add(qdo.projId.eq(query.getProjId()));
        }
        /** 活动编号 精确 */
        if (!ObjectUtils.isEmpty(query.getActNo())) {
            list.add(qdo.actNo.eq(query.getActNo()));
        }
        /** 活动名称 精确 */
        if (!ObjectUtils.isEmpty(query.getActName())) {
            list.add(qdo.actName.eq(query.getActName()));
        }
        /** 是否里程碑标志 精确 */
        if (!ObjectUtils.isEmpty(query.getMilestoneFlag())) {
            list.add(qdo.milestoneFlag.eq(query.getMilestoneFlag()));
        }
        /** 是否阶段标志 精确 */
        if (!ObjectUtils.isEmpty(query.getPhaseFlag())) {
            list.add(qdo.phaseFlag.eq(query.getPhaseFlag()));
        }
        /** 是否来自模板标志 精确 */
        if (!ObjectUtils.isEmpty(query.getFromtmplFlag())) {
            list.add(qdo.fromtmplFlag.eq(query.getFromtmplFlag()));
        }
        /** 起日期 精确 */
        if (!ObjectUtils.isEmpty(query.getStartDate())) {
            list.add(qdo.startDate.eq(query.getStartDate()));
        }
        /** 止日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            list.add(qdo.endDate.eq(query.getEndDate()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 工作台显示标志 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkbenchFlag())) {
            list.add(qdo.workbenchFlag.eq(query.getWorkbenchFlag()));
        }
        /** 收款计划ID 精确 */
        if (!ObjectUtils.isEmpty(query.getReceivePlanId())) {
            list.add(qdo.receivePlanId.eq(query.getReceivePlanId()));
        }
        // 明细控制标志
        if (!ObjectUtils.isEmpty(query.getDetailControlFlag())) {
            list.add(qdo.detailControlFlag.eq(query.getDetailControlFlag()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsProjectActivityVO queryByKey(Long id) {
        JPAQuery<PmsProjectActivityVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 结果
     */
    public List<PmsProjectActivityVO> queryByKeys(List<Long> ids) {
        JPAQuery<PmsProjectActivityVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 根据项目id查询
     *
     * @param projId 项目id
     * @return 结果
     */
    public List<PmsProjectActivityVO> queryByProjId(Long projId) {
        JPAQuery<PmsProjectActivityVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.projId.eq(projId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, getOrders(null)));
        return jpaQuery.fetch();
    }

    /**
     * 排序
     *
     * @param orders
     * @return
     */
    private List<OrderItem> getOrders(List<OrderItem> orders) {
        if (ObjectUtils.isEmpty(orders)) {
            // 序号 升序
            orders = new ArrayList<>();
            OrderItem orderItem = new OrderItem();
            orderItem.setColumn("sortNo");
            orders.add(orderItem);
        }
        return orders;
    }


    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectActivityVO> queryListDynamic(PmsProjectActivityQuery query) {
        JPAQuery<PmsProjectActivityVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PmsProjectActivityVO> queryPaging(PmsProjectActivityQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PmsProjectActivityVO> jpaQuery = getJpaQueryWhere(query);
        List<PmsProjectActivityVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PmsProjectActivityVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PmsProjectActivityDO save(PmsProjectActivityDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsProjectActivityDO> saveAll(List<PmsProjectActivityDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PmsProjectActivityPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 项目id
        if (payload.getProjId() != null) {
            update.set(qdo.projId, payload.getProjId());
        }
        // 活动编号
        if (payload.getActNo() != null) {
            update.set(qdo.actNo, payload.getActNo());
        }
        // 活动名称
        if (payload.getActName() != null) {
            update.set(qdo.actName, payload.getActName());
        }
        // 是否里程碑标志
        if (payload.getMilestoneFlag() != null) {
            update.set(qdo.milestoneFlag, payload.getMilestoneFlag());
        }
        // 是否阶段标志
        if (payload.getPhaseFlag() != null) {
            update.set(qdo.phaseFlag, payload.getPhaseFlag());
        }
        // 是否来自模板标志
        if (payload.getFromtmplFlag() != null) {
            update.set(qdo.fromtmplFlag, payload.getFromtmplFlag());
        }
        // 起日期
        if (payload.getStartDate() != null) {
            update.set(qdo.startDate, payload.getStartDate());
        }
        // 止日期
        if (payload.getEndDate() != null) {
            update.set(qdo.endDate, payload.getEndDate());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 工作台显示标志
        if (payload.getWorkbenchFlag() != null) {
            update.set(qdo.workbenchFlag, payload.getWorkbenchFlag());
        }
        // 收款计划ID
        if (payload.getReceivePlanId() != null) {
            update.set(qdo.receivePlanId, payload.getReceivePlanId());
        }
        // 拨付状态
        if (payload.getAllocateStatus() != null) {
            update.set(qdo.allocateStatus, payload.getAllocateStatus());
        }
        // 拨付当量
        if (payload.getAllocateEqva() != null) {
            update.set(qdo.allocateEqva, payload.getAllocateEqva());
        }
        // 拨款金额
        if (payload.getAllocateCost() != null) {
            update.set(qdo.allocateCost, payload.getAllocateCost());
        }
        // 规划当量
        if (payload.getPlanEqva() != null) {
            update.set(qdo.planEqva, payload.getPlanEqva());
        }
        // 备注
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 明细控制标志
        if (payload.getDetailControlFlag() != null) {
            update.set(qdo.detailControlFlag, payload.getDetailControlFlag());
        }
        // 占用当量数
        if (payload.getOccupyEqva() != null) {
            update.set(qdo.occupyEqva, payload.getOccupyEqva());
        }
        // 已使用当量数
        if (payload.getUsedEqva() != null) {
            update.set(qdo.usedEqva, payload.getUsedEqva());
        }
        if (payload.getUsedEqvaProportion() != null) {
            update.set(qdo.usedEqvaProportion, payload.getUsedEqvaProportion());
        }
        if (payload.getUsedAmtProportion() != null) {
            update.set(qdo.usedAmtProportion, payload.getUsedAmtProportion());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 项目id
            if (nullFields.contains("projId")) {
                update.setNull(qdo.projId);
            }
            // 活动编号
            if (nullFields.contains("actNo")) {
                update.setNull(qdo.actNo);
            }
            // 活动名称
            if (nullFields.contains("actName")) {
                update.setNull(qdo.actName);
            }
            // 是否里程碑标志
            if (nullFields.contains("milestoneFlag")) {
                update.setNull(qdo.milestoneFlag);
            }
            // 是否阶段标志
            if (nullFields.contains("phaseFlag")) {
                update.setNull(qdo.phaseFlag);
            }
            // 是否来自模板标志
            if (nullFields.contains("fromtmplFlag")) {
                update.setNull(qdo.fromtmplFlag);
            }
            // 起日期
            if (nullFields.contains("startDate")) {
                update.setNull(qdo.startDate);
            }
            // 止日期
            if (nullFields.contains("endDate")) {
                update.setNull(qdo.endDate);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 工作台显示标志
            if (nullFields.contains("workbenchFlag")) {
                update.setNull(qdo.workbenchFlag);
            }
            // 收款计划ID
            if (nullFields.contains("receivePlanId")) {
                update.setNull(qdo.receivePlanId);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /***
     * 批量更改拨付状态
     * @param keys
     * @param status
     * @return
     */
    public long updateStatus(List<Long> keys, String status) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.allocateStatus, status)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

