package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementResPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementResQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementResService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementResVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 采购协议关联资源
 *
 * @author lemon
 * @date 2023-11-02
 */
@Api(tags = "采购协议关联资源")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/purchaseAgreementRes")
@Slf4j
public class PurchaseAgreementResController {

    private final PurchaseAgreementResService purchaseAgreementResService;

    /**
     * 采购协议关联资源-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("采购协议关联资源-新增")
    public TwOutputUtil<PurchaseAgreementResVO> insert(@RequestBody PurchaseAgreementResPayload payload){
        return TwOutputUtil.ok(purchaseAgreementResService.insert(payload));
    }

    /**
     * 采购协议关联资源-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("采购协议关联资源-更新")
    public TwOutputUtil<PurchaseAgreementResVO> update(@RequestBody PurchaseAgreementResPayload payload){
        return TwOutputUtil.ok(purchaseAgreementResService.update(payload));
    }

    /**
     * 采购协议关联资源-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("采购协议关联资源-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PurchaseAgreementResPayload payload){
        return TwOutputUtil.ok(purchaseAgreementResService.updateByKeyDynamic(payload));
    }

    /**
     * 采购协议关联资源-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("采购协议关联资源-主键查询")
    public TwOutputUtil<PurchaseAgreementResVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(purchaseAgreementResService.queryByKey(key));
    }

    /**
     * 采购协议关联资源-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("采购协议关联资源-分页")
    public TwOutputUtil<PagingVO<PurchaseAgreementResVO>> paging(PurchaseAgreementResQuery query) {
        return TwOutputUtil.ok(purchaseAgreementResService.queryPaging(query));
    }

    /**
     * 采购协议关联资源-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("采购协议关联资源-查询列表")
    public TwOutputUtil<List<PurchaseAgreementResVO>> queryList(PurchaseAgreementResQuery query) {
        return TwOutputUtil.ok(purchaseAgreementResService.queryListDynamic(query));
    }

    /**
     * 采购协议关联资源-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("采购协议关联资源-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        purchaseAgreementResService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

