package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 付款单记录
 *
 * @author likunpeng
 * @date 2023-11-23
 */
@Entity
@Table(name = "t_payment_slip", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_payment_slip", comment = "付款单记录")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PaymentSlipDO extends BaseModel implements Serializable  {
    /** 付款申请单ID */
    @Comment("付款申请单ID")
    @Column()
    private Long paymentApplyId;
    /** 付款流水号 */
    @Comment("付款流水号")
    @Column()
    private String paySerialNum;
    /** 付款银行 */
    @Comment("付款银行")
    @Column()
    private String paymentBank;
    /** 付款账号 */
    @Comment("付款账号")
    @Column()
    private String paymentAccount;
    /** 付款金额 */
    @Comment("付款金额")
    @Column()
    private BigDecimal paymentAmt;
    /** 付款公司地址簿Id */
    @Comment("付款公司")
    @Column()
    private Long payCompanyBookId;
    /** 科目说明 */
    @Comment("科目说明")
    @Column()
    private Long accMasId;
    /** 付款方式 */
    @Comment("付款方式")
    @Column()
    private String paymentMethod;
    /** 付款日期 */
    @Comment("付款日期")
    @Column()
    private LocalDate paymentDate;
    /** 收款公司 */
    @Comment("收款公司")
    @Column()
    private Long receivingCompanyBookId;
    /** 收款银行 */
    @Comment("收款银行")
    @Column()
    private String receivingBank;
    /** 收款账号 */
    @Comment("收款账号")
    @Column()
    private String receivingAccount;
    /** 状态 */
    @Comment("状态")
    @Column()
    private String state;
    /** 出纳更新时间 */
    @Comment("出纳更新时间")
    @Column()
    private LocalDateTime cashierTime;
    /** 出纳备注 */
    @Comment("出纳备注")
    @Column()
    private String cashierRemark;
    /** 应付会计更新时间 */
    @Comment("应付会计更新时间")
    @Column()
    private LocalDateTime apAccountantTime;
    /** 应付会计备注 */
    @Comment("应付会计备注")
    @Column()
    private String apAccountantRemark;
    /** 财务经理更新时间 */
    @Comment("财务经理更新时间")
    @Column()
    private LocalDateTime financeTime;
    /** 财务经理备注 */
    @Comment("财务经理备注")
    @Column()
    private String financeRemark;
    /** CFO更新时间 */
    @Comment("CFO更新时间")
    @Column()
    private LocalDateTime cfoTime;
    /** 财务经理备注 */
    @Comment("CFO备注")
    @Column()
    private String cfoRemark;
    /** 实际付款日期 */
    @Comment("实际付款日期")
    @Column()
    private LocalDate actualDate;
    /** 支付时间 */
    @Comment("支付时间")
    @Column()
    private LocalDateTime payTime;
    /** 支付状态：S 成功、F 失败、C  撤销、D 过期、R 否决 G退票 */
    @Comment("支付状态：S 成功、F 失败、C撤销、D 过期、R 否决 G退票")
    @Column()
    private String payStatus;
    /** 支付方式：1.网银支付 2.手动支付 */
    @Comment("支付方式：1.网银支付 2.手动支付")
    @Column()
    private Integer payMode;
    /** 网银提交标识 1.已提交 2.未提交 */
    @Comment("网银提交标识 1.已提交 2.未提交")
    @Column()
    private Integer bankFlag;
    /** 网银提交时间 */
    @Comment("网银提交时间")
    @Column()
    private LocalDateTime bankTime;
    /** 支付标识：1.已支付 ；2.待支付 */
    @Comment("支付标识：1.已支付 ；2.待支付")
    @Column()
    private Integer payFlag;
    /** 支付用途 */
    @Comment("支付用途")
    @Column()
    private String payPurpose;

    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    @Comment("付款凭证摘要")
    @Column()
    private String payProofDigest;

    @Comment("付款凭证号")
    @Column()
    private String payProofNo;

    @Comment("Jde批次号")
    @Column()
    private String invoiceVoucher;

    @Comment("付款凭证状态")
    @Column()
    private String payProofStatus;

    @Comment("财务付款记账审批时间")
    @Column()
    private LocalDateTime payApprovedTime;

    @Comment("付款凭证失败原因")
    @Column(name = "pay_proof_fail_reason", columnDefinition = "text comment '付款凭证失败原因'")
    private String payProofFailReason;

    /**
     * 付款凭证
     */
    @Comment("JDE批次号")
    @Column()
    private String jdeVoucher;
    /** jde单据公司 */
    @Comment("jde单据公司")
    @Column()
    private String jdeCompany;
    /** jde单据号  */
    @Comment("jde单据号 ")
    @Column()
    private String jdeDocumentNo;
    /** jde单据类型 */
    @Comment("jde单据类型")
    @Column()
    private String jdeDocumentType;
    /** jde付款项 */
    @Comment("jde付款项")
    @Column()
    private String jdePaymentItem;
    @Comment("jde付款号")
    @Column()
    private String jdePayNo;

    public void copy(PaymentSlipDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
