package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 采购协议
 *
 * @author Echo
 * @date 2023-06-08
 */
@Entity
@Table(name = "t_purchase_agreement", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_purchase_agreement", comment = "采购协议")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PurchaseAgreementDO extends BaseModel implements Serializable {
    /**
     * 采购协议编号
     */
    @Comment("采购协议编号")
    @Column()
    private String purchaseAgreementNo;
    /**
     * 采购协议名称
     */
    @Comment("采购协议名称")
    @Column()
    private String purchaseAgreementName;
    /**
     * 协议类型
     */
    @Comment("协议类型 ")
    @Column()
    private String agreementType;
    /**
     * 验收方式
     */
    @Comment("验收方式 ")
    @Column()
    private String acceptanceType;
    /**
     * 签约日期
     */
    @Comment("签约日期")
    @Column()
    private LocalDate signDate;
    /**
     * 申请日期
     */
    @Comment("申请日期")
    @Column()
    private LocalDate applicationDate;
    /**
     * 申请人
     */
    @Comment("申请人")
    @Column()
    private Long applyResId;
    /**
     * 签约公司地址簿Id
     */
    @Comment("签约公司地址簿Id")
    @Column()
    private Long signCompanyBookId;

    /**
     * 签约公司地址簿Id
     */
    @Comment("采购公司/法人号 被signCompanyBookId代替")
    @Column()
    private String signingLegalNo;
    /**
     * 签约BU
     */
    @Comment("签约BU")
    @Column()
    private Long signBuId;
    /**
     * 签约负责人
     */
    @Comment("签约负责人")
    @Column()
    private Long signInchargeResId;
    /**
     * 供应商地址簿ID
     */
    @Comment("供应商地址簿ID")
    @Column()
    private Long supplierBookId;
    /**
     * 供应商地址簿ID
     */
    @Comment("供应商/法人号 被supplierBookId代替")
    @Column()
    private String supplierLegalNo;

    /**
     * 币种
     */
    @Comment("币种 ")
    @Column()
    private String currCode;
    /**
     * 金额
     */
    @Comment("金额")
    @Column()
    private BigDecimal amt;
    /**
     * 税率
     */
    @Comment("税率")
    @Column()
    private String taxRate;
    /**
     * 税额
     */
    @Comment("税额")
    @Column()
    private BigDecimal taxAmt;
    /**
     * 协议内容说明
     */
    @Comment("协议内容说明")
    @Column()
    private String agreementContentDescription;
    /**
     * 比价资料
     */
    @Comment("比价资料")
    @Column()
    private String pricecompereFileCodes;
    /**
     * 协议附件
     */
    @Comment("协议附件")
    @Column()
    private String agreementFileCodes;
    /**
     * 盖章附件
     */
    @Comment("盖章附件")
    @Column()
    private String stampFileCodes;
    /**
     * 开票方
     */
    @Comment("开票方")
    @Column()
    private Long invoice;
    /**
     * 付款方式
     */
    @Comment("付款方式")
    @Column()
    private String payMethod;
    /**
     * 协议状态
     */
    @Comment("协议状态")
    @Column()
    private String agreementStatus;
    /**
     * 协议归属编号
     */
    @Comment("协议归属编号")
    @Column()
    private String agreementOwnershipNo;
    /**
     * 激活时间
     */
    @Comment("激活时间")
    @Column()
    private LocalDateTime activateDate;
    /**
     * 前置单据负责人
     */
    @Comment("前置单据负责人")
    @Column()
    private Long preReceiptResId;
    /**
     * 终止原因
     */
    @Comment("终止原因")
    @Column()
    private String overReason;
    /**
     * 终止日期
     */
    @Comment("终止日期")
    @Column()
    private LocalDateTime overDate;

    /**
     * 采购负责人
     */
    @Comment("采购负责人")
    @Column()
    private Long purchaseInchargeResId;

    /**
     * 有效开始日期
     */
    @Comment("有效开始日期")
    @Column()
    private LocalDate effectiveStartDate;

    /**
     * 有效结束日期
     */
    @Comment("有效结束日期")
    @Column()
    private LocalDate effectiveEndDate;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;


    public void copy(PurchaseAgreementDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
