package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
@Entity
@Table(name = "t_purchase_contract_manager", indexes = {
        @Index(name = "pur_contract_no_idx", columnList = "purchase_contract_no")
})
@org.hibernate.annotations.Table(appliesTo = "t_purchase_contract_manager", comment = "采购合同管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PurchaseContractManagerDO extends BaseModel implements Serializable  {
    /** 采购合同编号 */
    @Comment("采购合同编号")
    @Column(name = "purchase_contract_no")
    private String purchaseContractNo;
    /** 采购合同名称 */
    @Comment("采购合同名称")
    @Column()
    @FieldUpdateLog(fieldName = "合同名称")
    @FieldCreateLog(fieldName = "合同名称")
    private String purchaseContractName;
    /** 平台合同类型 udc[salecon:plat_type] */
    @Comment("平台合同类型 udc[salecon:plat_type]")
    @Column()
    private String platType;
    /** 采购合同类型 udc[purchase:con_type] */
    @Comment("采购合同类型 udc[purchase:con_type]")
    @Column()
    @FieldUpdateLog(fieldName = "采购合同类型")
    @FieldCreateLog(fieldName = "采购合同类型")
    private String purchaseContractType;
    /** 业务类型 udc[purchase:business_type] */
    @Comment("业务类型 udc[purchase:business_type]")
    @Column()
    @FieldUpdateLog(fieldName = "业务类型",selectionKey = "salecon:plat_type")
    @FieldCreateLog(fieldName = "业务类型",selectionKey = "salecon:plat_type")
    private String businessType;
    /** 验收方式 udc[purchase:check] */
    @Comment("验收方式 udc[purchase:check]")
    @Column()
    @FieldUpdateLog(fieldName = "验收方式",selectionKey = "purchase:check")
    @FieldCreateLog(fieldName = "验收方式",selectionKey = "purchase:check")
    private String acceptanceType;
    /** 采购公司地址簿Id */
    @Comment("采购公司地址簿Id")
    @Column()
    @FieldUpdateLog(fieldName = "采购公司地址簿Id")
    @FieldCreateLog(fieldName = "采购公司地址簿Id")
    private Long purchaseCompanyBookId;
    /** 供应商地址簿ID */
    @Comment("供应商地址簿ID")
    @Column()
    @FieldUpdateLog(fieldName = "供应商地址簿ID")
    @FieldCreateLog(fieldName = "供应商地址簿ID")
    private Long supplierBookId;
    /** 采购BU */
    @Comment("采购BU")
    @Column()
    @FieldUpdateLog(fieldName = "采购BU",selectionKey = "BU")
    @FieldCreateLog(fieldName = "采购BU",selectionKey = "BU")
    private Long purchaseBuId;
    /** 采购负责人 */
    @Comment("采购负责人")
    @Column()
    @FieldUpdateLog(fieldName = "采购负责人",selectionKey = "USER")
    @FieldCreateLog(fieldName = "采购负责人",selectionKey = "USER")
    private Long purchaseInchargeResId;
    /** 签约日期 */
    @Comment("签约日期")
    @Column()
    @FieldUpdateLog(fieldName = "签约日期")
    @FieldCreateLog(fieldName = "签约日期")
    private LocalDate signDate;
    /** 申请日期 */
    @Comment("申请日期")
    @Column()
    @FieldUpdateLog(fieldName = "申请日期")
    @FieldCreateLog(fieldName = "申请日期")
    private LocalDate applicationDate;
    /** 币种 udc[SYSTEM_BASIC:CURRENCY] */
    @Comment("币种 udc[SYSTEM_BASIC:CURRENCY]")
    @Column()
    @FieldUpdateLog(fieldName = "币种",selectionKey = "SYSTEM_BASIC:CURRENCY")
    @FieldCreateLog(fieldName = "币种",selectionKey = "SYSTEM_BASIC:CURRENCY")
    private String currCode;
    /** 金额 */
    @Comment("金额")
    @Column()
    @FieldUpdateLog(fieldName = "金额")
    @FieldCreateLog(fieldName = "金额")
    private BigDecimal amt;
    /** 税率 */
    @Comment("税率")
    @Column()
    @FieldUpdateLog(fieldName = "税率")
    @FieldCreateLog(fieldName = "税率")
    private String taxRate;
    /** 税额 */
    @Comment("税额")
    @Column()
    @FieldUpdateLog(fieldName = "税额")
    @FieldCreateLog(fieldName = "税额")
    private BigDecimal taxAmt;
    /** 合同状态 */
    @Comment("合同状态")
    @Column()
    private String contractStatus;
    /** 审批状态 */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /** 关联销售合同 */
    @Comment("关联销售合同")
    @Column()
    @FieldUpdateLog(fieldName = "关联销售合同")
    @FieldCreateLog(fieldName = "关联销售合同")
    private Long relatedSalesContract;
    /** 关联协议 */
    @Comment("关联协议")
    @Column()
    @FieldUpdateLog(fieldName = "关联协议")
    @FieldCreateLog(fieldName = "关联协议")
    private Long relatedAgreement;
    /** 需求编号 */
    @Comment("需求编号")
    @Column()
    @FieldUpdateLog(fieldName = "需求编号")
    @FieldCreateLog(fieldName = "需求编号")
    private String demandNo;
    /** 比价资料 */
    @Comment("比价资料")
    @Column()
    @FieldUpdateLog(fieldName = "比价资料")
    @FieldCreateLog(fieldName = "比价资料")
    private String pricecompereFileCodes;
    /** 合同附件 */
    @Comment("合同附件")
    @Column()
    private String contractFileCodes;
    /** 盖章附件 */
    @Comment("盖章附件")
    @Column()
    private String stampFileCodes;
    /** 项目ID */
    @Comment("项目ID")
    @Column()
//    @FieldUpdateLog(fieldName = "项目ID")
//    @FieldCreateLog(fieldName = "项目ID")
    private Long relatedProjectId;
    /** 项目名称 */
    @Comment("项目名称")
    @Column()
    @FieldUpdateLog(fieldName = "项目名称")
    @FieldCreateLog(fieldName = "项目名称")
    private String relatedProjectName;
    /** 任务包 */
    @Comment("任务包")
    @Column()
    private Long relatedTask;
    /** 开票方 */
    @Comment("开票方")
    @Column()
    private Long invoice;
    /** 付款方式 */
    @Comment("付款方式")
    @Column()
    @FieldUpdateLog(fieldName = "付款方式")
    @FieldCreateLog(fieldName = "付款方式")
    private String payMethod;
    /** 采购来源 */
    @Comment("付款方式")
    @Column()
    @FieldUpdateLog(fieldName = "付款方式")
    @FieldCreateLog(fieldName = "付款方式")
    private String contractSource;
    /** 采购来源编号 */
    @Comment("采购来源编号")
    @Column()
    @FieldUpdateLog(fieldName = "采购来源编号")
    @FieldCreateLog(fieldName = "采购来源编号")
    private String contractSourceNo;
    /** 激活时间 */
    @Comment("激活时间")
    @Column()
    private LocalDateTime activateDate;
    /** 终止原因 */
    @Comment("终止原因")
    @Column()
    private String overWhy;
    /** 终止时间 */
    @Comment("终止时间")
    @Column()
    private LocalDateTime overDate;
    /** 合同归档标志，0：未归档，1：归档 */
    @Comment("合同归档标志，0：未归档，1：归档")
    @Column()
    private Integer filingFlag;

    // 流程相关
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;

    @Comment("4.0采购合同id")
    @Column()
    private Long purchaseContractIdV4;

    /** 关闭原因 */
    @Comment("关闭原因")
    @Column()
    private String closeReason;

    /** 关闭时间 */
    @Comment("关闭时间")
    @Column()
    private LocalDate closeDate;

    public void copy(PurchaseContractManagerDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
