package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractManagerPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractDetailsService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurConOrAgreementDetailsSimpleVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractDetailsVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseContractDetailsConvert;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseContractManagerConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseContractDetailsDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseContractDetailsDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseContractManagerDO;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseContractDetailsRepo;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseContractManagerRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PurchaseContractDetailsServiceImpl extends BaseServiceImpl implements PurchaseContractDetailsService {

    private final PurchaseContractDetailsRepo purchaseContractDetailsRepo;
    private final PurchaseContractManagerRepo purchaseContractManagerRepo;
    private final PurchaseContractDetailsDAO purchaseContractDetailsDAO;
    private final PrdSystemLogService logService;
    @Autowired
    private PurchaseContractManagerServiceImpl purchaseContractManagerService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final CacheUtil cacheUtil;

    @Override
    public PagingVO<PurchaseContractDetailsVO> queryPaging(PurchaseContractDetailsQuery query) {
        return purchaseContractDetailsDAO.queryPaging(query);
    }

    @Override
    public List<PurchaseContractDetailsVO> queryListDynamic(PurchaseContractDetailsQuery query) {
        List<PurchaseContractDetailsVO> purchaseContractDetailsVOS = purchaseContractDetailsDAO.queryListDynamic(query);
        return purchaseContractDetailsVOS;
    }

    @Override
    public PurchaseContractDetailsVO queryByKey(Long key) {
        PurchaseContractDetailsDO entity = purchaseContractDetailsRepo.findById(key).orElseGet(PurchaseContractDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PurchaseContractDetailsVO vo = PurchaseContractDetailsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchaseContractDetailsVO insert(PurchaseContractDetailsPayload payload) {
        PurchaseContractDetailsDO entity = PurchaseContractDetailsConvert.INSTANCE.toDo(payload);
        final PurchaseContractDetailsDO save = purchaseContractDetailsRepo.save(entity);
        // 获取变更日志
        final String fieldsCreateLog = changeFieldLogUtil.getFieldsCreateLog(entity);
        logService.saveNewLog(save.getId(), PrdSystemObjectEnum.PROCUREMENT_CONTRACT_DETAIL.getCode(), fieldsCreateLog);

        //修改主表的金额、税率、税额
        PurchaseContractDetailsQuery purchaseContractDetailsQuery = new PurchaseContractDetailsQuery();
        purchaseContractDetailsQuery.setPurchaseContractId(payload.getPurchaseContractId());
        List<PurchaseContractDetailsVO> vos = queryListDynamic(purchaseContractDetailsQuery);
        PurchaseContractManagerPayload purchaseContractManagerPayload = PurchaseContractManagerConvert.INSTANCE.toPayload(purchaseContractManagerService.queryByKey(payload.getPurchaseContractId()));
        PurchaseContractManagerDO purchaseContractManagerDO = PurchaseContractManagerConvert.INSTANCE.toDo(purchaseContractManagerPayload);
        purchaseContractManagerService.countTax(vos, purchaseContractManagerDO);
        purchaseContractManagerRepo.save(purchaseContractManagerDO);

        return PurchaseContractDetailsConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchaseContractDetailsVO update(PurchaseContractDetailsPayload payload) {

        PurchaseContractDetailsDO entity = purchaseContractDetailsRepo.findById(payload.getId()).orElseGet(PurchaseContractDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");

        // 变更日志用
        PurchaseContractManagerDO entityLog = new PurchaseContractManagerDO();
        BeanUtils.copyProperties(entity, entityLog);

        PurchaseContractDetailsDO entityDo = PurchaseContractDetailsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);

        // 修改NULL值特殊处理
        final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, entity);
        PurchaseContractDetailsDO save = purchaseContractDetailsRepo.save(entity);

        //获取变更日志
        fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
        if (StringUtils.hasText(fieldsUpdateLog)) {
            logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.PROCUREMENT_CONTRACT.getCode(), fieldsUpdateLog.toString());
        }

        //修改主表的金额、税率、税额
        PurchaseContractDetailsQuery purchaseContractDetailsQuery = new PurchaseContractDetailsQuery();
        purchaseContractDetailsQuery.setPurchaseContractId(payload.getPurchaseContractId());
        List<PurchaseContractDetailsVO> vos = queryListDynamic(purchaseContractDetailsQuery);
        PurchaseContractManagerPayload purchaseContractManagerPayload = PurchaseContractManagerConvert.INSTANCE.toPayload(purchaseContractManagerService.queryByKey(payload.getPurchaseContractId()));
        PurchaseContractManagerDO purchaseContractManagerDO = PurchaseContractManagerConvert.INSTANCE.toDo(purchaseContractManagerPayload);
        purchaseContractManagerService.countTax(vos, purchaseContractManagerDO);
        purchaseContractManagerRepo.save(purchaseContractManagerDO);

        return PurchaseContractDetailsConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (keys.isEmpty()) {
            return;
        }
        PurchaseContractDetailsVO purchaseContractDetailsVO = purchaseContractDetailsDAO.queryByKey(keys.get(0));
        Long purchaseContractId = purchaseContractDetailsVO.getPurchaseContractId();
        purchaseContractDetailsDAO.deleteSoft(keys);
        //修改主表的金额、税率、税额

        PurchaseContractDetailsQuery purchaseContractDetailsQuery = new PurchaseContractDetailsQuery();
        purchaseContractDetailsQuery.setPurchaseContractId(purchaseContractId);
        List<PurchaseContractDetailsVO> vos = queryListDynamic(purchaseContractDetailsQuery);
        PurchaseContractManagerPayload purchaseContractManagerPayload = PurchaseContractManagerConvert.INSTANCE.toPayload(purchaseContractManagerService.queryByKey(purchaseContractId));
        PurchaseContractManagerDO purchaseContractManagerDO = PurchaseContractManagerConvert.INSTANCE.toDo(purchaseContractManagerPayload);
        purchaseContractManagerService.countTax(vos, purchaseContractManagerDO);
        purchaseContractManagerRepo.save(purchaseContractManagerDO);
    }

    @Override
    public List<PurConOrAgreementDetailsSimpleVO> queryByPurConId(Long purConId) {
        return purchaseContractDetailsDAO.queryByPurConId(purConId);
    }

}
