package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConEpibolyCostConDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConEpibolyCostConDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConEpibolyCostConDService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Arrays;

/**
 * 外包费用确认明细
 *
 * @author likunpeng
 * @date 2023-04-17
 */
@Api(tags = "外包费用确认明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/contract/conEpibolyCostConD")
@Slf4j
public class ConEpibolyCostConDController {

    private final ConEpibolyCostConDService conEpibolyCostConDService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody ConEpibolyCostConDPayload payload) {
        return TwOutputUtil.ok(conEpibolyCostConDService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody ConEpibolyCostConDPayload payload) {
        return TwOutputUtil.ok(conEpibolyCostConDService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conEpibolyCostConDService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ConEpibolyCostConDQuery query) {
        return TwOutputUtil.ok(conEpibolyCostConDService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ConEpibolyCostConDQuery query) {
        return TwOutputUtil.ok(conEpibolyCostConDService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        conEpibolyCostConDService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 提交确认费用明细
     *
     * @param contractId 合同id
     * @param dId        明细id
     * @return r
     */
    @PostMapping("/submission")
    //@GlobalTransactional
    @ApiOperation("提交确认费用明细")
    public TwOutputUtil submission(Long contractId, Long dId) {
        conEpibolyCostConDService.submission(contractId, dId);
        return TwOutputUtil.ok();
    }

    /**
     * 按金额拆分明细
     *
     * @param amt
     * @param parentId
     * @return
     */
    @PostMapping("/splitMoney")
    @ApiOperation("按金额拆分明细")
    public TwOutputUtil splitMoney(@RequestParam("amt") BigDecimal amt, @RequestParam("parentId") Long parentId) {
        return TwOutputUtil.ok(conEpibolyCostConDService.splitMoney(amt, parentId));
    }

    /**
     * 根据父明细查询对应的子明细
     *
     * @param parentId
     * @return
     */
    @ApiOperation("根据父明细查询对应的子明细")
    @GetMapping("/queryByParentId")
    public TwOutputUtil queryByParentId(Long parentId) {
        return TwOutputUtil.ok(conEpibolyCostConDService.queryByParentId(parentId));
    }
}
