package com.elitesland.tw.tw5.server.prd.task.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 任务
 *
 * @author xxb
 * @date 2023-11-16
 */
@Entity
@Table(name = "pms_task_info", indexes = {
        @Index(name = "task_package_index", columnList = "task_package_id"),
        @Index(name = "task_no_index", columnList = "task_no"),
        @Index(name = "source_type_id_index", columnList = "source_type,source_id"),
        @Index(name = "task_status_index", columnList = "task_status")
})
@org.hibernate.annotations.Table(appliesTo = "pms_task_info", comment = "任务")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TaskInfoDO extends BaseModel implements Serializable {

    @Comment("任务包ID")
    @Column(name = "task_package_id")
    private Long taskPackageId;

    @Comment("上级任务ID")
    @Column()
    private Long taskParentId;

    @Comment("上级任务名称")
    @Column()
    private String taskParentName;

    @Comment("任务编号")
    @Column(name = "task_no")
    private String taskNo;

    @Comment("任务名称")
    @Column()
    private String taskName;
    @Comment("任务负责人")
    @Column()
    private Long taskResId;

    @Comment("派发资源id")
    @Column()
    private Long disterResId;

    @Comment("协助人")
    @Column()
    private Long assId;
    @Comment("关联活动")
    @Column()
    private Long relatedActId;
    @Comment("关联活动")
    @Column()
    private String relatedAct;
    @Comment("计划开始日期")
    @Column()
    private LocalDate planStartDate;
    @Comment("计划结束日期")
    @Column()
    private LocalDate planEndDate;

    @Comment("任务类型null或1是普通任务，2奖励假任务")
    @Column()
    private String taskType;

    @Comment("任务来源类型null或1是普通任务，2奖励假任务,3帮我吧工时创建")
    @Column(name = "source_type")
    private String sourceType;
    @Comment("来源id（如果是奖励假申请则是奖励假申请id）")
    @Column(name = "source_id")
    private Long sourceId;

    @Comment("任务描述")
    @Column()
    private String taskDes;
    @Comment("任务验收标准")
    @Column()
    private String accepCriteria;
    @Comment("优先级")
    @Column()
    private Integer priority;

    @Comment("任务总当量数")
    @Column(precision = 12, scale = 4)
    private BigDecimal totalEqva;

    @Comment("已结算当量数")
    @Column(precision = 12, scale = 4)
    private BigDecimal settledEqva;

    @Comment("拆分当量数")
    @Column(precision = 12, scale = 4)
    private BigDecimal splitEqva;

    @Comment("原始当量数")
    @Column(precision = 12, scale = 4)
    private BigDecimal originalEqva;

    @Comment("计划当量数")
    @Column(precision = 12, scale = 4)
    private BigDecimal planEqva;

    @Comment("追加当量数")
    @Column(precision = 12, scale = 4)
    private BigDecimal additionEqva;

    @Comment("释放当量数")
    @Column(precision = 12, scale = 4)
    private BigDecimal releaseEqva;

    @Comment("已使用当量：已经填过工时的，提交过审批")
    @Column(precision = 12, scale = 4)
    private BigDecimal usedEqva;

    @Comment("工时已审批通过当量")
    @Column(precision = 12, scale = 4)
    private BigDecimal approvedEqva;


    @Comment("有效当量数")
    @Column(precision = 12, scale = 4)
    private BigDecimal validEqva;

    @Comment("是否评价:1已经评价过 0没有")
    @Column()
    private Integer evaluationflag;

    @Comment("任务进度")
    @Column()
    private BigDecimal taskProgress;

    @Comment("任务状态")
    @Column(name = "task_status")
    private String taskStatus;

    @Comment("任务申请标记")
    @Column()
    private Integer taskApplyFlag;

    @Comment("任务申请流程Id")
    @Column()
    private String taskApplyProcessId;

    /**
     * 实际开始日期
     */
    @Comment("实际开始日期")
    @Column()
    private LocalDate actualStartDate;
    /**
     * 实际结束日期
     */
    @Comment("实际结束日期")
    @Column()
    private LocalDate actualEndDate;
    /**
     * 来源帮我吧标记 1：是
     */
    @Comment("来源帮我吧标记")
    @Column()
    private Integer bw8Flag;
}
