package com.elitesland.tw.tw5.server.prd.task.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 任务
 *
 * @author xxb
 * @date 2023-11-16
 */
@Entity
@Table(name = "pms_task_package", indexes = {
        @Index(name = "reason_type_id_index", columnList = "reason_type,reason_id"),
})
@org.hibernate.annotations.Table(appliesTo = "pms_task_package", comment = "任务包")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TaskPackageDO extends BaseModel implements Serializable {

    /**
     * 基本信息
     */

    @Comment("事由id")
    @Column(name = "reason_id")
    private Long reasonId;
    @Comment("事由名称")
    @Column()
    private String reasonName;
    @Comment("事由类型 01 合同项目 02 商机项目 03 BU项目")
    @Column(name = "reason_type")
    private String reasonType;

    @Comment("任务包编号")
    @Column()
    private String taskPackageNo;

    @Comment("任务包名称")
    @Column()
    private String taskPackageName;

    @Comment("发包资源id")
    @Column()
    private Long disterResId;

    @Comment("接收资源id")
    @Column()
    private Long receiverResId;

    @Comment("当量系数")
    @Column()
    private BigDecimal eqvaRatio;

    @Comment("接收资源bu_id")
    @Column()
    private Long receiverBuId;

    @Comment("接收资源复合能力ID")
    @Column()
    private Long compositeAbilityId;
    @Comment("工种")
    @Column()
    private String jobType1;
    @Comment("工种子类")
    @Column()
    private String jobType2;

    @Comment("任务包开始日期")
    @Column()
    private LocalDate startDate;

    @Comment("任务包结束日期")
    @Column()
    private LocalDate endDate;

    @Comment("任务包状态")
    @Column()
    private String taskPackageStatus;

    @Comment("任务包类型")
    @Column()
    private String taskPackageType;

    @Comment("任务包说明")
    @Column()
    private String taskPackageDes;


    /**
     * 结算信息
     */

    @Comment("验收人")
    @Column()
    private Long acceptorId;

    @Comment("验收方式")
    @Column()
    private String acceptMethod;

    @Comment("计价方式")
    @Column()
    private String pricingMethod;

    @Comment("定时任务自动结算当量标记")
    @Column()
    private Integer autoSettleFlag;

    @Comment("质保金比例")
    @Column()
    private BigDecimal guaranteeRate;

    @Comment("当量结算单价")
    @Column()
    private BigDecimal settlePrice;

    @Comment("当量收入单价")
    @Column()
    private BigDecimal incomePrice;
}
