package com.elitesland.tw.tw5.server.prd.ts.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalConfigPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsApprovalConfigQuery;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalConfigVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.ts.entity.QTsApprovalConfigDO;
import com.elitesland.tw.tw5.server.prd.ts.entity.TsApprovalConfigDO;
import com.elitesland.tw.tw5.server.prd.ts.repo.TsApprovalConfigRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 工时审批配置管理
 *
 * @author carl
 * @date 2024-04-29
 */
@Repository
@RequiredArgsConstructor
public class TsApprovalConfigDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TsApprovalConfigRepo repo;
    private final QTsApprovalConfigDO qdo = QTsApprovalConfigDO.tsApprovalConfigDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TsApprovalConfigVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TsApprovalConfigVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 年度
                qdo.finYear,
                // 成本级别
                qdo.costLevel,
                // 事由类型
                qdo.reasonType,
                // 工作类型
                qdo.workType,
                // 交付bu_id
                qdo.deliBuId,
                // 资源类型
                qdo.resType,
                // 预算类型（风险等级1，百分比2）
                qdo.budgetType,
                // 预算情况
                qdo.budgetData,
                qdo.budgetData0,
                // 审批类型1（指定角色1，指定用户2）
                qdo.approvalType1,
                // 审批资源1
                qdo.approvalSource1,
                // 审批类型2
                qdo.approvalType2,
                // 审批资源2
                qdo.approvalSource2,
                // 审批类型3
                qdo.approvalType3,
                // 审批资源3
                qdo.approvalSource3,
                // 状态标记（有效1.无效0）
                qdo.statusFlag
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TsApprovalConfigVO> getJpaQueryWhere(TsApprovalConfigQuery query) {
        JPAQuery<TsApprovalConfigVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TsApprovalConfigQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TsApprovalConfigQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 年度 精确 */
        if (!ObjectUtils.isEmpty(query.getFinYear())) {
            list.add(qdo.finYear.eq(query.getFinYear()));
        }
        /** 成本级别 精确 */
        if (!ObjectUtils.isEmpty(query.getCostLevel())) {
            list.add(qdo.costLevel.eq(query.getCostLevel()));
        }
        /** 事由类型 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonType())) {
            list.add(qdo.reasonType.eq(query.getReasonType()));
        }
        /** 工作类型 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkType())) {
            list.add(qdo.workType.eq(query.getWorkType()));
        }
        /** 交付bu_id 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliBuId())) {
            list.add(qdo.deliBuId.eq(query.getDeliBuId()));
        }
        /** 资源类型 精确 */
        if (!ObjectUtils.isEmpty(query.getResType())) {
            list.add(qdo.resType.eq(query.getResType()));
        }
        /** 预算类型（风险等级1，百分比2） 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetType())) {
            list.add(qdo.budgetType.eq(query.getBudgetType()));
        }
        /** 预算情况 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetData())) {
            list.add(qdo.budgetData.eq(query.getBudgetData()));
        }
        /** 预算情况 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetData0())) {
            list.add(qdo.budgetData0.eq(query.getBudgetData0()));
        }
        /** 审批类型1（指定角色1，指定用户2） 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovalType1())) {
            list.add(qdo.approvalType1.eq(query.getApprovalType1()));
        }
        /** 审批资源1 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovalSource1())) {
            list.add(qdo.approvalSource1.eq(query.getApprovalSource1()));
        }
        /** 审批类型2 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovalType2())) {
            list.add(qdo.approvalType2.eq(query.getApprovalType2()));
        }
        /** 审批资源2 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovalSource2())) {
            list.add(qdo.approvalSource2.eq(query.getApprovalSource2()));
        }
        /** 审批类型3 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovalType3())) {
            list.add(qdo.approvalType3.eq(query.getApprovalType3()));
        }
        /** 审批资源3 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovalSource3())) {
            list.add(qdo.approvalSource3.eq(query.getApprovalSource3()));
        }
        /** 状态标记（有效1.无效0） 精确 */
        if (!ObjectUtils.isEmpty(query.getStatusFlag())) {
            list.add(qdo.statusFlag.eq(query.getStatusFlag()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TsApprovalConfigVO queryByKey(Long id) {
        JPAQuery<TsApprovalConfigVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TsApprovalConfigVO> queryListDynamic(TsApprovalConfigQuery query) {
        JPAQuery<TsApprovalConfigVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TsApprovalConfigVO> queryPaging(TsApprovalConfigQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<TsApprovalConfigVO> jpaQuery = getJpaQueryWhere(query);
        List<TsApprovalConfigVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TsApprovalConfigVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TsApprovalConfigDO save(TsApprovalConfigDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TsApprovalConfigDO> saveAll(List<TsApprovalConfigDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TsApprovalConfigPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 主键
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 年度
        if (payload.getFinYear() != null) {
            update.set(qdo.finYear, payload.getFinYear());
        }
        // 成本级别
        if (payload.getCostLevel() != null) {
            update.set(qdo.costLevel, payload.getCostLevel());
        }
        // 事由类型
        if (payload.getReasonType() != null) {
            update.set(qdo.reasonType, payload.getReasonType());
        }
        // 工作类型
        if (payload.getWorkType() != null) {
            update.set(qdo.workType, payload.getWorkType());
        }
        // 交付bu_id
        if (payload.getDeliBuId() != null) {
            update.set(qdo.deliBuId, payload.getDeliBuId());
        }
        // 资源类型
        if (payload.getResType() != null) {
            update.set(qdo.resType, payload.getResType());
        }
        // 预算类型（风险等级1，百分比2）
        if (payload.getBudgetType() != null) {
            update.set(qdo.budgetType, payload.getBudgetType());
        }
        // 预算情况
        if (payload.getBudgetData() != null) {
            update.set(qdo.budgetData, payload.getBudgetData());
        }
        // 预算情况
        if (payload.getBudgetData0() != null) {
            update.set(qdo.budgetData0, payload.getBudgetData0());
        }
        // 审批类型1（指定角色1，指定用户2）
        if (payload.getApprovalType1() != null) {
            update.set(qdo.approvalType1, payload.getApprovalType1());
        }
        // 审批资源1
        if (payload.getApprovalSource1() != null) {
            update.set(qdo.approvalSource1, payload.getApprovalSource1());
        }
        // 审批类型2
        if (payload.getApprovalType2() != null) {
            update.set(qdo.approvalType2, payload.getApprovalType2());
        }
        // 审批资源2
        if (payload.getApprovalSource2() != null) {
            update.set(qdo.approvalSource2, payload.getApprovalSource2());
        }
        // 审批类型3
        if (payload.getApprovalType3() != null) {
            update.set(qdo.approvalType3, payload.getApprovalType3());
        }
        // 审批资源3
        if (payload.getApprovalSource3() != null) {
            update.set(qdo.approvalSource3, payload.getApprovalSource3());
        }
        // 状态标记（有效1.无效0）
        if (payload.getStatusFlag() != null) {
            update.set(qdo.statusFlag, payload.getStatusFlag());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 年度
            if (nullFields.contains("finYear")) {
                update.setNull(qdo.finYear);
            }
            // 成本级别
            if (nullFields.contains("costLevel")) {
                update.setNull(qdo.costLevel);
            }
            // 事由类型
            if (nullFields.contains("reasonType")) {
                update.setNull(qdo.reasonType);
            }
            // 工作类型
            if (nullFields.contains("workType")) {
                update.setNull(qdo.workType);
            }
            // 交付bu_id
            if (nullFields.contains("deliBuId")) {
                update.setNull(qdo.deliBuId);
            }
            // 资源类型
            if (nullFields.contains("resType")) {
                update.setNull(qdo.resType);
            }
            // 预算类型（风险等级1，百分比2）
            if (nullFields.contains("budgetType")) {
                update.setNull(qdo.budgetType);
            }
            // 预算情况
            if (nullFields.contains("budgetData")) {
                update.setNull(qdo.budgetData);
            }
            // 审批类型1（指定角色1，指定用户2）
            if (nullFields.contains("approvalType1")) {
                update.setNull(qdo.approvalType1);
            }
            // 审批资源1
            if (nullFields.contains("approvalSource1")) {
                update.setNull(qdo.approvalSource1);
            }
            // 审批类型2
            if (nullFields.contains("approvalType2")) {
                update.setNull(qdo.approvalType2);
            }
            // 审批资源2
            if (nullFields.contains("approvalSource2")) {
                update.setNull(qdo.approvalSource2);
            }
            // 审批类型3
            if (nullFields.contains("approvalType3")) {
                update.setNull(qdo.approvalType3);
            }
            // 审批资源3
            if (nullFields.contains("approvalSource3")) {
                update.setNull(qdo.approvalSource3);
            }
            // 状态标记（有效1.无效0）
            if (nullFields.contains("statusFlag")) {
                update.setNull(qdo.statusFlag);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public TsApprovalConfigVO getTsApprovalConfig(TsApprovalConfigQuery query) {
        JPAQuery<TsApprovalConfigVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(tsApprovalConfigWhere(query));
        List<OrderItem> orderse = new ArrayList<>();
        orderse.add(OrderItem.desc("reasonType"));
        orderse.add(OrderItem.desc("resType"));
        orderse.add(OrderItem.desc("workType"));
        orderse.add(OrderItem.desc("costLevel"));
        orderse.add(OrderItem.desc("deliBuId"));
        orderse.add(OrderItem.desc("budgetType"));
        orderse.add(OrderItem.desc("createTime"));
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, orderse));

        return jpaQuery.fetchFirst();
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate tsApprovalConfigWhere(TsApprovalConfigQuery query) {
        List<Predicate> list = new ArrayList<>();
        //状态
        if (query.getStatusFlag() != null) {
            list.add(qdo.statusFlag.eq(query.getStatusFlag()));
        }
        //年度 固定条件
        list.add(qdo.finYear.eq(query.getFinYear()));
        //事由类型 固定条件
        if (StringUtils.hasText(query.getReasonType())) {
            list.add(qdo.reasonType.eq(query.getReasonType()));
        } else {
            list.add(qdo.reasonType.isNull());
        }
        //工作类型 固定条件
        if (StringUtils.hasText(query.getWorkType())) {
            list.add(qdo.workType.eq(query.getWorkType()));
        } else {
            list.add(qdo.workType.isNull());
        }
        //成本级别 固定条件
        if (StringUtils.hasText(query.getCostLevel())) {
            list.add(qdo.costLevel.eq(query.getCostLevel()).or(qdo.costLevel.isNull()));
        } else {
            list.add(qdo.costLevel.isNull());
        }
        /** 资源类型 */
        if (!ObjectUtils.isEmpty(query.getResType())) {
            list.add(qdo.resType.eq(query.getResType()).or(qdo.resType.isNull()));
        } else {
            list.add(qdo.resType.isNull());
        }
        /** 交付bu    */
        if (!ObjectUtils.isEmpty(query.getDeliBuId())) {
            list.add(qdo.deliBuId.eq(query.getDeliBuId()).or(qdo.deliBuId.isNull()));
        } else {
            list.add(qdo.deliBuId.isNull());
        }
        /** 预算情况 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetType())) {

            BooleanExpression orExpression = (qdo.budgetType.eq("1").and(qdo.budgetData.eq(query.getBudgetData())));
            orExpression = orExpression.or(qdo.budgetType.isNull().and(qdo.budgetData.isNull()));
            orExpression = orExpression.or(qdo.budgetType.eq("2").and(qdo.budgetData0.loe(query.getBudgetData0())));
            orExpression = orExpression.or(qdo.budgetType.isNull().and(qdo.budgetData0.isNull()));

            //            BooleanExpression orExpression = (qdo.budgetType.eq("1").or(qdo.budgetType.isNull())).and(qdo.budgetData.eq(query.getBudgetData()).or(qdo.budgetData.isNull()));
//            orExpression = orExpression.or((qdo.budgetType.eq("2").or(qdo.budgetType.isNull())).and(qdo.budgetData0.loe(query.getBudgetData0()).or(qdo.budgetData0.isNull())));
            list.add(orExpression);
        } else {
            list.add(qdo.budgetData.isNull());
            list.add(qdo.budgetData0.isNull());
        }

        return ExpressionUtils.allOf(list);
    }

}

