/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.permission.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemBusinessObjectConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemNewFunctionService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemPermissonRuleService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleFunctionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldObjRoleFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionRuleConditionType;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionRuleType;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionScopeTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.service.PermissionRuleService;
import com.elitesland.tw.tw5.server.common.permission.strategy.context.BusinessObjectTypeStrategyContext;
import com.elitesland.tw.tw5.server.common.permission.strategy.context.OrgUserStrategyContext;
import com.elitesland.tw.tw5.server.common.permission.strategy.context.RoleStrategyContext;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PermissionRuleServiceImpl
implements PermissionRuleService {
    private static final Logger log = LoggerFactory.getLogger(PermissionRuleServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PrdSystemPermissonRuleService permissionRuleService;
    private final PrdOrgOrganizationService prdOrgOrganizationService;
    private final PrdSystemRoleFunctionService prdSystemRoleFunctionService;
    private final PrdSystemNewFunctionService prdSystemNewFunctionService;
    private final PrdSystemBusinessObjectConfigService prdSystemBusinessObjectConfigService;
    private final OrgUserStrategyContext orgUserStrategyContext;
    private final BusinessObjectTypeStrategyContext businessObjectTypeStrategyContext;
    private final RoleStrategyContext roleStrategyContext;
    private final Map<String, Object> map = new HashMap<String, Object>();

    @Override
    public MapBuilder searcherHandle(Class<?> classBean, Map<String, Object> params, String permissionDomainCode) {
        String functionCode = (String)params.get("_FunctionCode");
        MapBuilder mapBuilder = MapUtils.builder(params);
        this.map.clear();
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<String> systemRoleCodes = this.cacheUtil.getSystemRoleCodes(loginUserId);
        List<PrdSystemPermissionRuleVO> rules = this.getRules(functionCode);
        List prdOrgRoleVOS = this.prdOrgOrganizationService.queryUserOrgRoles(loginUserId);
        HashSet<String> systemOrgRoleCodes = new HashSet<String>();
        HashSet<Long> systemOrgRoleIds = new HashSet<Long>();
        prdOrgRoleVOS.forEach(prdOrgRoleVO -> {
            systemOrgRoleCodes.add(prdOrgRoleVO.getRoleCode());
            systemOrgRoleIds.add(prdOrgRoleVO.getId());
        });
        ArrayList<String> ruleGroupSpecialExprList = new ArrayList<String>();
        String[] codeRegx = functionCode.split("/");
        log.info("\u529f\u80fd\u7f16\u7801 functionCode {} \uff1a \u62c6\u5206\u540e\u672a \u3010{}\u3011", (Object)functionCode, (Object)codeRegx);
        if (FunctionCodeEnum.BUSINESS_PAGE.name().equals(functionCode)) {
            ((MapBuilder)mapBuilder.group("MEMBER_GROUP").field("projectId", new Object[0])).sql("exists (select ppm.user_id from prj_project_member ppm where ppm.project_id = $1 and ppm.user_id = ? and ppm.delete_flag = 0)", new Object[]{loginUserId});
            ruleGroupSpecialExprList.add("MEMBER_GROUP");
        }
        Object bsGroupExpr = params.get(MapBuilder.GROUP_EXPR);
        StringBuilder groupExpr = new StringBuilder();
        if (!ObjectUtils.isEmpty((Object)bsGroupExpr)) {
            groupExpr.append(bsGroupExpr);
        }
        ruleGroupSpecialExprList.forEach(expr -> {
            if (groupExpr.isEmpty()) {
                groupExpr.append((String)expr);
            } else {
                groupExpr.append("|(").append((String)expr).append(")");
            }
        });
        if (CollectionUtils.isEmpty(rules)) {
            if (codeRegx.length > 1) {
                Long roleFunctionId = this.prdSystemRoleFunctionService.listByFunctionCodeAndRoleCodes(functionCode, systemRoleCodes);
                if (ObjectUtils.isEmpty((Object)roleFunctionId)) {
                    mapBuilder.groupExpr(groupExpr.toString());
                    return mapBuilder;
                }
                rules = this.getRules(codeRegx[codeRegx.length - 1]);
                if (CollectionUtils.isEmpty(rules)) {
                    return mapBuilder;
                }
            } else {
                mapBuilder.groupExpr(groupExpr.toString());
                return mapBuilder;
            }
        }
        ArrayList<String> ruleGroupExprList = new ArrayList<String>();
        this.parsePermissionRule(functionCode, mapBuilder, loginUserId, systemRoleCodes, systemOrgRoleIds, systemOrgRoleCodes, rules, ruleGroupExprList, classBean);
        if (this.permissionHasAdmin() || this.cacheUtil.hasSystemRolePermission(RoleEnum.SYS.getCode()).booleanValue()) {
            return mapBuilder;
        }
        String permissionGroupExpr = ruleGroupExprList.stream().map(expr -> "(" + expr + ")").collect(Collectors.joining("|"));
        if (!groupExpr.isEmpty()) {
            groupExpr.append("|(").append(permissionGroupExpr).append(")");
        } else {
            groupExpr.append(permissionGroupExpr);
        }
        mapBuilder.groupExpr(groupExpr.toString());
        List<String> permissionFieldRule = this.getPermissionFieldRule(permissionDomainCode, classBean, systemRoleCodes, functionCode);
        if (!CollectionUtils.isEmpty(permissionFieldRule)) {
            mapBuilder.onlySelect(permissionFieldRule.toArray(new String[0]));
        }
        mapBuilder.put("_permissionCheck", (Object)true);
        return mapBuilder;
    }

    private boolean permissionHasAdmin() {
        return !ObjectUtils.isEmpty((Object)this.map.get("_admin")) && (Boolean)this.map.get("_admin") != false;
    }

    private void parsePermissionRule(String functionCode, MapBuilder mapBuilder, Long loginUserId, List<String> systemRoleCodes, Set<Long> systemOrgRoleIds, Set<String> systemOrgRoleCodes, List<PrdSystemPermissionRuleVO> rules, List<String> ruleGroupExprList, Class<?> classBean) {
        Long defaultOrgId = this.cacheUtil.getDefaultOrgIdByUserId(loginUserId);
        List<Long> childOrgIds = this.cacheUtil.getAllChildOrgIds(defaultOrgId);
        childOrgIds.add(defaultOrgId);
        HashSet<Long> childOrgIdSet = new HashSet<Long>(childOrgIds);
        for (PrdSystemPermissionRuleVO rule : rules) {
            if (!this.checkRuleScope(rule, mapBuilder, ruleGroupExprList, loginUserId, defaultOrgId, childOrgIdSet, systemRoleCodes, systemOrgRoleIds, systemOrgRoleCodes)) {
                log.info("\u5f53\u524d\u767b\u5f55\u4eba\u4e0d\u5339\u914d\u89c4\u5219\u8303\u56f4\u3010{}\u3011\uff0c\u89c4\u5219\u503c\u3010{}\u3011\uff0c\u89c4\u5219\u7f16\u7801\u3010{}\u3011\uff0c\u529f\u80fd\u4ee3\u7801\u3010{}\u3011\uff0c\u5f53\u524d\u767b\u5f55\u4eba\u3010{}\u3011", new Object[]{rule.getRuleType(), rule.getRuleScope(), rule.getRuleCode(), functionCode, loginUserId});
                ((MapBuilder)mapBuilder.group(rule.getRuleCode()).field("id", new Object[]{-1})).op((FieldOp)FieldOps.Equal);
                ruleGroupExprList.add(rule.getRuleCode());
                continue;
            }
            log.info("\u9a8c\u8bc1\u8be5\u7528\u6237\u662f\u5426\u76f4\u63a5\u653e\u884c\uff0c\u7ed3\u679c\u4e3a\u3010{}\u3011", (Object)this.permissionHasAdmin());
            if (this.permissionHasAdmin()) break;
            log.info("\u5f53\u524d\u89c4\u5219\u3010{}\u3011\u5df2\u751f\u6548\uff0c\u529f\u80fd\u4ee3\u7801\u3010{}\u3011", (Object)rule.getRuleCode(), (Object)functionCode);
            if (PermissionScopeTypeEnum.SCOPE_ALL.getName().equals(rule.getScopeType())) {
                log.info("\u5f53\u524d\u89c4\u5219\u65e0\u89c4\u5219\u6761\u4ef6\uff0c \u8fdb\u884c\u65e0\u89c4\u5219\u60c5\u51b5\u4e0b\u5904\u7406");
                if (!PermissionRuleType.BUSINESS_OBJECT_TYPE.getName().equals(rule.getRuleType())) {
                    mapBuilder.group(rule.getRuleCode());
                    ((MapBuilder)mapBuilder.field("id", new Object[0])).sql("1 = 1");
                }
                ruleGroupExprList.add(rule.getRuleCode());
                continue;
            }
            rule.getDetailList().forEach(detail -> {
                String field = detail.getRuleField();
                String value = detail.getRuleValue();
                if (PermissionRuleType.CUSTOM.getName().equals(rule.getRuleType())) {
                    log.info("\u5f53\u524d\u89c4\u5219\u5c5e\u4e8e\u81ea\u5b9a\u4e49\u7c7b\u578b\uff0c \u8fdb\u884csql\u81ea\u5b9a\u4e49\u5904\u7406");
                    if (!StringUtils.hasText((String)detail.getRuleSql())) {
                        return;
                    }
                    mapBuilder.group(rule.getRuleCode() + "_" + detail.getRuleDetailCode());
                    if (StringUtils.hasText((String)value)) {
                        ((MapBuilder)mapBuilder.field("id", new Object[0])).sql(detail.getRuleSql(), (Object[])value.split(","));
                    } else {
                        ((MapBuilder)mapBuilder.field("id", new Object[0])).sql(detail.getRuleSql());
                    }
                } else {
                    mapBuilder.group(rule.getRuleCode() + "_" + detail.getRuleDetailCode());
                    if (PermissionRuleConditionType.FILTER.name().equals(detail.getRuleConditionType())) {
                        if (StringUtils.hasText((String)value)) {
                            Object[] split = value.split(",");
                            log.info("[{}] \u5f53\u524d\u89c4\u5219\u4e2d\u8303\u56f4\u5b58\u5728\u503c\u4fe1\u606f", detail);
                            if (!ObjectUtils.isEmpty((Object)detail.getDeep()) && detail.getDeep().equals(1)) {
                                HashSet<Long> orgAlls = new HashSet<Long>();
                                for (Object s : split) {
                                    log.info("[{}] \u83b7\u53d6\u7f13\u5b58\u4e2d\u7684\u5b50\u7ec4\u7ec7", s);
                                    Long orgId = Long.valueOf((String)s);
                                    List<Long> allChildOrgIds = this.cacheUtil.getAllChildOrgIds(orgId);
                                    allChildOrgIds.add(orgId);
                                    if (!CollectionUtils.isEmpty(allChildOrgIds)) {
                                        orgAlls.addAll(allChildOrgIds);
                                    }
                                    log.info("[{}] \u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u7684\u4fe1\u606f\u6210\u529f", s);
                                }
                                log.info("[{}] [{}] \u5df2\u7ecf\u83b7\u53d6\u5230\u6240\u6709\u7a7f\u900f\u7ec4\u7ec7\u4fe1\u606f", (Object)rule.getRuleCode(), (Object)detail.getRuleDetailCode());
                                ((MapBuilder)mapBuilder.field(CharSequenceUtil.toCamelCase((CharSequence)field), orgAlls)).op(detail.getRuleCondition());
                            } else {
                                ((MapBuilder)mapBuilder.field(CharSequenceUtil.toCamelCase((CharSequence)field), split)).op(detail.getRuleCondition());
                            }
                        } else {
                            ((MapBuilder)mapBuilder.field(CharSequenceUtil.toCamelCase((CharSequence)field), new Object[]{value})).op(detail.getRuleCondition());
                        }
                    }
                }
            });
            Object ruleGroupExpr = this.buildRuleGroupExpr(rule.getGroupExpr(), rule.getRuleCode());
            if (PermissionRuleType.BUSINESS_OBJECT_TYPE.getName().equals(rule.getRuleType())) {
                ruleGroupExpr = rule.getRuleCode() + "&" + (String)ruleGroupExpr;
            }
            ruleGroupExprList.add((String)ruleGroupExpr);
        }
    }

    private boolean checkRuleScope(PrdSystemPermissionRuleVO rule, MapBuilder mapBuilder, List<String> ruleGroupExprList, Long loginUserId, Long defaultOrgId, Set<Long> childOrgIdSet, List<String> systemRoleCodes, Set<Long> systemOrgRoleIds, Set<String> systemOrgRoleCodes) {
        return switch (PermissionRuleType.valueOf(rule.getRuleType())) {
            case PermissionRuleType.USER -> rule.getRuleScope().equals(loginUserId.toString());
            case PermissionRuleType.ORG -> this.orgUserStrategyContext.getStrategyBean(PermissionRuleType.ORG.getName() + "_" + rule.getLevelScope()).execute(rule, defaultOrgId, childOrgIdSet);
            case PermissionRuleType.ROLE -> this.roleStrategyContext.getStrategyBean(PermissionRuleType.ROLE.getName() + "_" + rule.getRuleSubType(), PermissionRuleType.ROLE.getName() + "_" + rule.getLevelScope()).execute(rule, systemRoleCodes, systemOrgRoleIds, systemOrgRoleCodes);
            case PermissionRuleType.BUSINESS_OBJECT_TYPE -> this.businessObjectTypeStrategyContext.getStrategyBean(PermissionRuleType.BUSINESS_OBJECT_TYPE.getName() + "_" + rule.getLevelScope()).execute(rule, mapBuilder, ruleGroupExprList, loginUserId, defaultOrgId, childOrgIdSet, this.map);
            case PermissionRuleType.CUSTOM -> true;
            default -> false;
        };
    }

    private List<PrdSystemPermissionRuleVO> getRules(String functionCode) {
        List allPermissionRule = this.permissionRuleService.getAllByFunctionCode(functionCode);
        if (allPermissionRule.isEmpty()) {
            return Collections.emptyList();
        }
        return allPermissionRule;
    }

    private List<String> getPermissionFieldRule(String permissionDomainCode, Class<?> classBean, List<String> systemRoleCodes, String functionCode) {
        List permissionFieldRule = this.permissionRuleService.getPermissionFieldRule(permissionDomainCode, classBean.getName(), functionCode);
        return permissionFieldRule.stream().filter(item -> systemRoleCodes.contains(item.getRoleCode()) && 0 == item.getIsVisible()).map(PrdSystemPermissionFieldObjRoleFunctionVO::getFieldName).distinct().toList();
    }

    private String buildRuleGroupExpr(String groupExpr, String ruleCode) {
        int left = 0;
        int right = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < groupExpr.length(); ++i) {
            if (groupExpr.charAt(i) != '&' && groupExpr.charAt(i) != '|') {
                ++right;
                continue;
            }
            sb.append(ruleCode).append("_").append(groupExpr, left, right).append(groupExpr.charAt(i));
            left = ++right;
        }
        if (left != right) {
            sb.append(ruleCode).append("_").append(groupExpr, left, right);
        }
        return sb.toString();
    }

    public PermissionRuleServiceImpl(CacheUtil cacheUtil, PrdSystemPermissonRuleService permissionRuleService, PrdOrgOrganizationService prdOrgOrganizationService, PrdSystemRoleFunctionService prdSystemRoleFunctionService, PrdSystemNewFunctionService prdSystemNewFunctionService, PrdSystemBusinessObjectConfigService prdSystemBusinessObjectConfigService, OrgUserStrategyContext orgUserStrategyContext, BusinessObjectTypeStrategyContext businessObjectTypeStrategyContext, RoleStrategyContext roleStrategyContext) {
        this.cacheUtil = cacheUtil;
        this.permissionRuleService = permissionRuleService;
        this.prdOrgOrganizationService = prdOrgOrganizationService;
        this.prdSystemRoleFunctionService = prdSystemRoleFunctionService;
        this.prdSystemNewFunctionService = prdSystemNewFunctionService;
        this.prdSystemBusinessObjectConfigService = prdSystemBusinessObjectConfigService;
        this.orgUserStrategyContext = orgUserStrategyContext;
        this.businessObjectTypeStrategyContext = businessObjectTypeStrategyContext;
        this.roleStrategyContext = roleStrategyContext;
    }
}

