/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.demo.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.demo.query.DemoCompanyBankQuery;
import com.elitesland.tw.tw5.api.demo.vo.DemoCompanyBankVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.demo.entity.QDemoBankDO;
import com.elitesland.tw.tw5.server.demo.entity.QDemoCompanyDO;
import com.elitesland.tw.tw5.server.demo.repo.DemoCompanyRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class DemoCompanyDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final DemoCompanyRepo repo;
    private final QDemoBankDO qbank = QDemoBankDO.demoBankDO;
    private final QDemoCompanyDO qcompany = QDemoCompanyDO.demoCompanyDO;

    private JPAQuery<DemoCompanyBankVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(DemoCompanyBankVO.class, (Expression[])new Expression[]{this.qcompany.companyAddr, this.qcompany.companyName, this.qcompany.companyMobile, this.qbank.bankName, this.qbank.bankCard, this.qbank.handleName, this.qbank.id.as("bankId"), this.qbank.companyId})).from((EntityPath)this.qcompany)).leftJoin((EntityPath)this.qbank)).on((Predicate)this.qcompany.id.longValue().eq(this.qbank.companyId));
        return jpaQuery;
    }

    private JPAQuery<DemoCompanyBankVO> getJpaQueryWhere(DemoCompanyBankQuery query) {
        JPAQuery<DemoCompanyBankVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getCompanyAddr())) {
            jpaQuery.where((Predicate)this.qcompany.companyAddr.like(SqlUtil.toSqlLikeString(query.getCompanyAddr())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCompanyName())) {
            jpaQuery.where((Predicate)this.qcompany.companyName.like(SqlUtil.toSqlLikeString(query.getCompanyName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCompanyMobile())) {
            jpaQuery.where((Predicate)this.qcompany.companyMobile.like(SqlUtil.toSqlLikeString(query.getCompanyMobile())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBankCard())) {
            jpaQuery.where((Predicate)this.qbank.bankCard.like(SqlUtil.toSqlLikeString(query.getBankCard())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getHandleName())) {
            jpaQuery.where((Predicate)this.qbank.handleName.like(SqlUtil.toSqlLikeString(query.getHandleName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBankName())) {
            jpaQuery.where((Predicate)this.qbank.bankName.like(SqlUtil.toSqlLikeString(query.getBankName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBankId())) {
            jpaQuery.where((Predicate)this.qbank.id.eq((Object)query.getBankId()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qcompany._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qcompany, query.getOrders()));
        return jpaQuery;
    }

    public DemoCompanyBankVO queryByKey(Long id) {
        JPAQuery<DemoCompanyBankVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qcompany.id.eq((Object)id));
        return (DemoCompanyBankVO)jpaQuery.fetchFirst();
    }

    public PagingVO<DemoCompanyBankVO> queryPaging(DemoCompanyBankQuery query) {
        JPAQuery<DemoCompanyBankVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public DemoCompanyDAO(JPAQueryFactory jpaQueryFactory, DemoCompanyRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

