/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.budget.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.PmsBudgetOccupyPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.PmsBudgetOccupyQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.PmsBudgetOccupyService;
import com.elitesland.tw.tw5.api.prd.budget.vo.PmsBudgetOccupyVO;
import com.elitesland.tw.tw5.server.prd.budget.convert.PmsBudgetOccupyConvert;
import com.elitesland.tw.tw5.server.prd.budget.dao.PmsBudgetOccupyDAO;
import com.elitesland.tw.tw5.server.prd.budget.entity.PmsBudgetOccupyDO;
import com.elitesland.tw.tw5.server.prd.budget.repo.PmsBudgetOccupyRepo;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PmsBudgetOccupyServiceImpl
extends BaseServiceImpl
implements PmsBudgetOccupyService {
    private static final Logger log = LoggerFactory.getLogger(PmsBudgetOccupyServiceImpl.class);
    private final PmsBudgetOccupyRepo pmsBudgetOccupyRepo;
    private final PmsBudgetOccupyDAO pmsBudgetOccupyDAO;

    public PagingVO<PmsBudgetOccupyVO> queryPaging(PmsBudgetOccupyQuery query) {
        return this.pmsBudgetOccupyDAO.queryPaging(query);
    }

    public List<PmsBudgetOccupyVO> queryListDynamic(PmsBudgetOccupyQuery query) {
        return this.pmsBudgetOccupyDAO.queryListDynamic(query);
    }

    public PmsBudgetOccupyVO queryByKey(Long key) {
        PmsBudgetOccupyDO entity = this.pmsBudgetOccupyRepo.findById(key).orElseGet(PmsBudgetOccupyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsBudgetOccupyVO vo = PmsBudgetOccupyConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsBudgetOccupyVO insert(PmsBudgetOccupyPayload payload) {
        PmsBudgetOccupyDO entityDo = PmsBudgetOccupyConvert.INSTANCE.toDo(payload);
        return PmsBudgetOccupyConvert.INSTANCE.toVo((PmsBudgetOccupyDO)this.pmsBudgetOccupyRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsBudgetOccupyVO update(PmsBudgetOccupyPayload payload) {
        PmsBudgetOccupyDO entity = this.pmsBudgetOccupyRepo.findById(payload.getId()).orElseGet(PmsBudgetOccupyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsBudgetOccupyDO entityDo = PmsBudgetOccupyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsBudgetOccupyConvert.INSTANCE.toVo((PmsBudgetOccupyDO)this.pmsBudgetOccupyRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsBudgetOccupyPayload payload) {
        PmsBudgetOccupyDO entity = this.pmsBudgetOccupyRepo.findById(payload.getId()).orElseGet(PmsBudgetOccupyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.pmsBudgetOccupyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsBudgetOccupyDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public long saveOrUpdate(List<PmsBudgetOccupyPayload> payloads) {
        long result = 0L;
        for (PmsBudgetOccupyPayload payload : payloads) {
            Long docId;
            String costType;
            Long belongToId;
            String docType;
            Long budgetId = payload.getBudgetId();
            PmsBudgetOccupyVO entity = this.pmsBudgetOccupyDAO.queryByBizKey(budgetId, docType = payload.getDocType(), belongToId = payload.getBelongToId(), costType = payload.getCostType(), docId = payload.getDocId());
            if (null != entity && null != entity.getId()) {
                log.info("exists entity ID: {}", (Object)entity.getId());
                payload.setId(entity.getId());
                result = this.pmsBudgetOccupyDAO.updateByKeyDynamic(payload);
                continue;
            }
            PmsBudgetOccupyDO entityDo = PmsBudgetOccupyConvert.INSTANCE.toDo(payload);
            this.pmsBudgetOccupyRepo.save(entityDo);
            ++result;
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public long cancel(List<PmsBudgetOccupyPayload> payloads) {
        long result = 0L;
        for (PmsBudgetOccupyPayload payload : payloads) {
            Long docId;
            String costType;
            Long belongToId;
            String docType;
            Long budgetId = payload.getBudgetId();
            PmsBudgetOccupyVO entity = this.pmsBudgetOccupyDAO.queryByBizKey(budgetId, docType = payload.getDocType(), belongToId = payload.getBelongToId(), costType = payload.getCostType(), docId = payload.getDocId());
            if (null == entity || null == entity.getId()) continue;
            this.pmsBudgetOccupyDAO.deleteSoft(Collections.singletonList(entity.getId()));
            ++result;
        }
        return result;
    }

    public PmsBudgetOccupyServiceImpl(PmsBudgetOccupyRepo pmsBudgetOccupyRepo, PmsBudgetOccupyDAO pmsBudgetOccupyDAO) {
        this.pmsBudgetOccupyRepo = pmsBudgetOccupyRepo;
        this.pmsBudgetOccupyDAO = pmsBudgetOccupyDAO;
    }
}

