/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActProjectVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmActActivityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunitySalesDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityAnalyzeRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityCompetitorRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityPartnerRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunitySalesRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityStakeholderRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectMemberDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmOpportunityDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOpportunityRepo repo;
    private final CrmOpportunitySalesRepo repoSales;
    private final CrmOpportunityStakeholderRepo repoStakeholder;
    private final CrmOpportunityPartnerRepo repoPartner;
    private final CrmOpportunityCompetitorRepo repoCompetitor;
    private final CrmOpportunityAnalyzeRepo repoAnalyze;
    private final QCrmOpportunityDO qdo = QCrmOpportunityDO.crmOpportunityDO;
    private final QPrjProjectDO qdoProject = QPrjProjectDO.prjProjectDO;
    private final QPrjProjectDO qdoProject1 = new QPrjProjectDO("qdoProject1");
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QCrmLeadsDO qdoLeads = QCrmLeadsDO.crmLeadsDO;
    private final QPrjProjectMemberDO qdoMember = QPrjProjectMemberDO.prjProjectMemberDO;
    private final QCrmActActivityDO qdoActivity = QCrmActActivityDO.crmActActivityDO;
    private final QCrmOpportunitySalesDO qdoSales = QCrmOpportunitySalesDO.crmOpportunitySalesDO;

    public CrmOpportunityDO save(CrmOpportunityDO ado) {
        return (CrmOpportunityDO)((Object)this.repo.save((Object)ado));
    }

    private JPAQuery<CrmActProjectVO> getJpaQuerySelectProject() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmActProjectVO.class, (Expression[])new Expression[]{this.qdoProject.id, this.qdoProject.projectName, this.qdoProject.projectNo, this.qdoProject.manageUserId, this.qdoProject.orgId, this.qdoProject.projectStatus, this.qdoProject.closeReason, this.qdoEmployee.employeeName.as("manageUserName"), this.qdo.codeliUserId, this.qdo.oppoIdV4, this.qdo.deliUserId, this.qdo.preSaleUserId, this.qdo.preSaleOrgId, this.qdo.coUserId, this.qdoProject.createUserId, this.qdoProject.creator, this.qdoProject.createTime})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoProject)).on((Predicate)this.qdoProject.id.longValue().eq((Expression)this.qdo.projectId.longValue()))).leftJoin((EntityPath)this.qdoEmployee)).on((Predicate)this.qdoEmployee.userId.longValue().eq((Expression)this.qdoProject.manageUserId.longValue()));
        return jpaQuery;
    }

    public CrmActProjectVO queryProjectBykey(Long key) {
        JPAQuery<CrmActProjectVO> jpaQuery = this.getJpaQuerySelectProject();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)key));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoProject.deleteFlag.eq((Object)0));
        return (CrmActProjectVO)jpaQuery.fetchFirst();
    }

    public long updateProjectByKeyDynamic(CrmOpportunityPayload payload, Long projectId) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoProject).where(new Predicate[]{this.qdoProject.id.eq((Object)projectId)});
        if (payload.getProjectName() != null) {
            update.set((Path)this.qdoProject.projectName, (Object)payload.getProjectName());
        }
        if (payload.getManageUserId() != null) {
            update.set(this.qdoProject.manageUserId, (Object)payload.getManageUserId());
        }
        if (payload.getOrgId() != null) {
            update.set(this.qdoProject.orgId, (Object)payload.getOrgId());
        }
        if (payload.getCompanyId() != null) {
            update.set(this.qdoProject.companyId, (Object)payload.getCompanyId());
        }
        if (payload.getFileCodes() != null) {
            update.set((Path)this.qdoProject.fileCodes, (Object)payload.getFileCodes());
        }
        if (payload.getLoseReason() != null) {
            update.set((Path)this.qdoProject.loseReason, (Object)payload.getLoseReason());
        }
        if (payload.getCloseReason() != null) {
            update.set((Path)this.qdoProject.closeReason, (Object)payload.getCloseReason());
        }
        if (payload.getClsoeRemark() != null) {
            update.set((Path)this.qdoProject.clsoeRemark, (Object)payload.getClsoeRemark());
        }
        if (payload.getProjectStatus() != null) {
            update.set((Path)this.qdoProject.projectStatus, (Object)payload.getProjectStatus());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0 && nullFields.contains("closeReason")) {
            update.setNull((Path)this.qdoProject.closeReason);
        }
        return update.execute();
    }

    @Transactional
    public long updateByKeyDynamic(CrmOpportunityPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getActId() != null) {
            update.set(this.qdo.actId, (Object)payload.getActId());
        }
        if (payload.getLeadsId() != null) {
            update.set(this.qdo.leadsId, (Object)payload.getLeadsId());
        }
        if (payload.getOppoIdV4() != null) {
            update.set(this.qdo.oppoIdV4, (Object)payload.getOppoIdV4());
        }
        if (payload.getSaleProduct() != null) {
            update.set((Path)this.qdo.saleProduct, (Object)payload.getSaleProduct());
        }
        if (payload.getCustRegion() != null) {
            update.set((Path)this.qdo.custRegion, (Object)payload.getCustRegion());
        }
        if (payload.getCustBookId() != null) {
            update.set(this.qdo.custBookId, (Object)payload.getCustBookId());
        }
        if (payload.getCustBookName() != null) {
            update.set((Path)this.qdo.custBookName, (Object)payload.getCustBookName());
        }
        if (payload.getCustProject() != null) {
            update.set((Path)this.qdo.custProject, (Object)payload.getCustProject());
        }
        if (payload.getContactName() != null) {
            update.set((Path)this.qdo.contactName, (Object)payload.getContactName());
        }
        if (payload.getContactPhone() != null) {
            update.set((Path)this.qdo.contactPhone, (Object)payload.getContactPhone());
        }
        if (payload.getContactDept() != null) {
            update.set((Path)this.qdo.contactDept, (Object)payload.getContactDept());
        }
        if (payload.getContactPosition() != null) {
            update.set((Path)this.qdo.contactPosition, (Object)payload.getContactPosition());
        }
        if (payload.getContactWebsite() != null) {
            update.set((Path)this.qdo.contactWebsite, (Object)payload.getContactWebsite());
        }
        if (payload.getCustProp() != null) {
            update.set((Path)this.qdo.custProp, (Object)payload.getCustProp());
        }
        if (payload.getCustIdst() != null) {
            update.set((Path)this.qdo.custIdst, (Object)payload.getCustIdst());
        }
        if (payload.getForecastWinDate() != null) {
            update.set(this.qdo.forecastWinDate, (Object)payload.getForecastWinDate());
        }
        if (payload.getForecastAmount() != null) {
            update.set(this.qdo.forecastAmount, (Object)payload.getForecastAmount());
        }
        if (payload.getCurrCode() != null) {
            update.set((Path)this.qdo.currCode, (Object)payload.getCurrCode());
        }
        if (payload.getSalePhase() != null) {
            update.set((Path)this.qdo.saleProduct, (Object)payload.getSaleProduct());
        }
        if (payload.getDeliveryAddress() != null) {
            update.set((Path)this.qdo.deliveryAddress, (Object)payload.getDeliveryAddress());
        }
        if (payload.getOppoLevel() != null) {
            update.set((Path)this.qdo.oppoLevel, (Object)payload.getOppoLevel());
        }
        if (payload.getIsNeedPartner() != null) {
            update.set(this.qdo.isNeedPartner, (Object)payload.getIsNeedPartner());
        }
        if (payload.getCoopBookId() != null) {
            update.set(this.qdo.coopBookId, (Object)payload.getCoopBookId());
        }
        if (payload.getCoopBookName() != null) {
            update.set((Path)this.qdo.coopBookName, (Object)payload.getCoopBookName());
        }
        if (payload.getPartnerDesc() != null) {
            update.set((Path)this.qdo.partnerDesc, (Object)payload.getPartnerDesc());
        }
        if (payload.getPreSaleOrgId() != null) {
            update.set(this.qdo.preSaleOrgId, (Object)payload.getPreSaleOrgId());
        }
        if (payload.getPreSaleUserId() != null) {
            update.set(this.qdo.preSaleUserId, (Object)payload.getPreSaleUserId());
        }
        if (payload.getProjectDifficult() != null) {
            update.set((Path)this.qdo.projectDifficult, (Object)payload.getProjectDifficult());
        }
        if (payload.getProjectImportance() != null) {
            update.set((Path)this.qdo.projectImportance, (Object)payload.getProjectImportance());
        }
        if (payload.getProbability() != null) {
            update.set((Path)this.qdo.probability, (Object)payload.getProbability());
        }
        if (payload.getDeliOrgId() != null) {
            update.set(this.qdo.deliOrgId, (Object)payload.getDeliOrgId());
        }
        if (payload.getProbabilityHint() != null) {
            update.set((Path)this.qdo.probabilityHint, (Object)payload.getProbabilityHint());
        }
        if (payload.getDeliUserId() != null) {
            update.set(this.qdo.deliUserId, (Object)payload.getDeliUserId());
        }
        if (payload.getSolutionDifficulty() != null) {
            update.set((Path)this.qdo.solutionDifficulty, (Object)payload.getSolutionDifficulty());
        }
        if (payload.getSolutionImportance() != null) {
            update.set((Path)this.qdo.solutionImportance, (Object)payload.getSolutionImportance());
        }
        if (payload.getCoUserId() != null) {
            update.set(this.qdo.coUserId, (Object)payload.getCoUserId());
        }
        if (payload.getSourceType() != null) {
            update.set((Path)this.qdo.sourceType, (Object)payload.getSourceType());
        }
        if (payload.getInternalOrgId() != null) {
            update.set(this.qdo.internalOrgId, (Object)payload.getInternalOrgId());
        }
        if (payload.getInternalUserId() != null) {
            update.set(this.qdo.internalUserId, (Object)payload.getInternalUserId());
        }
        if (payload.getExternalIden() != null) {
            update.set((Path)this.qdo.externalIden, (Object)payload.getExternalIden());
        }
        if (payload.getExternalName() != null) {
            update.set((Path)this.qdo.externalName, (Object)payload.getExternalName());
        }
        if (payload.getProbability() != null) {
            update.set((Path)this.qdo.probability, (Object)payload.getProbability());
        }
        if (payload.getProbabilityHint() != null) {
            update.set((Path)this.qdo.probabilityHint, (Object)payload.getProbabilityHint());
        }
        if (payload.getItemId() != null) {
            update.set((Path)this.qdo.itemId, (Object)payload.getItemId());
        }
        if (payload.getExternalPhone() != null) {
            update.set((Path)this.qdo.externalPhone, (Object)payload.getExternalPhone());
        }
        if (payload.getProfitDesc() != null) {
            update.set((Path)this.qdo.profitDesc, (Object)payload.getProfitDesc());
        }
        if (payload.getExtString1() != null) {
            update.set((Path)this.qdo.extString1, (Object)payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set((Path)this.qdo.extString2, (Object)payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set((Path)this.qdo.extString3, (Object)payload.getExtString3());
        }
        if (payload.getExtString4() != null) {
            update.set((Path)this.qdo.extString4, (Object)payload.getExtString4());
        }
        if (payload.getExtString5() != null) {
            update.set((Path)this.qdo.extString5, (Object)payload.getExtString5());
        }
        if (payload.getOppoIdV4() != null) {
            update.set(this.qdo.oppoIdV4, (Object)payload.getOppoIdV4());
        }
        if (payload.getCustBookId() != null) {
            update.set(this.qdo.custBookId, (Object)payload.getCustBookId());
        }
        if (payload.getCustBookName() != null) {
            update.set((Path)this.qdo.custBookName, (Object)payload.getCustBookName());
        }
        if (payload.getCoopBookId() != null) {
            update.set(this.qdo.coopBookId, (Object)payload.getCoopBookId());
        }
        if (payload.getCoopBookName() != null) {
            update.set((Path)this.qdo.coopBookName, (Object)payload.getCoopBookName());
        }
        if (payload.getActId() != null) {
            update.set(this.qdo.actId, (Object)payload.getActId());
        }
        if (payload.getFormalCustomerId() != null) {
            update.set(this.qdo.formalCustomerId, (Object)payload.getFormalCustomerId());
        }
        if (payload.getCheckStatus() != null) {
            update.set((Path)this.qdo.checkStatus, (Object)payload.getCheckStatus());
        }
        if (payload.getIsImplementation() != null) {
            update.set(this.qdo.isImplementation, (Object)payload.getIsImplementation());
        }
        if (payload.getImplementCondition() != null) {
            update.set((Path)this.qdo.implementCondition, (Object)payload.getImplementCondition());
        }
        if (payload.getOnboarding() != null) {
            update.set((Path)this.qdo.onboarding, (Object)payload.getOnboarding());
        }
        if (payload.getProResource() != null) {
            update.set((Path)this.qdo.proResource, (Object)payload.getProResource());
        }
        if (payload.getProInitiateReason() != null) {
            update.set((Path)this.qdo.proInitiateReason, (Object)payload.getProInitiateReason());
        }
        if (payload.getProPolicymakerDesc() != null) {
            update.set((Path)this.qdo.proPolicymakerDesc, (Object)payload.getProPolicymakerDesc());
        }
        if (payload.getProductServe() != null) {
            update.set((Path)this.qdo.productServe, (Object)payload.getProductServe());
        }
        if (payload.getBenchmarkingCust() != null) {
            update.set((Path)this.qdo.benchmarkingCust, (Object)payload.getBenchmarkingCust());
        }
        if (payload.getCustTurnoverYear() != null) {
            update.set((Path)this.qdo.custTurnoverYear, (Object)payload.getCustTurnoverYear());
        }
        if (payload.getIsListedCompany() != null) {
            update.set(this.qdo.isListedCompany, (Object)payload.getIsListedCompany());
        }
        if (payload.getProgramSituation() != null) {
            update.set((Path)this.qdo.programSituation, (Object)payload.getProgramSituation());
        }
        if (payload.getTeamResources() != null) {
            update.set((Path)this.qdo.teamResources, (Object)payload.getTeamResources());
        }
        if (payload.getBusinessResources() != null) {
            update.set((Path)this.qdo.businessResources, (Object)payload.getBusinessResources());
        }
        if (payload.getCodePreSaleUserId() != null) {
            update.set(this.qdo.codePreSaleUserId, (Object)payload.getCodePreSaleUserId());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("projectId")) {
                update.setNull(this.qdo.projectId);
            }
            if (nullFields.contains("leadsId")) {
                update.setNull(this.qdo.leadsId);
            }
            if (nullFields.contains("saleProduct")) {
                update.setNull((Path)this.qdo.saleProduct);
            }
            if (nullFields.contains("custRegion")) {
                update.setNull((Path)this.qdo.custRegion);
            }
            if (nullFields.contains("isOldCust")) {
                update.setNull(this.qdo.isOldCust);
            }
            if (nullFields.contains("custProject")) {
                update.setNull((Path)this.qdo.custProject);
            }
            if (nullFields.contains("contactName")) {
                update.setNull((Path)this.qdo.contactName);
            }
            if (nullFields.contains("contactPhone")) {
                update.setNull((Path)this.qdo.contactPhone);
            }
            if (nullFields.contains("contactDept")) {
                update.setNull((Path)this.qdo.contactDept);
            }
            if (nullFields.contains("contactPosition")) {
                update.setNull((Path)this.qdo.contactPosition);
            }
            if (nullFields.contains("contactWebsite")) {
                update.setNull((Path)this.qdo.contactWebsite);
            }
            if (nullFields.contains("custProp")) {
                update.setNull((Path)this.qdo.custProp);
            }
            if (nullFields.contains("custIdst")) {
                update.setNull((Path)this.qdo.custIdst);
            }
            if (nullFields.contains("forecastWinDate")) {
                update.setNull(this.qdo.forecastWinDate);
            }
            if (nullFields.contains("forecastAmount")) {
                update.setNull(this.qdo.forecastAmount);
            }
            if (nullFields.contains("probability")) {
                update.setNull((Path)this.qdo.probability);
            }
            if (nullFields.contains("currCode")) {
                update.setNull((Path)this.qdo.currCode);
            }
            if (nullFields.contains("salePhase")) {
                update.setNull((Path)this.qdo.salePhase);
            }
            if (nullFields.contains("deliveryAddress")) {
                update.setNull((Path)this.qdo.deliveryAddress);
            }
            if (nullFields.contains("oppoLevel")) {
                update.setNull((Path)this.qdo.oppoLevel);
            }
            if (nullFields.contains("isNeedPartner")) {
                update.setNull(this.qdo.isNeedPartner);
            }
            if (nullFields.contains("partnerDesc")) {
                update.setNull((Path)this.qdo.partnerDesc);
            }
            if (nullFields.contains("preSaleOrgId")) {
                update.setNull(this.qdo.preSaleOrgId);
            }
            if (nullFields.contains("preSaleUserId")) {
                update.setNull(this.qdo.preSaleUserId);
            }
            if (nullFields.contains("projectDifficult")) {
                update.setNull((Path)this.qdo.projectDifficult);
            }
            if (nullFields.contains("projectImportance")) {
                update.setNull((Path)this.qdo.projectImportance);
            }
            if (nullFields.contains("deliOrgId")) {
                update.setNull(this.qdo.deliOrgId);
            }
            if (nullFields.contains("deliUserId")) {
                update.setNull(this.qdo.deliUserId);
            }
            if (nullFields.contains("solutionDifficulty")) {
                update.setNull((Path)this.qdo.solutionDifficulty);
            }
            if (nullFields.contains("solutionImportance")) {
                update.setNull((Path)this.qdo.solutionImportance);
            }
            if (nullFields.contains("coOrgId")) {
                update.setNull(this.qdo.coOrgId);
            }
            if (nullFields.contains("coUserId")) {
                update.setNull(this.qdo.coUserId);
            }
            if (nullFields.contains("codeliOrgId")) {
                update.setNull(this.qdo.codeliOrgId);
            }
            if (nullFields.contains("codeliUserId")) {
                update.setNull(this.qdo.codeliUserId);
            }
            if (nullFields.contains("sourceType")) {
                update.setNull((Path)this.qdo.sourceType);
            }
            if (nullFields.contains("internalOrgId")) {
                update.setNull(this.qdo.internalOrgId);
            }
            if (nullFields.contains("internalUserId")) {
                update.setNull(this.qdo.internalUserId);
            }
            if (nullFields.contains("externalIden")) {
                update.setNull((Path)this.qdo.externalIden);
            }
            if (nullFields.contains("externalName")) {
                update.setNull((Path)this.qdo.externalName);
            }
            if (nullFields.contains("externalPhone")) {
                update.setNull((Path)this.qdo.externalPhone);
            }
            if (nullFields.contains("profitDesc")) {
                update.setNull((Path)this.qdo.profitDesc);
            }
            if (nullFields.contains("extString1")) {
                update.setNull((Path)this.qdo.extString1);
            }
            if (nullFields.contains("extString2")) {
                update.setNull((Path)this.qdo.extString2);
            }
            if (nullFields.contains("extString3")) {
                update.setNull((Path)this.qdo.extString3);
            }
            if (nullFields.contains("extString4")) {
                update.setNull((Path)this.qdo.extString4);
            }
            if (nullFields.contains("extString5")) {
                update.setNull((Path)this.qdo.extString5);
            }
            if (nullFields.contains("oppoIdV4")) {
                update.setNull(this.qdo.oppoIdV4);
            }
            if (nullFields.contains("custBookId")) {
                update.setNull(this.qdo.custBookId);
            }
            if (nullFields.contains("custBookName")) {
                update.setNull((Path)this.qdo.custBookName);
            }
            if (nullFields.contains("coopBookId")) {
                update.setNull(this.qdo.coopBookId);
            }
            if (nullFields.contains("coopBookName")) {
                update.setNull((Path)this.qdo.coopBookName);
            }
            if (nullFields.contains("actId")) {
                update.setNull(this.qdo.actId);
            }
            if (nullFields.contains("formalCustomerId")) {
                update.setNull(this.qdo.formalCustomerId);
            }
            if (nullFields.contains("itemId")) {
                update.setNull((Path)this.qdo.itemId);
            }
            if (nullFields.contains("checkStatus")) {
                update.setNull((Path)this.qdo.checkStatus);
            }
            if (nullFields.contains("isImplementation")) {
                update.setNull(this.qdo.isImplementation);
            }
            if (nullFields.contains("implementCondition")) {
                update.setNull((Path)this.qdo.implementCondition);
            }
            if (nullFields.contains("onboarding")) {
                update.setNull((Path)this.qdo.onboarding);
            }
            if (nullFields.contains("proResource")) {
                update.setNull((Path)this.qdo.proResource);
            }
            if (nullFields.contains("proInitiateReason")) {
                update.setNull((Path)this.qdo.proInitiateReason);
            }
            if (nullFields.contains("proPolicymakerDesc")) {
                update.setNull((Path)this.qdo.proPolicymakerDesc);
            }
            if (nullFields.contains("productServe")) {
                update.setNull((Path)this.qdo.productServe);
            }
            if (nullFields.contains("benchmarkingCust")) {
                update.setNull((Path)this.qdo.benchmarkingCust);
            }
            if (nullFields.contains("custTurnoverYear")) {
                update.setNull((Path)this.qdo.custTurnoverYear);
            }
            if (nullFields.contains("isListedCompany")) {
                update.setNull(this.qdo.isListedCompany);
            }
            if (nullFields.contains("programSituation")) {
                update.setNull((Path)this.qdo.programSituation);
            }
            if (nullFields.contains("teamResources")) {
                update.setNull((Path)this.qdo.teamResources);
            }
            if (nullFields.contains("businessResources")) {
                update.setNull((Path)this.qdo.businessResources);
            }
            if (nullFields.contains("codePreSaleUserId")) {
                update.setNull(this.qdo.codePreSaleUserId);
            }
            if (nullFields.contains("probabilityHint")) {
                update.setNull((Path)this.qdo.probabilityHint);
            }
            if (nullFields.contains("remark")) {
                update.setNull((Path)this.qdo.remark);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    private JPAQuery<CrmOpportunityVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmOpportunityVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.projectId, this.qdo.actId, this.qdoProject1.projectName.as("actName"), this.qdo.itemId, this.qdoProject.projectName, this.qdoProject.projectNo, this.qdoProject.orgId, this.qdoProject.manageUserId, this.qdoProject.companyId, this.qdoProject.fileCodes, this.qdoProject.projectStatus, this.qdoProject.closeReason, this.qdoProject.loseReason, this.qdoProject.clsoeRemark, this.qdo.leadsId, this.qdoLeads.leadsName, this.qdo.saleProduct, this.qdo.custRegion, this.qdo.isOldCust, this.qdo.custBookId, this.qdo.custBookName, this.qdo.custProject, this.qdo.contactName, this.qdo.contactPhone, this.qdo.contactDept, this.qdo.contactPosition, this.qdo.contactWebsite, this.qdo.custProp, this.qdo.custIdst, this.qdo.forecastWinDate, this.qdo.forecastAmount, this.qdo.probability, this.qdo.probabilityHint, this.qdo.currCode, this.qdo.salePhase, this.qdo.deliveryAddress, this.qdo.oppoLevel, this.qdo.isNeedPartner, this.qdo.coopBookId, this.qdo.coopBookName, this.qdo.partnerDesc, this.qdo.formalCustomerId, this.qdo.preSaleOrgId, this.qdo.preSaleUserId, this.qdo.projectDifficult, this.qdo.projectImportance, this.qdo.deliOrgId, this.qdo.deliUserId, this.qdo.solutionDifficulty, this.qdo.solutionImportance, this.qdo.coOrgId, this.qdo.coUserId, this.qdo.codeliOrgId, this.qdo.codeliUserId, this.qdo.sourceType, this.qdo.internalOrgId, this.qdo.internalUserId, this.qdo.externalIden, this.qdo.externalName, this.qdo.externalPhone, this.qdo.profitDesc, this.qdo.extString1, this.qdo.extString2, this.qdo.extString3, this.qdo.extString4, this.qdo.extString5, this.qdo.remark, this.qdo.oppoIdV4, this.qdo.checkStatus, this.qdoProject.createUserId, this.qdoProject.creator, this.qdoProject.createTime, this.qdoLeads.demandProductOrg, this.qdoLeads.marketChannel, this.qdo.isImplementation, this.qdo.implementCondition, this.qdo.onboarding, this.qdo.proResource, this.qdo.proInitiateReason, this.qdo.proPolicymakerDesc, this.qdo.contactBUDesc, this.qdo.productServe, this.qdo.benchmarkingCust, this.qdo.custTurnoverYear, this.qdo.isListedCompany, this.qdo.programSituation, this.qdo.teamResources, this.qdo.businessResources, this.qdo.codePreSaleUserId})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoProject)).on((Predicate)this.qdoProject.id.longValue().eq((Expression)this.qdo.projectId.longValue()))).leftJoin((EntityPath)this.qdoLeads)).on((Predicate)this.qdoLeads.id.longValue().eq((Expression)this.qdo.leadsId.longValue()))).leftJoin((EntityPath)this.qdoProject1)).on((Predicate)this.qdoProject1.id.longValue().eq((Expression)this.qdo.actId.longValue()))).leftJoin((EntityPath)this.qdoMember)).on((Predicate)this.qdoMember.projectId.longValue().eq((Expression)this.qdoProject.id.longValue()));
        return jpaQuery;
    }

    private JPAQuery<CrmOpportunityListVO> getJpaQuerySelectList() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmOpportunityListVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.projectId, this.qdo.preSaleUserId, this.qdo.preSaleOrgId, this.qdo.deliOrgId, this.qdo.deliUserId, this.qdo.forecastAmount, this.qdoProject.orgId, this.qdoProject.manageUserId, this.qdoProject.projectName, this.qdoProject.projectNo, this.qdoProject.projectStatus, this.qdoProject.eqvaPrice, this.qdo.custBookId, this.qdo.custBookName, this.qdo.oppoIdV4})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoProject)).on((Predicate)this.qdoProject.id.longValue().eq((Expression)this.qdo.projectId.longValue()));
        return jpaQuery;
    }

    public CrmOpportunityVO queryByKey(Long key) {
        JPAQuery<CrmOpportunityVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)key));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (CrmOpportunityVO)jpaQuery.fetchFirst();
    }

    public CrmOpportunityVO queryByOppoProjId(Long oppoProjId) {
        JPAQuery<CrmOpportunityVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)oppoProjId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (CrmOpportunityVO)jpaQuery.fetchFirst();
    }

    public CrmOpportunityDO queryByKeySimple(Long key) {
        CrmOpportunityDO entity = this.repo.findById(key).orElseGet(CrmOpportunityDO::new);
        return entity;
    }

    private JPAQuery<CrmOpportunityVO> getJpaQueryWhere(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds, List<Long> sapPermissionOrgIdList) {
        JPAQuery<CrmOpportunityVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getOrgId())) {
            jpaQuery.where((Predicate)this.qdoProject.orgId.eq((Object)query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getManageUserId())) {
            jpaQuery.where((Predicate)this.qdoProject.manageUserId.eq((Object)query.getManageUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            jpaQuery.where((Predicate)this.qdoProject.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectNameOrNo())) {
            jpaQuery.where((Predicate)this.qdoProject.projectName.like(SqlUtil.toSqlLikeString(query.getProjectNameOrNo())).or((Predicate)this.qdoProject.projectNo.like(SqlUtil.toSqlLikeString(query.getProjectNameOrNo()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getForecastWinDateRange())) {
            LocalDate startDate = null;
            LocalDate endDate = null;
            if ("0".equals(query.getForecastWinDateRange())) {
                endDate = LocalDate.now().plusMonths(3L);
            }
            if ("1".equals(query.getForecastWinDateRange())) {
                startDate = LocalDate.now().plusMonths(3L);
            }
            if ("2".equals(query.getForecastWinDateRange())) {
                startDate = LocalDate.now().plusMonths(6L);
            }
            if (startDate != null) {
                jpaQuery.where((Predicate)this.qdo.forecastWinDate.goe((Comparable)startDate));
            }
            if (endDate != null) {
                jpaQuery.where((Predicate)this.qdo.forecastWinDate.loe((Comparable)endDate));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreSaleOrgId())) {
            jpaQuery.where((Predicate)this.qdo.preSaleOrgId.eq((Object)query.getPreSaleOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreSaleUserId())) {
            jpaQuery.where((Predicate)this.qdo.preSaleUserId.eq((Object)query.getPreSaleUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliOrgId())) {
            jpaQuery.where((Predicate)this.qdo.deliOrgId.eq((Object)query.getDeliOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliUserId())) {
            jpaQuery.where((Predicate)this.qdo.deliUserId.eq((Object)query.getDeliUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustRegion())) {
            jpaQuery.where((Predicate)this.qdo.custRegion.eq((Object)query.getCustRegion()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectStatus())) {
            if ("0".equals(query.getProjectStatusType())) {
                jpaQuery.where((Predicate)this.qdoProject.projectStatus.eq((Object)query.getProjectStatus()));
            } else {
                jpaQuery.where((Predicate)this.qdoProject.projectStatus.ne((Object)query.getProjectStatus()));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustBookName())) {
            jpaQuery.where((Predicate)this.qdo.custBookName.like(SqlUtil.toSqlLikeString(query.getCustBookName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOppoLevel())) {
            jpaQuery.where((Predicate)this.qdo.oppoLevel.eq((Object)query.getOppoLevel()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsId())) {
            jpaQuery.where((Predicate)this.qdo.leadsId.eq((Object)query.getLeadsId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCoopBookId())) {
            jpaQuery.where((Predicate)this.qdo.coopBookId.eq((Object)query.getCoopBookId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCoopBookName())) {
            jpaQuery.where((Predicate)this.qdo.coopBookName.like(SqlUtil.toSqlLikeString(query.getCoopBookName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCoOrgId())) {
            jpaQuery.where((Predicate)this.qdo.coOrgId.eq((Object)query.getCoOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCodeliOrgId())) {
            jpaQuery.where((Predicate)this.qdo.codeliOrgId.eq((Object)query.getCodeliOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInternalOrgId())) {
            jpaQuery.where((Predicate)this.qdo.internalOrgId.eq((Object)query.getInternalOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInternalUserId())) {
            jpaQuery.where((Predicate)this.qdo.internalUserId.eq((Object)query.getInternalUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustIdst())) {
            jpaQuery.where((Predicate)this.qdo.custIdst.eq((Object)query.getCustIdst()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFormalCustomerId())) {
            jpaQuery.where((Predicate)this.qdo.formalCustomerId.eq((Object)query.getFormalCustomerId()));
        }
        if (oppoUserIds != null && !oppoUserIds.isEmpty()) {
            BooleanExpression temp2 = this.qdoMember.userId.in(oppoUserIds).or((Predicate)this.qdoProject.manageUserId.in(oppoUserIds)).or((Predicate)this.qdoProject.orgId.in(orgManageIds)).or((Predicate)this.qdo.preSaleOrgId.in(orgManageIds)).or((Predicate)this.qdo.deliOrgId.in(orgManageIds)).or((Predicate)this.qdo.coOrgId.in(orgManageIds)).or((Predicate)this.qdo.codeliOrgId.in(orgManageIds)).or((Predicate)this.qdo.internalOrgId.in(orgManageIds));
            if (CollectionUtils.isNotEmpty(sapPermissionOrgIdList)) {
                temp2 = ExpressionUtils.or((Predicate)temp2, (Predicate)this.qdo.preSaleOrgId.in(sapPermissionOrgIdList).or((Predicate)this.qdo.deliOrgId.in(sapPermissionOrgIdList)));
            }
            jpaQuery.where((Predicate)temp2);
            jpaQuery.where((Predicate)this.qdoMember.deleteFlag.eq((Object)0));
        }
        if (!ObjectUtils.isEmpty((Object[])query.getOppoIds())) {
            jpaQuery.where((Predicate)this.qdo.id.in((Object[])query.getOppoIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOppoIdsV4())) {
            jpaQuery.where((Predicate)this.qdo.oppoIdV4.in((Collection)query.getOppoIdsV4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceType())) {
            jpaQuery.where((Predicate)this.qdo.sourceType.eq((Object)query.getSourceType()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getCheckStatus())) {
            jpaQuery.where((Predicate)this.qdo.checkStatus.eq((Object)query.getCheckStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getProjectImportance())) {
            jpaQuery.where((Predicate)this.qdo.projectImportance.eq((Object)query.getProjectImportance()));
        }
        jpaQuery.groupBy(this.qdoProject.id);
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoProject.deleteFlag.eq((Object)0));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(query.getOrders(), this.qdo, this.qdoProject));
        return jpaQuery;
    }

    public PagingVO<CrmOpportunityVO> queryPaging(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds, List<Long> sapPermissionOrgIdList) {
        JPAQuery<CrmOpportunityVO> jpaQuery = this.getJpaQueryWhere(query, oppoUserIds, orgManageIds, sapPermissionOrgIdList);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public List<CrmOpportunityVO> queryList(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds) {
        JPAQuery<CrmOpportunityVO> jpaQuery = this.getJpaQueryWhere(query, oppoUserIds, orgManageIds, null);
        return jpaQuery.fetch();
    }

    public List<CrmOpportunityListVO> queryList() {
        JPAQuery<CrmOpportunityListVO> jpaQuery = this.getJpaQuerySelectList();
        ((JPAQuery)jpaQuery.distinct()).where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<CrmOpportunityListVO> queryListDynamic(CrmOpportunityQuery query) {
        JPAQuery<CrmOpportunityListVO> jpaQuery = this.getJpaQuerySelectList();
        ((JPAQuery)jpaQuery.distinct()).where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        if (query.getProjectStatus() != null) {
            jpaQuery.where((Predicate)this.qdoProject.projectStatus.eq((Object)query.getProjectStatus()));
        }
        if (query.getPreSaleUserId() != null) {
            jpaQuery.where((Predicate)this.qdo.preSaleUserId.eq((Object)query.getPreSaleUserId()));
        }
        if (query.getProjectId() != null) {
            jpaQuery.where((Predicate)this.qdoProject.id.eq((Object)query.getProjectId()));
        }
        if (query.getProjectIds() != null) {
            jpaQuery.where((Predicate)this.qdoProject.id.in((Collection)query.getProjectIds()));
        }
        if (query.getIds() != null) {
            jpaQuery.where((Predicate)this.qdo.id.in((Collection)query.getIds()));
        }
        if (query.getIsPermission().booleanValue()) {
            BooleanExpression orExpression = this.qdo.preSaleUserId.eq((Object)query.getLoginUserId());
            if (!ObjectUtils.isEmpty((Object)query.getPreSaleOrgIds())) {
                orExpression = orExpression.or((Predicate)this.qdo.preSaleOrgId.in((Collection)query.getPreSaleOrgIds()));
            }
            jpaQuery.where((Predicate)orExpression);
        }
        return jpaQuery.fetch();
    }

    public long updateStatus(Long key, String projectStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoProject).set((Path)this.qdoProject.projectStatus, (Object)projectStatus);
        update.where(new Predicate[]{this.qdoProject.id.eq((Object)key)});
        return update.execute();
    }

    public List<Map<String, Object>> queryEmployees(Set<Long> userIds) {
        return this.repo.queryEmployees(userIds);
    }

    public List<Map<String, Object>> queryOrgs(Set<Long> orgIds) {
        return this.repo.queryOrgs(orgIds);
    }

    public List<Map<String, Object>> queryBooks(Set<Long> bookIds) {
        return this.repo.queryBookList(bookIds);
    }

    public List<Long> findNotBindOppos() {
        return this.repo.findNotBindOppos();
    }

    public Long getIdByV4(Long oppoIdV4) {
        return this.repo.getIdByV4(oppoIdV4) == null ? null : this.repo.getIdByV4(oppoIdV4).get(0);
    }

    public void deleteSoft(Long id) {
        this.repo.deleteSoft(id);
    }

    public List<Map<String, Object>> getV4AndV5OppoIds() {
        return this.repo.getV4AndV5OppoIds();
    }

    public long updateCheckStatus(Long oppoId, Boolean flag) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.checkStatus, (Object)(flag != false ? "1" : "0"));
        update.where(new Predicate[]{this.qdo.id.eq((Object)oppoId)});
        return update.execute();
    }

    public List<Long> queryByFormalCustomerId(Long customerId) {
        return this.repo.queryByFormalCustomerId(customerId);
    }

    public List<CrmActProjectVO> queryListByCustomId(Long customId) {
        JPAQuery<CrmActProjectVO> jpaQuery = this.getJpaQuerySelectProject();
        jpaQuery.where((Predicate)this.qdo.formalCustomerId.eq((Object)customId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoProject.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public CrmOpportunityVO queryByProjectNo(String projectNo) {
        JPAQuery jpaQuery = (JPAQuery)this.getJpaQuerySelect().where((Predicate)this.qdoProject.projectNo.eq((Object)projectNo));
        return (CrmOpportunityVO)jpaQuery.fetchFirst();
    }

    public List<CrmOpportunityVO> findByOrgIdIn(List<Long> orgIds) {
        JPAQuery jpaQuery = (JPAQuery)this.getJpaQuerySelect().where((Predicate)this.qdoProject.orgId.in(orgIds));
        return jpaQuery.fetch();
    }

    public List<CrmOpportunityVO> findByMemberIdIdEq(Long userID) {
        JPAQuery jpaQuery = (JPAQuery)this.getJpaQuerySelect().where((Predicate)this.qdoMember.userId.eq((Object)userID));
        return jpaQuery.fetch();
    }

    public Long findOrgIdByDocNo(String docNo) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdoProject.orgId).from((EntityPath)this.qdoProject)).where((Predicate)this.qdoProject.projectNo.eq((Object)docNo));
        return (Long)jpaQuery.fetchFirst();
    }

    public CrmOpportunityDAO(JPAQueryFactory jpaQueryFactory, CrmOpportunityRepo repo, CrmOpportunitySalesRepo repoSales, CrmOpportunityStakeholderRepo repoStakeholder, CrmOpportunityPartnerRepo repoPartner, CrmOpportunityCompetitorRepo repoCompetitor, CrmOpportunityAnalyzeRepo repoAnalyze) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
        this.repoSales = repoSales;
        this.repoStakeholder = repoStakeholder;
        this.repoPartner = repoPartner;
        this.repoCompetitor = repoCompetitor;
        this.repoAnalyze = repoAnalyze;
    }
}

