/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeopleEducatePayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleEducateService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleEducateVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmPeopleEducateConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPeopleEducateDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPeopleEducateDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPeopleEducateRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class CrmPeopleEducateServiceImpl
implements CrmPeopleEducateService {
    private static final Logger log = LoggerFactory.getLogger(CrmPeopleEducateServiceImpl.class);
    private final CrmPeopleEducateRepo repo;
    private final CrmPeopleEducateDAO dao;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;

    @Transactional(rollbackFor={Exception.class})
    public CrmPeopleEducateVO insertOrUpdate(CrmPeopleEducatePayload payload) {
        this.check(payload);
        CrmPeopleEducateDO entityDo = CrmPeopleEducateConvert.INSTANCE.toDo(payload);
        String name = PrdSystemLogEnum.UPDATE.getDesc();
        if (ObjectUtils.isEmpty((Object)payload.getId())) {
            name = PrdSystemLogEnum.CREATE.getDesc();
        }
        entityDo = (CrmPeopleEducateDO)((Object)this.repo.save((Object)entityDo));
        this.logService.saveNewLog(entityDo.getPeopleId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getCode(), name + PrdSystemObjectEnum.CRM_PEOPLE_EDUCATE.getDesc());
        return CrmPeopleEducateConvert.INSTANCE.toVo(entityDo);
    }

    public CrmPeopleEducateVO queryByKey(Long key) {
        CrmPeopleEducateVO educateVO = this.dao.queryByKey(key);
        this.transferData(educateVO);
        return educateVO;
    }

    public List<CrmPeopleEducateVO> queryList(Long peopleId) {
        List<CrmPeopleEducateVO> peopleEducateVOS = this.dao.queryList(peopleId);
        peopleEducateVOS.forEach(peopleEducate -> this.transferData((CrmPeopleEducateVO)peopleEducate));
        return peopleEducateVOS;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        CrmPeopleEducateVO educateVO = this.dao.queryByKey(keys.get(0));
        this.logService.saveNewLog(educateVO.getPeopleId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getCode(), PrdSystemLogEnum.DELETE.getDesc() + PrdSystemObjectEnum.CRM_PEOPLE_EDUCATE.getDesc());
        this.dao.deleteSoft(keys);
    }

    void check(CrmPeopleEducatePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getPeopleId())) {
            throw TwException.error("", "\u5173\u8054\u4eba\u8109\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSchool())) {
            throw TwException.error("", "\u5b66\u6821\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getEducation())) {
            throw TwException.error("", "\u5b66\u5386\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getStartDate())) {
            throw TwException.error("", "\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    void transferData(CrmPeopleEducateVO educateVO) {
        educateVO.setEducationDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPeopleEducate.getCode(), educateVO.getEducation()));
    }

    public CrmPeopleEducateServiceImpl(CrmPeopleEducateRepo repo, CrmPeopleEducateDAO dao, PrdSystemLogService logService, CacheUtil cacheUtil) {
        this.repo = repo;
        this.dao = dao;
        this.logService = logService;
        this.cacheUtil = cacheUtil;
    }
}

