/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.EmployeeDepartPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.EmployeeDepartApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.EmployeeDepartService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartApplyBSVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartApplyVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartCheckVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResDepartCheckPointVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetService;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.EmployeeDepartApplyConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.EmployeeDepartApplyDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.EmployeeDepartApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.EmployeeDepartApplyRepo;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class EmployeeDepartServiceImpl
implements EmployeeDepartService {
    private static final Logger log = LoggerFactory.getLogger(EmployeeDepartServiceImpl.class);
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final WorkflowUtil workflowUtil;
    private final PrdSystemRoleDAO prdSystemRoleDAO;
    private final EmployeeDepartApplyDAO departApplyDAO;
    private final PrdOrgEmployeeDAO dao;
    private final PrdUserDAO userDAO;
    private final CacheUtil cacheUtil;
    private final TimesheetService timesheetService;
    private BeanSearcher beanSearcher;
    private final CalTaskSettleService calTaskSettleService;
    private final AccReimService accReimService;
    private final PmsProjectService pmsProjectService;
    private final CrmOpportunityService crmOpportunityService;
    private final PrdMessageConfigService messageConfigService;
    private final PrdSystemRoleService roleService;
    private final EmployeeDepartApplyRepo repo;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.EMPLOYEE_DEPART_APPLY);
    }

    @Transactional
    public void employeeDepart(EmployeeDepartPayload payload) {
        if (payload.getProcInstId() == null) {
            payload.setId(null);
            this.startDepartPrco(payload);
        } else {
            this.updateEmployeeDepartData(payload);
        }
    }

    public void startDepartPrco(EmployeeDepartPayload payload) {
        List<EmployeeDepartApplyDO> employeeDepartApplyDOList = this.departApplyDAO.queryByEmployeeId(payload.getEmployeeId());
        if (!ObjectUtils.isEmpty(employeeDepartApplyDOList)) {
            for (EmployeeDepartApplyDO employeeDepartApplyDO : employeeDepartApplyDOList) {
                if (ObjectUtils.isEmpty((Object)employeeDepartApplyDO.getProcInstStatus()) || !employeeDepartApplyDO.getProcInstStatus().equals((Object)ProcInstStatus.APPROVING)) continue;
                throw TwException.error("", "\u60a8\u6709\u5ba1\u6279\u4e2d\u7684\u79bb\u804c\u6d41\u7a0b\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
            }
        }
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        Long employeeId = payload.getEmployeeId();
        PrdOrgEmployeeVO employeeVO = this.prdOrgEmployeeService.queryByKey(employeeId);
        HashMap<String, Object> variables = this.setWorkFlowVar(payload);
        String procInstName = "A31.\u79bb\u804c\u6d41\u7a0b-" + employeeVO.getEmployeeName();
        EmployeeDepartApplyDO employeeDepartApplyDO = EmployeeDepartApplyConvert.INSTANCE.payloadToDo(payload);
        employeeDepartApplyDO.setProcInstName(procInstName);
        employeeDepartApplyDO.setCreateTime(LocalDateTime.now());
        EmployeeDepartApplyDO employeeDepartApplySaveDO = this.departApplyDAO.save(employeeDepartApplyDO);
        processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.RES_DEPART.name(), (String)procInstName, (String)("" + employeeDepartApplySaveDO.getId()), variables), new Long[0]);
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setId(employeeDepartApplySaveDO.getId());
        this.departApplyDAO.updateProcData(payload);
        PrdOrgEmployeePayload employeePayload = new PrdOrgEmployeePayload();
        employeePayload.setProcInstStatus(processInfo.getProcInstStatus());
        employeePayload.setId(payload.getEmployeeId());
        this.dao.updateProcessDate(employeePayload);
        this.dao.updateResStatus(employeeId, "4");
        String userName = this.cacheUtil.getUserName(employeeDepartApplySaveDO.getUserId());
        String title = "\u5458\u5de5\u79bb\u804c-" + userName;
        String content = "\u5458\u5de5" + userName + "\u53d1\u8d77\u4e86\u79bb\u804c\u7533\u8bf7\uff0c\u7533\u8bf7\u79bb\u804c\u539f\u56e0\u4e3a:" + employeeDepartApplySaveDO.getLeaveDesc();
        this.sendMessage(employeeDepartApplySaveDO.getId(), title, content);
    }

    public HashMap<String, Object> setWorkFlowVar(EmployeeDepartPayload payload) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Long employeeId = payload.getEmployeeId();
        PrdOrgEmployeeVO employeeVO = this.prdOrgEmployeeService.queryByKey(employeeId);
        Long userId = employeeVO.getUserId();
        if (payload.getJobHandOverFlag() != null) {
            variables.put("workHandoverFlag", payload.getJobHandOverFlag());
        }
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.dao.queryUserOrgData(userId);
        variables.put("Activity_1xxb5sz", CollUtil.newArrayList((Object[])new Long[]{prdOrgEmployeeRefVO.getParentId()}));
        variables.put("Activity_0r5xzs9", CollUtil.newArrayList((Object[])new Long[]{prdOrgEmployeeRefVO.getManageId()}));
        if (payload.getJobHandOverId() != null) {
            variables.put("Activity_1lhkue9", CollUtil.newArrayList((Object[])new Long[]{payload.getJobHandOverId()}));
        }
        List<Long> accountantIds = this.prdSystemRoleDAO.queryUserIdByRoleCode(RoleEnum.PLAT_GL_ACCOUNTANT.getCode());
        variables.put("Activity_1v1a4mr", accountantIds);
        List<Long> administrationIds = this.prdSystemRoleDAO.queryUserIdByRoleCode(RoleEnum.PLAT_OFFI_AM.getCode());
        variables.put("Activity_1ltgrs3", administrationIds);
        List<Long> empRelIds = this.prdSystemRoleDAO.queryUserIdByRoleCodes(CollUtil.newArrayList((Object[])new String[]{RoleEnum.PLAT_ERM.getCode(), RoleEnum.PLAT_ERS.getCode()}));
        variables.put("Activity_1j4rmve", empRelIds);
        List<Long> itAdminIds = this.prdSystemRoleDAO.queryUserIdByRoleCode(RoleEnum.PLATFORM_IT_ADMINISTRATOR.getCode());
        variables.put("Activity_09urufw", itAdminIds);
        return variables;
    }

    public void updateEmployeeDepartData(EmployeeDepartPayload payload) {
        EmployeeDepartApplyDO departApplyDO = this.repo.findById(payload.getId()).orElseGet(EmployeeDepartApplyDO::new);
        EmployeeDepartApplyDO employeeDepartApplyDO = EmployeeDepartApplyConvert.INSTANCE.payloadToDo(payload);
        departApplyDO.copy(employeeDepartApplyDO);
        this.departApplyDAO.save(departApplyDO);
        this.updateWorkFlowVar(payload);
    }

    public EmployeeDepartApplyVO queryEmployeeDepart(String prcoId) {
        EmployeeDepartApplyDO employeeDepartApplyDO = this.departApplyDAO.findByPrcoId(prcoId);
        return EmployeeDepartApplyConvert.INSTANCE.doToVo(employeeDepartApplyDO);
    }

    public EmployeeDepartCheckVO employeeDepartCheck(Long employeeId) {
        EmployeeDepartCheckVO checkVO = new EmployeeDepartCheckVO();
        PrdOrgEmployeeVO orgEmployeeVO = this.prdOrgEmployeeService.queryByKey(employeeId);
        Long userId = orgEmployeeVO.getUserId();
        List<String> orgRoles = this.departApplyDAO.queryOrgRoleByUserId("" + userId);
        List<String> roleCodes = this.cacheUtil.getSystemRoleCodes(userId);
        List<PrdSystemRoleVO> sysRoleVOList = this.prdSystemRoleDAO.queryByCodeIn(roleCodes);
        ResDepartCheckPointVO resDepartCheckPointVO = new ResDepartCheckPointVO();
        ArrayList vacationCheckVOList = new ArrayList();
        if (sysRoleVOList != null && !sysRoleVOList.isEmpty()) {
            ArrayList<String> roleNameList = new ArrayList<String>();
            for (PrdSystemRoleVO systemRoleVO : sysRoleVOList) {
                roleNameList.add(systemRoleVO.getRoleName());
            }
            resDepartCheckPointVO.setProcessApprCheckRole("\u7cfb\u7edf\u89d2\u8272:" + roleNameList + ";\u7ec4\u7ec7\u89d2\u8272:" + orgRoles);
        }
        TimesheetQuery query = new TimesheetQuery();
        query.setTsUserId(userId);
        ArrayList<String> tsStatusList = new ArrayList<String>();
        tsStatusList.add("CREATE");
        tsStatusList.add("REJECTED");
        query.setTsStatusList(tsStatusList);
        List timesheetVOList = this.timesheetService.queryList(query);
        boolean timesheetSubmitCheckFlag = timesheetVOList.isEmpty();
        resDepartCheckPointVO.setTimesheetSubmitCheck(Boolean.valueOf(timesheetSubmitCheckFlag));
        Boolean eqvaCheckFlag = true;
        CalTaskSettleQuery calTaskSettleQuery = new CalTaskSettleQuery();
        calTaskSettleQuery.setIncomeResId(userId);
        List calTaskSettleVOList = this.calTaskSettleService.queryListDynamic(calTaskSettleQuery);
        if (!ObjectUtils.isEmpty((Object)calTaskSettleVOList)) {
            for (CalTaskSettleVO calTaskSettleVO : calTaskSettleVOList) {
                if (ObjectUtils.isEmpty((Object)calTaskSettleVO.getSettleStatus()) || !calTaskSettleVO.getSettleStatus().equals("CREATE") && !calTaskSettleVO.getSettleStatus().equals("IN PROCESS")) continue;
                eqvaCheckFlag = false;
                break;
            }
        }
        resDepartCheckPointVO.setEqvaCheck(eqvaCheckFlag);
        AccReimQuery accReimQuery = new AccReimQuery();
        accReimQuery.setMyReimUserId(userId);
        accReimQuery.setReimUserId(userId);
        List accReimVOList = this.accReimService.queryListDynamic(accReimQuery);
        Boolean reimbursementDocCheck = true;
        if (!ObjectUtils.isEmpty((Object)accReimVOList)) {
            for (AccReimVO accReimVO : accReimVOList) {
                if (ObjectUtils.isEmpty((Object)accReimVO.getReimStatus()) || !accReimVO.getReimStatus().equals("CREATE") && !accReimVO.getReimStatus().equals("APPLYING") && !accReimVO.getReimStatus().equals("FINANCIAL_AUDIT")) continue;
                reimbursementDocCheck = false;
                break;
            }
        }
        resDepartCheckPointVO.setReimbursementDocCheck(reimbursementDocCheck);
        Boolean processCheckFlag = true;
        ArrayList projList = new ArrayList();
        PmsProjectQuery pmsProjectQuery = new PmsProjectQuery();
        pmsProjectQuery.setDeliUserId(userId);
        List projectVOList = this.pmsProjectService.queryListDynamic(pmsProjectQuery);
        if (!ObjectUtils.isEmpty((Object)projectVOList)) {
            projList.addAll(projectVOList);
        }
        PmsProjectQuery PmPmsProjectQuery = new PmsProjectQuery();
        pmsProjectQuery.setPmResId(userId);
        List pmProjectVOList = this.pmsProjectService.queryListDynamic(PmPmsProjectQuery);
        if (!ObjectUtils.isEmpty((Object)pmProjectVOList)) {
            projList.addAll(pmProjectVOList);
        }
        if (!ObjectUtils.isEmpty(projList)) {
            for (PmsProjectVO pmsProjectVO : projList) {
                if (ObjectUtils.isEmpty((Object)pmsProjectVO.getProjStatus()) || !pmsProjectVO.getProjStatus().equals("ACTIVE") && !pmsProjectVO.getProjStatus().equals("PENDING")) continue;
                processCheckFlag = false;
                break;
            }
        }
        resDepartCheckPointVO.setProcessCheck(processCheckFlag);
        Boolean businessOpportunityCheckFlag = true;
        ArrayList crmOppoList = new ArrayList();
        CrmOpportunityQuery crmOpportunityQuery = new CrmOpportunityQuery();
        crmOpportunityQuery.setManageUserId(userId);
        List crmOpportunityListVOList = this.crmOpportunityService.queryListDynamic(crmOpportunityQuery);
        if (!ObjectUtils.isEmpty((Object)crmOpportunityListVOList)) {
            crmOppoList.addAll(crmOpportunityListVOList);
        }
        CrmOpportunityQuery delCrmOpportunityQuery = new CrmOpportunityQuery();
        crmOpportunityQuery.setDeliUserId(userId);
        List delCrmOpportunityListVOList = this.crmOpportunityService.queryListDynamic(delCrmOpportunityQuery);
        if (!ObjectUtils.isEmpty((Object)delCrmOpportunityListVOList)) {
            crmOppoList.addAll(delCrmOpportunityListVOList);
        }
        if (!ObjectUtils.isEmpty(crmOppoList)) {
            for (CrmOpportunityListVO crmOpportunityListVO : crmOppoList) {
                if (ObjectUtils.isEmpty((Object)crmOpportunityListVO.getProjectStatus()) || crmOpportunityListVO.getProjectStatus().equals("CLOSED")) continue;
                businessOpportunityCheckFlag = false;
                break;
            }
        }
        resDepartCheckPointVO.setBusinessOpportunityCheck(businessOpportunityCheckFlag);
        resDepartCheckPointVO.setLowResCheck(Boolean.valueOf(false));
        resDepartCheckPointVO.setBuLeaderCheck(Boolean.valueOf(false));
        resDepartCheckPointVO.setClueCheck(Boolean.valueOf(false));
        resDepartCheckPointVO.setProjectCheck(Boolean.valueOf(false));
        resDepartCheckPointVO.setTaskCheck(Boolean.valueOf(false));
        resDepartCheckPointVO.setTimesheetApprCheck(Boolean.valueOf(false));
        resDepartCheckPointVO.setProcessApprCheck(Boolean.valueOf(false));
        checkVO.setResDepartCheck(resDepartCheckPointVO);
        checkVO.setVacationCheckList(vacationCheckVOList);
        return checkVO;
    }

    public PagingVO<EmployeeDepartApplyVO> employeeDepartApplyList(EmployeeDepartApplyQuery query) {
        return this.departApplyDAO.queryPaging(query);
    }

    public PagingVO<EmployeeDepartApplyBSVO> permissionPaging(EmployeeDepartApplyQuery query) {
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = this.beanSearcher.searchCount(EmployeeDepartApplyBSVO.class, mapBuilder.build());
        if (totalNum.equals(0)) {
            return null;
        }
        List employeeDepartApplyVOList = this.beanSearcher.searchList(EmployeeDepartApplyBSVO.class, mapBuilder.build());
        return PagingVO.builder().records(employeeDepartApplyVOList).total(((Long)totalNum).longValue()).build();
    }

    private MapBuilder pageWhereBuilder(EmployeeDepartApplyQuery query) {
        MapBuilder builder = MapUtils.builder();
        SqlUtil.handleBS(builder, (TwQueryParam)query);
        return builder;
    }

    public void updateWorkFlowVar(EmployeeDepartPayload payload) {
        HashMap<String, Object> variables = this.setWorkFlowVar(payload);
        SetVariablesPayload setVariablesPayload = new SetVariablesPayload();
        setVariablesPayload.setProcInstId(payload.getProcInstId());
        setVariablesPayload.setVariables(variables);
        this.workflowUtil.setVaribales(setVariablesPayload);
    }

    public EmployeeDepartApplyVO queryByKey(Long applyId) {
        return this.departApplyDAO.queryByKey(applyId);
    }

    public void sendMessage(Long objectId, String messageTitle, String content) {
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(Integer.valueOf(2));
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.personnelMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(Integer.valueOf(0));
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(Integer.valueOf(3));
        ado.setMessageContent(content);
        ArrayList list = new ArrayList();
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ERM.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ERS.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode()));
        list.addAll(this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_SPECIALIST.getCode()));
        if (!CollectionUtils.isEmpty(list)) {
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            this.messageConfigService.insert(ado);
        }
    }

    public EmployeeDepartServiceImpl(PrdOrgEmployeeService prdOrgEmployeeService, WorkflowUtil workflowUtil, PrdSystemRoleDAO prdSystemRoleDAO, EmployeeDepartApplyDAO departApplyDAO, PrdOrgEmployeeDAO dao, PrdUserDAO userDAO, CacheUtil cacheUtil, TimesheetService timesheetService, CalTaskSettleService calTaskSettleService, AccReimService accReimService, PmsProjectService pmsProjectService, CrmOpportunityService crmOpportunityService, PrdMessageConfigService messageConfigService, PrdSystemRoleService roleService, EmployeeDepartApplyRepo repo) {
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.workflowUtil = workflowUtil;
        this.prdSystemRoleDAO = prdSystemRoleDAO;
        this.departApplyDAO = departApplyDAO;
        this.dao = dao;
        this.userDAO = userDAO;
        this.cacheUtil = cacheUtil;
        this.timesheetService = timesheetService;
        this.calTaskSettleService = calTaskSettleService;
        this.accReimService = accReimService;
        this.pmsProjectService = pmsProjectService;
        this.crmOpportunityService = crmOpportunityService;
        this.messageConfigService = messageConfigService;
        this.roleService = roleService;
        this.repo = repo;
    }
}

