/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetApproveQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class TimesheetDAO {
    private static final QTimesheetDO qdo = QTimesheetDO.timesheetDO;
    private final QPrdOrgEmployeeDO edo = new QPrdOrgEmployeeDO("prdOrgEmployeeDO");
    private final QPrdOrgEmployeeDO edo1 = new QPrdOrgEmployeeDO("prdOrgEmployeeDO1");
    private static final QPrdOrgOrganizationDO odo = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final CacheUtil cacheUtil;
    private final TimesheetRepo timesheetRepo;

    public List<TimesheetVO> queryListByVactionIds(List<Long> vacationApplyDetailIds) {
        JPAQuery<TimesheetVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(vacationApplyDetailIds)) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.vacationApplyDetailId.in(vacationApplyDetailIds));
        }
        return jpaQuery.fetch();
    }

    private JPAQuery<TimesheetVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TimesheetVO.class, (Expression[])new Expression[]{TimesheetDAO.qdo.id, TimesheetDAO.qdo.tsUserId, TimesheetDAO.qdo.tsUserBuId, TimesheetDAO.qdo.tsUserBuName, TimesheetDAO.qdo.tsStatus, TimesheetDAO.qdo.type, TimesheetDAO.qdo.apprUserId, TimesheetDAO.qdo.operPlanId, TimesheetDAO.qdo.operPlanName, TimesheetDAO.qdo.projId, TimesheetDAO.qdo.projName, TimesheetDAO.qdo.taskId, TimesheetDAO.qdo.taskNo, TimesheetDAO.qdo.taskName, TimesheetDAO.qdo.taskPackageId, TimesheetDAO.qdo.taskPackageName, TimesheetDAO.qdo.taskPackageNo, TimesheetDAO.qdo.taskApplyStatus, TimesheetDAO.qdo.actId, TimesheetDAO.qdo.actName, TimesheetDAO.qdo.actNo, TimesheetDAO.qdo.eqva, TimesheetDAO.qdo.workType, TimesheetDAO.qdo.workDate, TimesheetDAO.qdo.workHour, TimesheetDAO.qdo.workDesc, TimesheetDAO.qdo.weekStartDate, TimesheetDAO.qdo.yearWeek, TimesheetDAO.qdo.totalManday, TimesheetDAO.qdo.totalWorkHour, TimesheetDAO.qdo.apprStatus, TimesheetDAO.qdo.tsTaskIden, TimesheetDAO.qdo.tsActIden, TimesheetDAO.qdo.settleStatus, TimesheetDAO.qdo.apprResult, TimesheetDAO.qdo.workFlag, TimesheetDAO.qdo.workDayOff, TimesheetDAO.qdo.workRelId, TimesheetDAO.qdo.workDayOffStatus, TimesheetDAO.qdo.workPlanId, TimesheetDAO.qdo.approvalTime, TimesheetDAO.qdo.submitTime, TimesheetDAO.qdo.lastSubmitTime, TimesheetDAO.qdo.autoSaveFlag, TimesheetDAO.qdo.autoUpdateFlag, TimesheetDAO.qdo.returnFlag, TimesheetDAO.qdo.reasonId, TimesheetDAO.qdo.reasonName, TimesheetDAO.qdo.reasonType, TimesheetDAO.qdo.procId, TimesheetDAO.qdo.ut, TimesheetDAO.qdo.vacationApplyDetailId, TimesheetDAO.qdo.bangwo8No, TimesheetDAO.qdo.bangwo8WorkHour, TimesheetDAO.qdo.location})).from((EntityPath)qdo);
        return jpaQuery;
    }

    private JPAQuery<TimesheetVO> getJpaQueryWhere(TimesheetQuery query) {
        JPAQuery<TimesheetVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getActName())) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.actName.like(SqlUtil.toSqlLikeString(query.getActName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskName())) {
            String actIden = this.cacheUtil.getSystemSelectionValueByName("prd:timesheet:actType", query.getTaskName());
            if (StringUtils.hasText((String)actIden) && !query.getTaskName().equals(actIden)) {
                jpaQuery.where((Predicate)TimesheetDAO.qdo.taskName.like(SqlUtil.toSqlLikeString(query.getTaskName())).or((Predicate)TimesheetDAO.qdo.tsActIden.eq((Object)actIden)));
            } else {
                jpaQuery.where((Predicate)TimesheetDAO.qdo.taskName.like(SqlUtil.toSqlLikeString(query.getTaskName())));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskPackageName())) {
            if (query.getTaskPackageName().equals("\u65e0\u4efb\u52a1")) {
                jpaQuery.where((Predicate)TimesheetDAO.qdo.taskPackageName.like(SqlUtil.toSqlLikeString(query.getTaskPackageName())).or((Predicate)TimesheetDAO.qdo.projId.isNull().or((Predicate)TimesheetDAO.qdo.projId.eq((Object)0L)).and((Predicate)TimesheetDAO.qdo.taskPackageId.isNull().or((Predicate)TimesheetDAO.qdo.taskPackageId.eq((Object)0L)))));
            } else {
                jpaQuery.where((Predicate)TimesheetDAO.qdo.taskPackageName.like(SqlUtil.toSqlLikeString(query.getTaskPackageName())));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjId())) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.projId.eq((Object)query.getProjId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTsUserId())) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.tsUserId.eq((Object)query.getTsUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTsUserBuId())) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.tsUserBuId.eq((Object)query.getTsUserBuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTsStatus())) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.tsStatus.eq((Object)query.getTsStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTsStatusList())) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.tsStatus.in((Collection)query.getTsStatusList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonType())) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.reasonType.eq((Object)query.getReasonType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonTypes())) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.reasonType.in((Collection)query.getReasonTypes()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonId())) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.reasonId.eq((Object)query.getReasonId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonIdList())) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.reasonId.in((Collection)query.getReasonIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprUserId())) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.apprUserId.eq((Object)query.getApprUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTsUserIdList())) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.tsUserId.in((Collection)query.getTsUserIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkDateBetween())) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.workDate.between((Comparable)((LocalDate)query.getWorkDateBetween().get(0)), (Comparable)((LocalDate)query.getWorkDateBetween().get(1))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkDate())) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.workDate.between((Comparable)((LocalDate)query.getWorkDate().get(0)), (Comparable)((LocalDate)query.getWorkDate().get(1))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNonHolidayFlag()) && query.getNonHolidayFlag() == 1) {
            jpaQuery.where((Predicate)TimesheetDAO.qdo.tsTaskIden.isNull().or((Predicate)TimesheetDAO.qdo.tsTaskIden.ne((Object)"VACATION")).and((Predicate)TimesheetDAO.qdo.tsActIden.isNull().or((Predicate)TimesheetDAO.qdo.tsActIden.ne((Object)"LEGALHOLIDAY"))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNoTaskFlag())) {
            if (query.getNoTaskFlag() == 0) {
                jpaQuery.where((Predicate)TimesheetDAO.qdo.taskPackageId.isNull().or((Predicate)TimesheetDAO.qdo.taskPackageId.eq((Object)0L)));
            }
            if (query.getNoTaskFlag() == 1) {
                jpaQuery.where((Predicate)TimesheetDAO.qdo.taskPackageId.gt((Number)0L));
            }
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, TimesheetDAO.qdo._super, (TwQueryParam)query);
        ArrayList<OrderItem> orderse = new ArrayList<OrderItem>();
        orderse.add(OrderItem.desc((String)"workDate"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, orderse));
        jpaQuery.groupBy(TimesheetDAO.qdo.id);
        return jpaQuery;
    }

    public PagingVO<TimesheetVO> queryPaging(TimesheetQuery query) {
        JPAQuery<TimesheetVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public List<TimesheetVO> queryList(TimesheetQuery query) {
        JPAQuery<TimesheetVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public List<LocalDate> writedDate(Long userId, LocalDate startDate, LocalDate endDate) {
        List<Date> dates = this.timesheetRepo.queryWritedTsDateList(startDate, endDate, userId);
        List<LocalDate> collect = dates.stream().map(date -> date.toLocalDate()).collect(Collectors.toList());
        return collect;
    }

    public List<LocalDate> backDate(Long userId, LocalDate startDate, LocalDate endDate) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(TimesheetDAO.qdo.workDate).from((EntityPath)qdo)).where((Predicate)TimesheetDAO.qdo.workDate.between((Comparable)startDate, (Comparable)endDate))).where((Predicate)TimesheetDAO.qdo.tsUserId.eq((Object)userId))).where((Predicate)TimesheetDAO.qdo.tsStatus.eq((Object)"REJECTED"))).groupBy(new Expression[]{TimesheetDAO.qdo.workDate, TimesheetDAO.qdo.tsUserId})).fetch();
    }

    public List<TimesheetApproveQuery> approvingDate(LocalDate startDate, LocalDate endDate) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TimesheetApproveQuery.class, (Expression[])new Expression[]{TimesheetDAO.qdo.tsUserId, TimesheetDAO.qdo.workDate, TimesheetDAO.qdo.apprUserId, this.edo.employeeName, this.edo1.employeeName.as("apprName"), this.edo1.wecomId.as("apprWxId")})).from((EntityPath)qdo)).leftJoin((EntityPath)this.edo)).on((Predicate)this.edo.userId.eq(TimesheetDAO.qdo.tsUserId))).leftJoin((EntityPath)this.edo1)).on((Predicate)this.edo1.userId.eq(TimesheetDAO.qdo.apprUserId))).where((Predicate)TimesheetDAO.qdo.workDate.between((Comparable)startDate, (Comparable)endDate))).where((Predicate)TimesheetDAO.qdo.tsStatus.eq((Object)"APPROVING"))).where((Predicate)TimesheetDAO.qdo.tsTaskIden.notIn((Object[])new String[]{"VACATION"}).or((Predicate)TimesheetDAO.qdo.tsTaskIden.isNull()))).where((Predicate)TimesheetDAO.qdo.apprUserId.isNotNull())).where((Predicate)TimesheetDAO.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.edo1.employeeNo.notIn((Object[])new String[]{"80100001", "80100098"}))).groupBy(new Expression[]{TimesheetDAO.qdo.tsUserId, TimesheetDAO.qdo.apprUserId})).fetch();
    }

    public List<Long> getWeekNotWorkDate(LocalDate firstDayOfMonth, LocalDate lastDayOfMonth) {
        List res = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(TimesheetDAO.qdo.id).from((EntityPath)qdo)).where((Predicate)TimesheetDAO.qdo.workHour.eq((Object)new BigDecimal(8)))).where((Predicate)TimesheetDAO.qdo.workFlag.eq((Object)"NO"))).where((Predicate)TimesheetDAO.qdo.tsTaskIden.eq((Object)"VACATION"))).where((Predicate)TimesheetDAO.qdo.tsActIden.eq((Object)"LEGALHOLIDAY"))).where((Predicate)TimesheetDAO.qdo.autoSaveFlag.eq((Object)1))).where((Predicate)TimesheetDAO.qdo.tsStatus.eq((Object)TimesheetStatus.APPROVING.getCode()))).where((Predicate)TimesheetDAO.qdo.workDate.between((Comparable)firstDayOfMonth, (Comparable)lastDayOfMonth))).fetch();
        return res;
    }

    public Long updateStateByTask(List<Long> ids) {
        long res = this.jpaQueryFactory.update((EntityPath)qdo).set((Path)TimesheetDAO.qdo.tsStatus, (Object)TimesheetStatus.APPROVED.getCode()).set((Path)TimesheetDAO.qdo.apprResult, (Object)"\u5ba1\u6279\u901a\u8fc7").set(TimesheetDAO.qdo.approvalTime, (Object)LocalDateTime.now()).where(new Predicate[]{TimesheetDAO.qdo.id.in(ids)}).execute();
        return res;
    }

    public Long deleteByVacationApplyId(List<Long> applyDetailIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)qdo).set(TimesheetDAO.qdo.deleteFlag, (Object)1).where(new Predicate[]{TimesheetDAO.qdo.vacationApplyDetailId.in(applyDetailIds)});
        SqlUtil.updateCommonJpaQuery(update, TimesheetDAO.qdo._super);
        return update.execute();
    }

    public Long updateStatusByVacationApplyId(List<Long> applyDetailIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)qdo).set((Path)TimesheetDAO.qdo.tsStatus, (Object)"APPROVED").where(new Predicate[]{TimesheetDAO.qdo.vacationApplyDetailId.in(applyDetailIds)});
        SqlUtil.updateCommonJpaQuery(update, TimesheetDAO.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> ids) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)qdo).set(TimesheetDAO.qdo.deleteFlag, (Object)1).where(new Predicate[]{TimesheetDAO.qdo.id.in(ids)});
        SqlUtil.updateCommonJpaQuery(update, TimesheetDAO.qdo._super);
        return update.execute();
    }

    public TimesheetDAO(JPAQueryFactory jpaQueryFactory, CacheUtil cacheUtil, TimesheetRepo timesheetRepo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.cacheUtil = cacheUtil;
        this.timesheetRepo = timesheetRepo;
    }
}

