/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationPayload;
import com.elitesland.tw.tw5.api.prd.my.query.UserVacationQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QUserVacationDO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationDO;
import com.elitesland.tw.tw5.server.prd.my.repo.UserVacationRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class UserVacationDAO {
    private final UserVacationRepo userVacationRepo;
    private static final QUserVacationDO userVacationDO = QUserVacationDO.userVacationDO;
    private static final QPrdOrgEmployeeDO employeeDO = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final JPAQueryFactory jpaQueryFactory;

    public void save(UserVacationDO userVacationDO) {
        this.userVacationRepo.save((Object)userVacationDO);
    }

    private JPAQuery<UserVacationVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(UserVacationVO.class, (Expression[])new Expression[]{UserVacationDAO.userVacationDO.id, UserVacationDAO.userVacationDO.userId, UserVacationDAO.userVacationDO.vacationType, UserVacationDAO.userVacationDO.vacationYear, UserVacationDAO.userVacationDO.usedDays, UserVacationDAO.userVacationDO.startDate, UserVacationDAO.userVacationDO.endDate, UserVacationDAO.userVacationDO.expirationDate, UserVacationDAO.userVacationDO.totalDays, UserVacationDAO.userVacationDO.totalDays.subtract(UserVacationDAO.userVacationDO.usedDays).as("availableDays"), UserVacationDAO.userVacationDO.remark, UserVacationDAO.employeeDO.employeeName, UserVacationDAO.employeeDO.employeeNo, UserVacationDAO.employeeDO.extString5, this.qdoRef.orgId})).from((EntityPath)userVacationDO)).leftJoin((EntityPath)employeeDO)).on((Predicate)UserVacationDAO.employeeDO.userId.eq(UserVacationDAO.userVacationDO.userId))).leftJoin((EntityPath)this.qdoRef)).on((Predicate)UserVacationDAO.userVacationDO.userId.longValue().eq((Expression)this.qdoRef.userId.longValue()).and((Predicate)this.qdoRef.isDefault.eq((Object)0)).and((Predicate)this.qdoRef.isCopy.eq((Object)0)).and((Predicate)this.qdoRef.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.longValue().eq((Expression)this.qdoRef.orgId.longValue()).and((Predicate)this.qdoOrg.isCopy.eq((Object)0)));
        return jpaQuery;
    }

    private JPAQuery<UserVacationVO> getJpaQueryWhere(UserVacationQuery query) {
        JPAQuery<UserVacationVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getIds())) {
            jpaQuery.where((Predicate)UserVacationDAO.userVacationDO.id.in((Collection)query.getIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVacationYear())) {
            jpaQuery.where((Predicate)UserVacationDAO.userVacationDO.vacationYear.eq((Object)query.getVacationYear()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVacationType())) {
            jpaQuery.where((Predicate)UserVacationDAO.userVacationDO.vacationType.eq((Object)query.getVacationType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgId())) {
            jpaQuery.where((Predicate)this.qdoRef.orgId.eq((Object)query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getUserId())) {
            jpaQuery.where((Predicate)UserVacationDAO.userVacationDO.userId.eq((Object)query.getUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString5())) {
            jpaQuery.where((Predicate)UserVacationDAO.employeeDO.extString5.eq((Object)query.getExtString5()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExpirationStartDate())) {
            jpaQuery.where((Predicate)UserVacationDAO.userVacationDO.expirationDate.loe((Comparable)query.getExpirationStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExpirationEndDate())) {
            jpaQuery.where((Predicate)UserVacationDAO.userVacationDO.expirationDate.goe((Comparable)query.getExpirationEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonType())) {
            jpaQuery.where((Predicate)UserVacationDAO.userVacationDO.reasonType.eq((Object)query.getReasonType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonId())) {
            jpaQuery.where((Predicate)UserVacationDAO.userVacationDO.reasonId.eq((Object)query.getReasonId()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, UserVacationDAO.userVacationDO._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(userVacationDO, query.getOrders()));
        return jpaQuery;
    }

    public PagingVO<UserVacationVO> queryPaging(UserVacationQuery query) {
        JPAQuery<UserVacationVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public List<UserVacationVO> list(UserVacationQuery query) {
        JPAQuery<UserVacationVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public UserVacationDO queryById(Long id) {
        return this.userVacationRepo.findById(id).orElseGet(UserVacationDO::new);
    }

    public void deleteByIds(List<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)userVacationDO).set(UserVacationDAO.userVacationDO.deleteFlag, (Object)1).where(new Predicate[]{UserVacationDAO.userVacationDO.id.in(ids)}).execute();
    }

    public void updateExpirationDate(UserVacationPayload payload) {
        this.jpaQueryFactory.update((EntityPath)userVacationDO).set(UserVacationDAO.userVacationDO.expirationDate, (Object)payload.getExpirationDate()).where(new Predicate[]{UserVacationDAO.userVacationDO.id.in((Object[])new Long[]{payload.getId()})}).execute();
    }

    public List<UserVacationVO> getAvailableVacation(Long userId) {
        JPAQuery<UserVacationVO> jpaQuery = this.getJpaQuerySelect();
        return ((JPAQuery)jpaQuery.where((Predicate)UserVacationDAO.userVacationDO.userId.eq((Object)userId))).fetch();
    }

    @Transactional
    public void updateUsedDays(Long vacationId, BigDecimal days) {
        this.jpaQueryFactory.update((EntityPath)userVacationDO).set(UserVacationDAO.userVacationDO.usedDays, (Expression)UserVacationDAO.userVacationDO.usedDays.add((Number)days)).where(new Predicate[]{UserVacationDAO.userVacationDO.id.eq((Object)vacationId)}).execute();
    }

    public void deleteAllByUserId(Long userId) {
        this.jpaQueryFactory.update((EntityPath)userVacationDO).set(UserVacationDAO.userVacationDO.deleteFlag, (Object)1).where(new Predicate[]{UserVacationDAO.userVacationDO.userId.eq((Object)userId)}).execute();
    }

    public UserVacationDAO(UserVacationRepo userVacationRepo, JPAQueryFactory jpaQueryFactory) {
        this.userVacationRepo = userVacationRepo;
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

