/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceRemarkPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceRemarkQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceRemarkService;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceRemarkVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceRemarkConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceRemarkDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceRemarkDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceRemarkRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.xxl.job.core.log.XxlJobLogger;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class TAttendanceRemarkServiceImpl
extends BaseServiceImpl
implements TAttendanceRemarkService {
    private static final Logger log = LoggerFactory.getLogger(TAttendanceRemarkServiceImpl.class);
    private final TAttendanceRemarkRepo tAttendanceRemarkRepo;
    private final TAttendanceRemarkDAO tAttendanceRemarkDAO;
    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService orgService;
    @Value(value="${tw4.attendance.remark}")
    private String attendanceRemarkTo5Url;

    public PagingVO<TAttendanceRemarkVO> queryPaging(TAttendanceRemarkQuery query) {
        return this.tAttendanceRemarkDAO.queryPaging(query);
    }

    public List<TAttendanceRemarkVO> queryListDynamic(TAttendanceRemarkQuery query) {
        return this.tAttendanceRemarkDAO.queryListDynamic(query);
    }

    public TAttendanceRemarkVO queryByKey(Long key) {
        TAttendanceRemarkDO entity = this.tAttendanceRemarkRepo.findById(key).orElseGet(TAttendanceRemarkDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TAttendanceRemarkVO vo = TAttendanceRemarkConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TAttendanceRemarkVO insert(TAttendanceRemarkPayload payload) {
        TAttendanceRemarkDO entityDo = TAttendanceRemarkConvert.INSTANCE.toDo(payload);
        return TAttendanceRemarkConvert.INSTANCE.toVo((TAttendanceRemarkDO)((Object)this.tAttendanceRemarkRepo.save((Object)entityDo)));
    }

    @Transactional(rollbackFor={Exception.class})
    public TAttendanceRemarkVO update(TAttendanceRemarkPayload payload) {
        TAttendanceRemarkDO entity = this.tAttendanceRemarkRepo.findById(payload.getId()).orElseGet(TAttendanceRemarkDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TAttendanceRemarkDO entityDo = TAttendanceRemarkConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TAttendanceRemarkConvert.INSTANCE.toVo((TAttendanceRemarkDO)((Object)this.tAttendanceRemarkRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TAttendanceRemarkPayload payload) {
        TAttendanceRemarkDO entity = this.tAttendanceRemarkRepo.findById(payload.getId()).orElseGet(TAttendanceRemarkDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tAttendanceRemarkDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tAttendanceRemarkDAO.deleteSoft(keys);
        }
    }

    public Long queryByAttendanceNormalId(Long attendanceNormalId) {
        return this.tAttendanceRemarkDAO.queryByAttendanceNormalId(attendanceNormalId);
    }

    public void attendanceRemarkTo5(String param) {
        String syncType = "attendanceRemarkTo5";
        LocalDateTime localDateTime = this.daoLog.queryOrgSyncLog(syncType);
        localDateTime = localDateTime == null ? LocalDateTime.of(1970, 1, 1, 0, 0) : localDateTime.minusSeconds(10L);
        XxlJobLogger.log((String)("syncVacationApply localDateTime\uff1a" + localDateTime), (Object[])new Object[0]);
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        reqMap.put("asyncTime", asyncTimeLong);
        XxlJobLogger.log((String)("syncVacationApplyDetail syncTime\uff1a" + asyncTimeLong), (Object[])new Object[0]);
        String result = this.httpUtil.sendSyncGet(this.attendanceRemarkTo5Url, reqMap);
        Map data = (Map)JSONObject.parse((String)result);
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        Object syncData = "";
        if ("true".equals("" + data.get("ok"))) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map v4AndV5UserIds = this.employeeService.getV4AndV5UserIds();
                Object datum = data.get("datum");
                List attendanceRemarkData = (List)datum;
                ArrayList<TAttendanceRemarkDO> tAttendanceRemarkDOList = new ArrayList<TAttendanceRemarkDO>();
                List<Long> tw4AttendanceRemarkIds = attendanceRemarkData.stream().map(attendanceRemark -> (attendanceRemark.get("id") == null ? Integer.valueOf(0) : attendanceRemark.get("id")).longValue()).collect(Collectors.toList());
                List<TAttendanceRemarkDO> oldTAttendanceRemarkDOs = this.tAttendanceRemarkRepo.selectByIdV4List(tw4AttendanceRemarkIds);
                block0: for (TAttendanceRemarkDO attendanceRemarkDO : oldTAttendanceRemarkDOs) {
                    Long attendanceRemarkIdV4 = attendanceRemarkDO.getAttendanceRemarkIdV4();
                    for (Map applyData2 : attendanceRemarkData) {
                        Long attendanceRemarkIdV4FromV4 = (null == applyData2.get("id") ? Integer.valueOf(0) : applyData2.get("id")).longValue();
                        if (!attendanceRemarkIdV4.equals(attendanceRemarkIdV4FromV4)) continue;
                        TAttendanceRemarkDO attendanceRemarkDO1 = this.translateFromV4(applyData2, v4AndV5UserIds);
                        attendanceRemarkDO1.setId(attendanceRemarkDO.getId());
                        tAttendanceRemarkDOList.add(attendanceRemarkDO1);
                        continue block0;
                    }
                }
                this.tAttendanceRemarkRepo.saveAll(tAttendanceRemarkDOList);
                List newDatas = attendanceRemarkData.stream().filter(applyData -> {
                    boolean flag = true;
                    Long applyId = (applyData.get("id") == null ? Integer.valueOf(0) : applyData.get("id")).longValue();
                    for (TAttendanceRemarkDO attendanceRemarkDO : oldTAttendanceRemarkDOs) {
                        if (!attendanceRemarkDO.getAttendanceRemarkIdV4().equals(applyId)) continue;
                        flag = false;
                    }
                    return flag;
                }).collect(Collectors.toList());
                ArrayList<TAttendanceRemarkDO> newTAttendanceRemarkDOs = new ArrayList<TAttendanceRemarkDO>();
                for (Map newData : newDatas) {
                    TAttendanceRemarkDO attendanceRemarkDO1 = this.translateFromV4(newData, v4AndV5UserIds);
                    newTAttendanceRemarkDOs.add(attendanceRemarkDO1);
                }
                this.tAttendanceRemarkRepo.saveAll(newTAttendanceRemarkDOs);
                syncData = "\u66f4\u65b0\u4e86\u6b63\u5e38\u6253\u5361" + attendanceRemarkData.size() + "\u6761\u6570\u636e";
            } else {
                syncData = "\u6b63\u5e38\u6253\u5361\u6570\u636e\u672a\u53d8\u5316";
            }
        } else {
            syncData = "" + data.get("reason");
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData((String)syncData);
        this.daoLog.save(logDO);
        log.info("\u3010\u6b63\u5e38\u6253\u5361\u4fe1\u606f\u540c\u6b65\uff0c\u540c\u6b65\u65e5\u5fd7\uff1a{}\u3011", (Object)logDO);
    }

    private TAttendanceRemarkDO translateFromV4(Map attendanceRemarkData, Map<Long, Long> v4AndV5UserIds) {
        TAttendanceRemarkDO attendanceRemarkDO = BeanUtil.mapToBean(TAttendanceRemarkDO.class, attendanceRemarkData, Arrays.asList("id", "createTime", "createUserId"));
        if (null != attendanceRemarkData.get("id")) {
            attendanceRemarkDO.setAttendanceRemarkIdV4(((Integer)attendanceRemarkData.get("id")).longValue());
        }
        if (null != attendanceRemarkData.get("attendanceResId")) {
            Long attendanceResId = ((Integer)attendanceRemarkData.get("attendanceResId")).longValue();
            attendanceRemarkDO.setAttendanceResId(v4AndV5UserIds.get(attendanceResId));
        }
        return attendanceRemarkDO;
    }

    public TAttendanceRemarkServiceImpl(TAttendanceRemarkRepo tAttendanceRemarkRepo, TAttendanceRemarkDAO tAttendanceRemarkDAO, PrdOrgSyncLogDAO daoLog, HttpUtil httpUtil, PrdOrgEmployeeService employeeService, PrdOrgOrganizationService orgService) {
        this.tAttendanceRemarkRepo = tAttendanceRemarkRepo;
        this.tAttendanceRemarkDAO = tAttendanceRemarkDAO;
        this.daoLog = daoLog;
        this.httpUtil = httpUtil;
        this.employeeService = employeeService;
        this.orgService = orgService;
    }
}

