/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.identity.service;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookAccountQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessSupplierInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessSupplierInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessSupplierInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.identity.convert.BusinessSupplierInfoConvert;
import com.elitesland.tw.tw5.server.prd.partner.identity.dao.BusinessSupplierInfoDAO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessSupplierInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessSupplierInfoRepo;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusinessSupplierInfoServiceImpl
extends BaseServiceImpl
implements BusinessSupplierInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusinessSupplierInfoServiceImpl.class);
    private final BusinessSupplierInfoRepo businessSupplierInfoRepo;
    private final BusinessSupplierInfoDAO businessSupplierInfoDAO;
    private final FileUtil fileUtil;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;
    private final BookAccountService bookAccountService;
    @Autowired
    @Lazy
    private BusinessPartnerService businessPartnerService;

    public PagingVO<BusinessSupplierInfoVO> queryPaging(BusinessSupplierInfoQuery query) {
        return this.businessSupplierInfoDAO.queryPaging(query);
    }

    public List<BusinessSupplierInfoVO> queryListDynamic(BusinessSupplierInfoQuery query) {
        List<BusinessSupplierInfoVO> businessSupplierInfoVOS = this.businessSupplierInfoDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(businessSupplierInfoVOS)) {
            businessSupplierInfoVOS.stream().forEach(vo -> {
                vo.setFileData1(this.fileUtil.getFileDatas(vo.getFileCode1()));
                vo.setFileData2(this.fileUtil.getFileDatas(vo.getFileCode2()));
            });
        }
        return businessSupplierInfoVOS;
    }

    public BusinessSupplierInfoVO queryByKey(Long key) {
        BusinessSupplierInfoDO entity = this.businessSupplierInfoRepo.findById(key).orElseGet(BusinessSupplierInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessSupplierInfoVO vo = BusinessSupplierInfoConvert.INSTANCE.toVo(entity);
        vo.setFileData1(this.fileUtil.getFileDatas(vo.getFileCode1()));
        vo.setFileData2(this.fileUtil.getFileDatas(vo.getFileCode2()));
        return vo;
    }

    public BusinessSupplierInfoVO queryByPartnerId(Long partnerId) {
        BusinessSupplierInfoDO entity = this.businessSupplierInfoRepo.findByPartnerId(partnerId);
        if (entity == null) {
            throw TwException.error("", "\u4f9b\u5e94\u5546\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        BusinessSupplierInfoVO vo = BusinessSupplierInfoConvert.INSTANCE.toVo(entity);
        vo.setFileData1(this.fileUtil.getFileDatas(vo.getFileCode1()));
        vo.setFileData2(this.fileUtil.getFileDatas(vo.getFileCode2()));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessSupplierInfoVO insert(BusinessSupplierInfoPayload payload) {
        payload.setSyncJdeFlag(Boolean.valueOf(false));
        BusinessSupplierInfoDO entityDo = BusinessSupplierInfoConvert.INSTANCE.toDo(payload);
        return BusinessSupplierInfoConvert.INSTANCE.toVo((BusinessSupplierInfoDO)this.businessSupplierInfoRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessSupplierInfoVO update(BusinessSupplierInfoPayload payload) {
        BusinessSupplierInfoDO entity = this.businessSupplierInfoRepo.findById(payload.getId()).orElseGet(BusinessSupplierInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessSupplierInfoDO entityLog = new BusinessSupplierInfoDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BusinessSupplierInfoDO entityDo = BusinessSupplierInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (null != payload.getPartnerId()) {
            StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
            fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
            if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
                this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
            }
        }
        return BusinessSupplierInfoConvert.INSTANCE.toVo((BusinessSupplierInfoDO)this.businessSupplierInfoRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.businessSupplierInfoDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateSupplierStatus(Long partnerId, String partnerName, String supplierStatus) {
        this.businessSupplierInfoDAO.updateSupplierStatus(partnerId, supplierStatus);
    }

    public Boolean activeSupplierCheck(Long bookId) {
        Assert.notNull((Object)bookId, (String)"bookId\u4e0d\u80fd\u4e3a\u7a7a");
        BookAccountQuery bookAccountQuery = new BookAccountQuery();
        bookAccountQuery.setBookId(bookId);
        Long count = this.bookAccountService.count(bookAccountQuery);
        if (count > 0L) {
            return true;
        }
        return false;
    }

    public Boolean activeSupplierCheckWithChange(Long bookId) {
        Assert.notNull((Object)bookId, (String)"bookId\u4e0d\u80fd\u4e3a\u7a7a");
        BookAccountQuery bookAccountQuery = new BookAccountQuery();
        bookAccountQuery.setBookId(bookId);
        Long count = this.bookAccountService.count(bookAccountQuery);
        if (count > 0L) {
            return true;
        }
        List businessPartnerVOS = this.businessPartnerService.queryByBookId(bookId);
        if (CollectionUtils.isEmpty((Collection)businessPartnerVOS)) {
            return false;
        }
        BusinessPartnerVO businessPartnerVO = (BusinessPartnerVO)businessPartnerVOS.get(0);
        if (StrUtil.isNotBlank((CharSequence)businessPartnerVO.getApplyStatus()) && businessPartnerVO.getApplyStatus().equals(BusinessPartnerStatusEnum.APPROVING.getCode())) {
            return true;
        }
        return false;
    }

    public BusinessSupplierInfoVO quertByBookId(Long supplierBookId) {
        BusinessSupplierInfoVO res = this.businessSupplierInfoDAO.quertByBookId(supplierBookId);
        return res;
    }

    public BusinessSupplierInfoServiceImpl(BusinessSupplierInfoRepo businessSupplierInfoRepo, BusinessSupplierInfoDAO businessSupplierInfoDAO, FileUtil fileUtil, ChangeFieldLogUtil changeFieldLogUtil, PrdSystemLogService logService, BookAccountService bookAccountService) {
        this.businessSupplierInfoRepo = businessSupplierInfoRepo;
        this.businessSupplierInfoDAO = businessSupplierInfoDAO;
        this.fileUtil = fileUtil;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.logService = logService;
        this.bookAccountService = bookAccountService;
    }
}

