/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.BuProjectMembersPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.BuProjectMembersQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectMembersService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectMembersVO;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.BuProjectMembersConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.BuProjectMembersDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.BuProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.BuProjectMembersRepo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class BuProjectMembersServiceImpl
extends BaseServiceImpl
implements BuProjectMembersService {
    private static final Logger log = LoggerFactory.getLogger(BuProjectMembersServiceImpl.class);
    private final BuProjectMembersRepo buProjectMembersRepo;
    private final BuProjectMembersDAO buProjectMembersDAO;
    private final TaskCommonService taskCommonService;

    public PagingVO<BuProjectMembersVO> queryPaging(BuProjectMembersQuery query) {
        return this.buProjectMembersDAO.queryPaging(query);
    }

    public List<BuProjectMembersVO> queryListDynamic(BuProjectMembersQuery query) {
        List<BuProjectMembersVO> membersVOS = this.buProjectMembersDAO.queryListDynamic(query);
        if (membersVOS.size() > 0) {
            List resIds = membersVOS.stream().map(BuProjectMembersVO::getResId).distinct().collect(Collectors.toList());
            TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
            taskPackageQuery.setReasonType(PmsReasonTypeEnum.PROJ_BU.getCode());
            taskPackageQuery.setReasonId(query.getProjId());
            taskPackageQuery.setReceiverResIds(resIds);
            List taskPackageVOS = this.taskCommonService.queryTaskPackageList(taskPackageQuery);
            Map<Long, List<TaskPackageVO>> mapList = taskPackageVOS.stream().collect(Collectors.groupingBy(TaskPackageVO::getReceiverResId));
            membersVOS.forEach(membersVO -> {
                membersVO.setTaskPackageCount(Integer.valueOf(0));
                List taskPackageVOS1 = (List)mapList.get(membersVO.getResId());
                if (!ObjectUtils.isEmpty((Object)taskPackageVOS1)) {
                    membersVO.setTaskPackageCount(Integer.valueOf(taskPackageVOS1.size()));
                }
            });
        }
        return membersVOS;
    }

    public BuProjectMembersVO queryByKey(Long key) {
        BuProjectMembersDO entity = this.buProjectMembersRepo.findById(key).orElseGet(BuProjectMembersDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BuProjectMembersVO vo = BuProjectMembersConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BuProjectMembersVO insert(BuProjectMembersPayload payload) {
        BuProjectMembersDO entityDo = BuProjectMembersConvert.INSTANCE.toDo(payload);
        return BuProjectMembersConvert.INSTANCE.toVo((BuProjectMembersDO)this.buProjectMembersRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BuProjectMembersVO update(BuProjectMembersPayload payload) {
        BuProjectMembersDO entity = this.buProjectMembersRepo.findById(payload.getId()).orElseGet(BuProjectMembersDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BuProjectMembersDO entityDo = BuProjectMembersConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BuProjectMembersConvert.INSTANCE.toVo((BuProjectMembersDO)this.buProjectMembersRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BuProjectMembersPayload payload) {
        BuProjectMembersDO entity = this.buProjectMembersRepo.findById(payload.getId()).orElseGet(BuProjectMembersDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.buProjectMembersDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<BuProjectMembersVO> pmsProjectMembersVOS = this.buProjectMembersDAO.queryByKeys(keys);
            if (pmsProjectMembersVOS.size() > 0) {
                List collect = pmsProjectMembersVOS.stream().map(BuProjectMembersVO::getProjId).distinct().collect(Collectors.toList());
                if (collect.size() > 1) {
                    throw TwException.error("", "\u4e0d\u53ef\u540c\u65f6\u5220\u9664\u591a\u9879\u76ee\u4e0b\u7684\u6210\u5458");
                }
                List resIds = pmsProjectMembersVOS.stream().map(BuProjectMembersVO::getResId).distinct().collect(Collectors.toList());
                TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
                taskPackageQuery.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
                taskPackageQuery.setReasonId((Long)collect.get(0));
                taskPackageQuery.setReceiverResIds(resIds);
                long l = this.taskCommonService.taskPackageCount(taskPackageQuery);
                if (l > 0L) {
                    throw TwException.error("", "\u5df2\u751f\u6210\u4efb\u52a1\u5305\uff0c\u4e0d\u53ef\u5220\u9664\u6210\u5458");
                }
                this.buProjectMembersDAO.deleteSoft(keys);
            }
            this.buProjectMembersDAO.deleteSoft(keys);
        }
    }

    public BuProjectMembersServiceImpl(BuProjectMembersRepo buProjectMembersRepo, BuProjectMembersDAO buProjectMembersDAO, TaskCommonService taskCommonService) {
        this.buProjectMembersRepo = buProjectMembersRepo;
        this.buProjectMembersDAO = buProjectMembersDAO;
        this.taskCommonService = taskCommonService;
    }
}

