/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmBusitripApplyQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmBusitripApplyService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsInspectionItemPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectConclusionPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectConclusionQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsInspectionItemConfigService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectConclusionService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsInspectionItemConfigVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectConclusionVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentService;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.BusitripApplyStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConWorkTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.InspectionItemCheckMethod;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProjectConclusionNodeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectCloseReasonEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectConclusionConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectConclusionDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectConclusionDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectConclusionRepo;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ActionType;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsProjectConclusionServiceImpl
extends BaseServiceImpl
implements PmsProjectConclusionService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectConclusionServiceImpl.class);
    private final PmsProjectConclusionRepo pmsProjectConclusionRepo;
    private final PmsProjectConclusionDAO pmsProjectConclusionDAO;
    private final PmsProjectService pmsProjectService;
    private final PmsInspectionItemConfigService pmsInspectionItemConfigService;
    private final WorkflowUtil workflowUtil;
    private final PrdSystemRoleService roleService;
    private final CacheUtil cacheUtil;
    private final CalAccountService calAccountService;
    private final FileUtil fileUtil;
    private final TaskCommonService taskCommonService;
    private final AdmBusitripApplyService admBusitripApplyService;
    private final AccReimService accReimService;
    private final ConReceivablePlanService conReceivablePlanService;
    private final PurchasePaymentService purchasePaymentService;
    private final PmsTimesheetService pmsTimesheetService;
    private final TransactionUtilService transactionUtilService;
    private final PmsProjectDAO pmsProjectDAO;

    public PmsProjectConclusionVO queryByProjectId(Long projectId) {
        if (ObjectUtils.isEmpty((Object)projectId)) {
            throw TwException.error("", "\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PmsProjectConclusionVO projectConclusionVO = this.pmsProjectConclusionDAO.queryByProjId(projectId);
        if (!ObjectUtils.isEmpty((Object)projectConclusionVO)) {
            throw TwException.error("", "\u9879\u76ee\u5df2\u7ed3\u9879\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u53d1\u8d77");
        }
        PmsProjectVO projectVO = this.pmsProjectService.querySimpleProjectByKey(projectId);
        this.checkPermission(projectVO);
        projectConclusionVO = new PmsProjectConclusionVO();
        projectConclusionVO.setApplyUserId(GlobalUtil.getLoginUserId());
        projectConclusionVO.setApplyDate(LocalDate.now());
        projectConclusionVO.setAbnormalFlag(Integer.valueOf(0));
        List<String> approvalNodes = this.getApprovalNode(null, null);
        this.getProjectData(projectConclusionVO, projectVO);
        List<PmsInspectionItemConfigVO> inspectionItemConfigList = this.getListByWorkTypeAndApprovalNode(projectConclusionVO, projectVO.getWorkType(), approvalNodes);
        projectConclusionVO.setInspectionItemConfigList(inspectionItemConfigList);
        return projectConclusionVO;
    }

    void checkPermission(PmsProjectVO projectVO) {
        if (!ProjectStatusEnum.ACTIVE.getCode().equals(projectVO.getProjStatus()) && !ProjectStatusEnum.CLOSING.getCode().equals(projectVO.getProjStatus())) {
            throw TwException.error("", "\u4ec5\u6fc0\u6d3b\u72b6\u6001\u7684\u9879\u76ee \u53ef\u4ee5\u53d1\u8d77\u7ed3\u9879");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void insertOrUpdate(PmsProjectConclusionPayload payload) {
        Long projId = payload.getProjId();
        if (ObjectUtils.isEmpty((Object)projId)) {
            throw TwException.error("", "\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String approvalNodeInfo = payload.getApprovalNodeInfo();
        if (ObjectUtils.isEmpty((Object)approvalNodeInfo)) {
            throw TwException.error("", "\u8282\u70b9\u64cd\u4f5c\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PmsProjectConclusionVO projectConclusionVO = this.pmsProjectConclusionDAO.queryByProjId(projId);
        this.getApprovalNode(projectConclusionVO, payload.getApprovalNode());
        Integer abnormalFlag = payload.getAbnormalFlag();
        if (ObjectUtils.isEmpty((Object)abnormalFlag)) {
            throw TwException.error("", "\u5f02\u5e38\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List itemConfigPayloadList = payload.getInspectionItemConfigPayloadList();
        if (!ObjectUtils.isEmpty((Object)itemConfigPayloadList)) {
            Optional<PmsInspectionItemPayload> inspectionItemConfigPayloadOptional;
            for (PmsInspectionItemPayload itemConfigPayload : itemConfigPayloadList) {
                String checkItem = itemConfigPayload.getCheckItem();
                if (!itemConfigPayloadList.stream().anyMatch(v -> v.getCheckItem().equals(checkItem) && !v.getCompleteStatus().equals(itemConfigPayload.getCompleteStatus()))) continue;
                throw TwException.error("", "\u9879\u76ee\u7ed3\u9879\u4e2d\uff0c\u6709\u68c0\u67e5\u9879\u4e00\u6837\uff0c\u4f46\u662f\u5b8c\u6210\u72b6\u6001\u4e0d\u4e00\u6837\u7684\u6570\u636e");
            }
            if (payload.getSubmitFlag().booleanValue() && (inspectionItemConfigPayloadOptional = itemConfigPayloadList.stream().filter(v -> ObjectUtils.isEmpty((Object)v.getCompleteStatus()) || v.getCompleteStatus() == false).findFirst()).isPresent()) {
                throw TwException.error("", "\u9879\u76ee\u7ed3\u9879\u4e2d\uff0c\u6709\u672a\u5b8c\u6210\u7684\u68c0\u67e5\u9879");
            }
        }
        Long deliUserId = null;
        String workType = null;
        Long pmResId = null;
        String projName = null;
        if (ObjectUtils.isEmpty((Object)projectConclusionVO) && payload.getSubmitFlag().booleanValue() || !ObjectUtils.isEmpty((Object)projectConclusionVO) && WorkFlowStatusEnum.NOTSUBMIT.getCode().equals(projectConclusionVO.getConclusionStatus())) {
            PmsProjectVO projectVO = this.pmsProjectService.querySimpleProjectByKey(projId);
            this.checkPermission(projectVO);
            deliUserId = projectVO.getDeliUserId();
            pmResId = projectVO.getPmResId();
            workType = projectVO.getWorkType();
            projName = projectVO.getProjName();
        }
        String procInstId = null;
        PmsProjectConclusionDO entityDo = null;
        try {
            this.transactionUtilService.begin();
            if (ObjectUtils.isEmpty((Object)projectConclusionVO)) {
                payload.setConclusionCode(this.generateSeqNum("PROJECT_CONCLUSION", new String[0]));
                payload.setConclusionStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                if (!ObjectUtils.isEmpty((Object)itemConfigPayloadList)) {
                    payload.setConclusionCheckItems(JSON.toJSONString((Object)itemConfigPayloadList));
                }
                this.pmsProjectService.updateProjectCloseStatus(Arrays.asList(projId), ProjectStatusEnum.CLOSING.getCode());
            } else {
                List fromDbList;
                String conclusionCheckItem;
                procInstId = projectConclusionVO.getProcInstId();
                if (!(ObjectUtils.isEmpty((Object)itemConfigPayloadList) || ObjectUtils.isEmpty((Object)(conclusionCheckItem = projectConclusionVO.getConclusionCheckItems())) || ObjectUtils.isEmpty((Object)(fromDbList = JSON.parseArray((String)conclusionCheckItem, PmsInspectionItemPayload.class))))) {
                    List checkItems = itemConfigPayloadList.stream().map(PmsInspectionItemPayload::getCheckItem).collect(Collectors.toList());
                    List newDbList = fromDbList.stream().filter(db -> !checkItems.contains(db.getCheckItem())).collect(Collectors.toList());
                    newDbList.addAll(itemConfigPayloadList);
                    payload.setConclusionCheckItems(JSON.toJSONString(newDbList));
                }
            }
            if (payload.getSubmitFlag().booleanValue()) {
                payload.setConclusionStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
            }
            entityDo = PmsProjectConclusionConvert.INSTANCE.toDo(payload);
            entityDo = (PmsProjectConclusionDO)this.pmsProjectConclusionRepo.save(entityDo);
            this.transactionUtilService.commit();
        }
        catch (Exception e) {
            this.transactionUtilService.rollback();
            throw e;
        }
        if (payload.getSubmitFlag().booleanValue() && ObjectUtils.isEmpty((Object)procInstId)) {
            this.startProcess(entityDo, deliUserId, workType, pmResId, projName);
        }
    }

    public PagingVO<PmsProjectConclusionVO> queryPagingJoinProject(PmsProjectConclusionQuery query) {
        this.operPermissionFlag(query);
        return this.pmsProjectConclusionDAO.queryPagingJoinProject(query);
    }

    void operPermissionFlag(PmsProjectConclusionQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setLoginUserId(loginUserId);
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.PLAT_FIN_PIC.getCode(), RoleEnum.PLAT_PMO.getCode(), RoleEnum.PLAT_PMO_AID.getCode(), RoleEnum.PROJECT_CONCLUSION.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
    }

    public List<PmsProjectConclusionVO> queryListDynamic(PmsProjectConclusionQuery query) {
        return this.pmsProjectConclusionDAO.queryListDynamic(query);
    }

    public PmsProjectConclusionVO queryByKey(Long key, String approvalNode) {
        if (ObjectUtils.isEmpty((Object)key)) {
            throw TwException.error("", "\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PmsProjectConclusionVO projectConclusionVO = this.pmsProjectConclusionDAO.queryByKeyJoinProject(key);
        this.transfer(projectConclusionVO);
        List<String> approvalNodes = this.getApprovalNode(projectConclusionVO, approvalNode);
        if (this.isFinanceClose(approvalNodes)) {
            CalAccountVO projAccountVO = this.calAccountService.queryByAuTypeAndAuId(CalAccTypeEnum.PROJ.getCode(), projectConclusionVO.getProjId());
            projectConclusionVO.setProjAccountNo(projAccountVO.getLedgerNo());
            projectConclusionVO.setProjAccountAvalQty(projAccountVO.getAvalQty());
            CalAccountVO buAccountVO = this.calAccountService.queryByAuTypeAndAuId(CalAccTypeEnum.BU.getCode(), projectConclusionVO.getDeliBuId());
            projectConclusionVO.setBuAccountNo(buAccountVO.getLedgerNo());
            projectConclusionVO.setBuAccountName(buAccountVO.getLedgerName());
        }
        List<PmsInspectionItemConfigVO> inspectionItemConfigList = this.getListByWorkTypeAndApprovalNode(projectConclusionVO, projectConclusionVO.getWorkType(), approvalNodes);
        projectConclusionVO.setInspectionItemConfigList(inspectionItemConfigList);
        return projectConclusionVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PmsProjectConclusionVO> list = this.pmsProjectConclusionDAO.queryByKeys(keys);
            for (PmsProjectConclusionVO v : list) {
                if (WorkFlowStatusEnum.NOTSUBMIT.getCode().equals(v.getConclusionStatus()) || WorkFlowStatusEnum.REJECTED_WORK.getCode().equals(v.getConclusionStatus())) continue;
                throw TwException.error("", "\u53ea\u6709\u7ed3\u9879\u7533\u8bf7\u5355\u5904\u4e8e\u201c\u672a\u63d0\u4ea4\u201d\u3001\u201c\u64a4\u56de\u201d\u3001\u201c\u5df2\u62d2\u7edd\u201d\u72b6\u6001\u7684\u5355\u636e\u652f\u6301\u5220\u9664");
            }
            this.pmsProjectConclusionDAO.deleteSoft(keys);
            List projectIds = list.stream().map(PmsProjectConclusionVO::getProjId).collect(Collectors.toList());
            this.pmsProjectService.updateProjectCloseStatus(projectIds, ProjectStatusEnum.ACTIVE.getCode());
        }
    }

    public List<PmsInspectionItemConfigVO> autoCheck(Long projectId, String workType, String approvalNode) {
        String desc;
        long count1;
        if (ObjectUtils.isEmpty((Object)projectId)) {
            throw TwException.error("", "\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)workType)) {
            throw TwException.error("", "\u6d41\u7a0b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PmsProjectConclusionVO projectConclusionVO = this.pmsProjectConclusionDAO.queryByProjId(projectId);
        List<String> approvalNodes = this.getApprovalNode(projectConclusionVO, approvalNode);
        List<PmsInspectionItemConfigVO> list = this.getListByWorkTypeAndApprovalNode(projectConclusionVO, workType, approvalNodes);
        ArrayList<String> checkItems = new ArrayList<String>();
        for (PmsInspectionItemConfigVO v2 : list) {
            if (!InspectionItemCheckMethod.SYSTEM_AUTOMATIC_CHECK.getCode().equals(v2.getCheckMethod()) || !ObjectUtils.isEmpty((Object)v2.getCompleteStatus()) && v2.getCompleteStatus().booleanValue()) continue;
            checkItems.add(v2.getCheckItem());
        }
        HashMap<String, Boolean> info = new HashMap<String, Boolean>();
        String desc1 = this.cacheUtil.getSystemSelectionValueByName("PMS:PROJ_CLOSED:APPROVAL_NODE", PmsProjectConclusionNodeEnum.PM.getDesc());
        String desc2 = this.cacheUtil.getSystemSelectionValueByName("PMS:PROJ_CLOSED:APPROVAL_NODE", PmsProjectConclusionNodeEnum.DF.getDesc());
        if (approvalNodes.contains(desc1) || approvalNodes.contains(desc2)) {
            if (checkItems.contains(ProjectCloseReasonEnum.REASON4.getCode())) {
                List taskInfoVOS = this.taskCommonService.queryTaskByReason(PmsReasonTypeEnum.PROJ_CONTRACT.getCode(), projectId);
                long count = taskInfoVOS.stream().filter(v -> !v.getTaskStatus().equals(TaskStatusEnum.CLOSED.getCode())).count();
                info.put(ProjectCloseReasonEnum.REASON4.getCode(), count == 0L);
            }
            if (checkItems.contains(ProjectCloseReasonEnum.REASON6.getCode())) {
                List<String> strings = Arrays.asList(TimesheetStatus.CREATE.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.REJECTED.getCode());
                TimesheetQuery query = new TimesheetQuery();
                query.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
                query.setReasonId(projectId);
                query.setTsStatusList(strings);
                long count12 = this.pmsTimesheetService.count(query);
                info.put(ProjectCloseReasonEnum.REASON6.getCode(), count12 == 0L);
            }
            if (checkItems.contains(ProjectCloseReasonEnum.REASON7.getCode())) {
                AdmBusitripApplyQuery query = new AdmBusitripApplyQuery();
                query.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
                query.setReasonId(projectId);
                query.setApplyStatusFlag(Integer.valueOf(0));
                query.setApplyStatus(BusitripApplyStatusEnum.APPROVED.getCode());
                List admBusitripApplyVOS = this.admBusitripApplyService.queryListDynamic(query);
                info.put(ProjectCloseReasonEnum.REASON7.getCode(), ObjectUtils.isEmpty((Object)admBusitripApplyVOS));
            }
            if (checkItems.contains(ProjectCloseReasonEnum.REASON8.getCode())) {
                AccReimQuery queryReim = new AccReimQuery();
                queryReim.setReasonId(projectId);
                queryReim.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
                List<String> strings = Arrays.asList(AccReimDocStatusEnum.REJECTED.getCode(), AccReimDocStatusEnum.APPROVED.getCode());
                queryReim.setNotReimStatusList(strings);
                List accReimVOS = this.accReimService.queryListDynamic(queryReim);
                info.put(ProjectCloseReasonEnum.REASON8.getCode(), ObjectUtils.isEmpty((Object)accReimVOS));
            }
            PmsProjectVO pmsProjectVO = null;
            if (checkItems.contains(ProjectCloseReasonEnum.REASON10.getCode())) {
                pmsProjectVO = this.pmsProjectService.querySimpleProjectByKey(projectId);
                ConReceivablePlanQuery queryPlan = new ConReceivablePlanQuery();
                queryPlan.setSaleConId(pmsProjectVO.getContractId());
                List recvPlanViews = this.conReceivablePlanService.queryListDynamic(queryPlan);
                if (ObjectUtils.isEmpty((Object)recvPlanViews)) {
                    info.put(ProjectCloseReasonEnum.REASON10.getCode(), true);
                } else {
                    List<String> filterList = Arrays.asList("1", "2", "3", "5", "8", "9");
                    count1 = recvPlanViews.stream().filter(view -> StringUtils.hasText((String)view.getInvStatus()) && filterList.contains(view.getInvStatus())).count();
                    info.put(ProjectCloseReasonEnum.REASON10.getCode(), count1 == 0L);
                }
            }
            if (checkItems.contains(ProjectCloseReasonEnum.REASON11.getCode())) {
                if (pmsProjectVO == null) {
                    pmsProjectVO = this.pmsProjectService.querySimpleProjectByKey(projectId);
                }
                List<String> strings = Arrays.asList(PurchasePaymentEnum.PaymentStatus.APPROVED.getCode(), PurchasePaymentEnum.PaymentStatus.PAID.getCode(), PurchasePaymentEnum.PaymentStatus.WRITTEN_OFF.getCode());
                PurchasePaymentQuery queryPayment = new PurchasePaymentQuery();
                queryPayment.setRelatedProjectNo(pmsProjectVO.getProjNo());
                queryPayment.setNotInStateList(strings);
                List purchasePaymentVOS = this.purchasePaymentService.queryListDynamic(queryPayment);
                info.put(ProjectCloseReasonEnum.REASON11.getCode(), ObjectUtils.isEmpty((Object)purchasePaymentVOS));
            }
        }
        if (approvalNodes.contains(desc = this.cacheUtil.getSystemSelectionValueByName("PMS:PROJ_CLOSED:APPROVAL_NODE", PmsProjectConclusionNodeEnum.FIN_VER.getDesc()))) {
            if (checkItems.contains(ProjectCloseReasonEnum.REASON8.getCode())) {
                AccReimQuery queryReim = new AccReimQuery();
                queryReim.setReasonId(projectId);
                queryReim.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
                List<String> strings = Arrays.asList(AccReimDocStatusEnum.REJECTED.getCode(), AccReimDocStatusEnum.APPROVED.getCode());
                queryReim.setNotReimStatusList(strings);
                List accReimVOS = this.accReimService.queryListDynamic(queryReim);
                info.put(ProjectCloseReasonEnum.REASON8.getCode(), ObjectUtils.isEmpty((Object)accReimVOS));
            }
            if (checkItems.contains(ProjectCloseReasonEnum.REASON16.getCode())) {
                PmsProjectVO pmsProjectVO = this.pmsProjectService.querySimpleProjectByKey(projectId);
                ConReceivablePlanQuery queryPlan = new ConReceivablePlanQuery();
                queryPlan.setSaleConId(pmsProjectVO.getContractId());
                List recvPlanViews = this.conReceivablePlanService.queryListDynamic(queryPlan);
                if (ObjectUtils.isEmpty((Object)recvPlanViews)) {
                    info.put(ProjectCloseReasonEnum.REASON16.getCode(), true);
                } else {
                    count1 = recvPlanViews.stream().filter(view -> StringUtils.hasText((String)view.getReceStatus()) && !view.getReceStatus().equals("3")).count();
                    info.put(ProjectCloseReasonEnum.REASON16.getCode(), count1 == 0L);
                }
            }
        }
        for (PmsInspectionItemConfigVO v3 : list) {
            if (!InspectionItemCheckMethod.SYSTEM_AUTOMATIC_CHECK.getCode().equals(v3.getCheckMethod()) || !ObjectUtils.isEmpty((Object)v3.getCompleteStatus()) && v3.getCompleteStatus().booleanValue() || !info.containsKey(v3.getCheckItem())) continue;
            v3.setCompleteStatus((Boolean)info.get(v3.getCheckItem()));
        }
        return list;
    }

    public void processStatusChange(ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PmsProjectConclusionVO pmsProjectConclusionVO = this.pmsProjectConclusionDAO.queryByKey(Long.valueOf(businessKey));
        if (pmsProjectConclusionVO != null) {
            PmsProjectConclusionPayload projectConclusionPayload = new PmsProjectConclusionPayload();
            projectConclusionPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
            projectConclusionPayload.setApprStatus(procInstStatus.name());
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    projectConclusionPayload.setConclusionStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    break;
                }
                case INTERRUPT: {
                    projectConclusionPayload.setProcInstId(null);
                    projectConclusionPayload.setNullFields(List.of("procInstId"));
                    projectConclusionPayload.setConclusionStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    this.pmsProjectService.updateProjectCloseStatus(Arrays.asList(pmsProjectConclusionVO.getProjId()), ProjectStatusEnum.ACTIVE.getCode());
                    break;
                }
                case INVALID: {
                    projectConclusionPayload.setDeleteFlag(Integer.valueOf(1));
                    projectConclusionPayload.setProcInstId(null);
                    projectConclusionPayload.setNullFields(List.of("procInstId"));
                    projectConclusionPayload.setConclusionStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    this.pmsProjectService.updateProjectCloseStatus(Arrays.asList(pmsProjectConclusionVO.getProjId()), ProjectStatusEnum.ACTIVE.getCode());
                    break;
                }
                case REJECTED: {
                    projectConclusionPayload.setConclusionStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                }
                case APPROVED: {
                    projectConclusionPayload.setConclusionStatus(WorkFlowStatusEnum.APPROVED.getCode());
                    this.pmsProjectService.updateProjectCloseStatus(Arrays.asList(pmsProjectConclusionVO.getProjId()), ProjectStatusEnum.CLOSED.getCode());
                    this.pmsProjectService.createProjFinishWideSettle(pmsProjectConclusionVO.getProjId());
                    break;
                }
            }
            this.pmsProjectConclusionDAO.updateByKeyDynamic(projectConclusionPayload);
        }
    }

    public void taskCreated(TaskCreatedPayload payload) {
        String nextTaskKey;
        ActionType actionType;
        CommentInfo commentInfo;
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        PmsProjectConclusionVO pmsProjectConclusionVO = this.pmsProjectConclusionDAO.queryByKey(Long.valueOf(businessKey));
        if (pmsProjectConclusionVO != null && !ObjectUtils.isEmpty((Object)(commentInfo = payload.getCommentInfo())) && (actionType = commentInfo.getType()).equals((Object)ActionType.AGREE) && this.isFinanceClose(Arrays.asList(nextTaskKey = payload.getTaskKey()))) {
            this.pmsProjectService.updateProjectCloseStatus(Arrays.asList(pmsProjectConclusionVO.getProjId()), ProjectStatusEnum.OVERDUE_ACCOUNTS.getCode());
        }
    }

    private void getProjectData(PmsProjectConclusionVO projectConclusionVO, PmsProjectVO projectVO) {
        projectConclusionVO.setProjId(projectVO.getId());
        projectConclusionVO.setProjName(projectVO.getProjName());
        projectConclusionVO.setProjNo(projectVO.getProjNo());
        projectConclusionVO.setContractNo(projectVO.getContractNo());
        projectConclusionVO.setProjStatus(projectVO.getProjStatus());
        projectConclusionVO.setWorkType(projectVO.getWorkType());
        projectConclusionVO.setPmResId(projectVO.getPmResId());
        projectConclusionVO.setDeliBuId(projectVO.getDeliBuId());
        projectConclusionVO.setDeliUserId(projectVO.getDeliUserId());
        projectConclusionVO.setSaleManUserId(projectVO.getSaleManUserId());
    }

    private void startProcess(PmsProjectConclusionDO entityDo, Long deliUserId, String workType, Long pmResId, String projName) {
        PrdSystemSelectionVO selection = this.cacheUtil.getSystemSelection("PMS:PROJ_CLOSED:APPROVAL_NODE");
        if (selection == null) {
            throw TwException.error("", "\u8bf7\u914d\u7f6e\u5ba1\u6279\u8282\u70b9");
        }
        List children = selection.getChildren();
        Map selectionVOMap = children.stream().collect(Collectors.toMap(PrdSystemSelectionVO::getSelectionName, Function.identity()));
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (PmsProjectConclusionNodeEnum pmsProjectConclusionNodeEnum : PmsProjectConclusionNodeEnum.values()) {
            String desc = pmsProjectConclusionNodeEnum.getDesc();
            if (PmsProjectConclusionNodeEnum.PM.getDesc().equals(desc)) continue;
            PrdSystemSelectionVO systemSelectionVO = (PrdSystemSelectionVO)selectionVOMap.get(pmsProjectConclusionNodeEnum.getDesc());
            if (ObjectUtils.isEmpty((Object)systemSelectionVO)) {
                throw TwException.error("", "\u8bf7\u914d\u7f6e" + desc + "\u5ba1\u6279\u8282\u70b9");
            }
            if (PmsProjectConclusionNodeEnum.DF.getDesc().equals(desc) || PmsProjectConclusionNodeEnum.DH_EVAL.getDesc().equals(desc)) {
                variables.put(systemSelectionVO.getSelectionValue(), deliUserId);
                continue;
            }
            if (PmsProjectConclusionNodeEnum.MEMBER_EVAL.getDesc().equals(desc)) {
                variables.put(systemSelectionVO.getSelectionValue(), pmResId);
                continue;
            }
            String roleCodes = systemSelectionVO.getExtString1();
            if (ObjectUtils.isEmpty((Object)roleCodes)) {
                throw TwException.error("", "\u8bf7\u914d\u7f6e" + desc + "\u5ba1\u6279\u8282\u70b9\u7684\u89d2\u8272");
            }
            variables.put(systemSelectionVO.getSelectionValue(), this.roleService.queryUserIdByRoleCodes(Arrays.asList(roleCodes.split(","))));
        }
        Boolean check1 = SaleConWorkTypeEnum.DEVELOP.getCode().equals(workType) || SaleConWorkTypeEnum.SPECIAL.getCode().equals(workType) || SaleConWorkTypeEnum.MANAGE.getCode().equals(workType) || SaleConWorkTypeEnum.PURETRADE.getCode().equals(workType) || SaleConWorkTypeEnum.INDEPENDENT.getCode().equals(workType);
        variables.put("check1", check1);
        variables.put("check5", check1);
        variables.put("check2", SaleConWorkTypeEnum.MANAGE.getCode().equals(workType) || SaleConWorkTypeEnum.SPECIAL.getCode().equals(workType));
        variables.put("check3", SaleConWorkTypeEnum.OPERATION.getCode().equals(workType));
        variables.put("check4", SaleConWorkTypeEnum.PURETRADE.getCode().equals(workType));
        String procInstName = "A40." + projName + "-\u9879\u76ee\u7ed3\u9879\u6d41\u7a0b";
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)PmsProcDefKey.PMS_PROJECT_CLOSE.name(), (String)procInstName, (String)("" + entityDo.getId()), variables), new Long[0]);
        entityDo.setProcInstId(processInfo.getProcInstId());
        entityDo.setApprStatus(processInfo.getProcInstStatus().name());
        entityDo.setApplyUserId(GlobalUtil.getLoginUserId());
        entityDo.setApplyDate(LocalDate.now());
        if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            entityDo.setConclusionStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        } else if (ProcInstStatus.APPROVED.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            entityDo.setConclusionStatus(WorkFlowStatusEnum.APPROVED.getCode());
            this.pmsProjectService.updateProjectCloseStatus(Arrays.asList(entityDo.getProjId()), ProjectStatusEnum.CLOSED.getCode());
            this.pmsProjectService.createProjFinishWideSettle(entityDo.getProjId());
        }
        this.pmsProjectConclusionDAO.save(entityDo);
    }

    private boolean isFinanceClose(List<String> approvalNodes) {
        String value1 = this.cacheUtil.getSystemSelectionValueByName("PMS:PROJ_CLOSED:APPROVAL_NODE", PmsProjectConclusionNodeEnum.FIN_CLOSING_1.getDesc());
        String value2 = this.cacheUtil.getSystemSelectionValueByName("PMS:PROJ_CLOSED:APPROVAL_NODE", PmsProjectConclusionNodeEnum.FIN_CLOSING_2.getDesc());
        return approvalNodes.contains(value1) || approvalNodes.contains(value2);
    }

    List<String> getApprovalNode(PmsProjectConclusionVO projectConclusionVO, String approvalNode) {
        ArrayList<String> keys = new ArrayList<String>();
        if (ObjectUtils.isEmpty((Object)approvalNode)) {
            String approvalNodeInfo;
            if (ObjectUtils.isEmpty((Object)projectConclusionVO) || GlobalUtil.getLoginUserId().equals(projectConclusionVO.getApplyUserId()) && WorkFlowStatusEnum.NOTSUBMIT.getCode().equals(projectConclusionVO.getConclusionStatus())) {
                keys.add(this.cacheUtil.getSystemSelectionValueByName("PMS:PROJ_CLOSED:APPROVAL_NODE", PmsProjectConclusionNodeEnum.PM.getDesc()));
            }
            if (ObjectUtils.isEmpty(keys) && !ObjectUtils.isEmpty((Object)projectConclusionVO) && !ObjectUtils.isEmpty((Object)(approvalNodeInfo = projectConclusionVO.getApprovalNodeInfo()))) {
                String[] nodeIdPairs;
                for (String nodeIdPair : nodeIdPairs = approvalNodeInfo.split(",")) {
                    String[] pairElements = nodeIdPair.split(":");
                    String userId = pairElements[1];
                    if (!GlobalUtil.getLoginUserId().equals(Long.parseLong(userId))) continue;
                    keys.add(pairElements[0]);
                }
            }
        } else {
            keys.add(approvalNode);
        }
        if (ObjectUtils.isEmpty(keys)) {
            throw TwException.error("", "\u5ba1\u6279\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return keys.stream().distinct().collect(Collectors.toList());
    }

    List<PmsInspectionItemConfigVO> getListByWorkTypeAndApprovalNode(PmsProjectConclusionVO projectConclusionVO, String workType, List<String> approvalNodes) {
        String conclusionCheckItems;
        ArrayList<PmsInspectionItemConfigVO> fromConfig = new ArrayList<PmsInspectionItemConfigVO>();
        for (String approvalNode : approvalNodes) {
            fromConfig.addAll(this.pmsInspectionItemConfigService.getListByWorkTypeAndApprovalNode(workType, approvalNode));
        }
        if (!ObjectUtils.isEmpty((Object)projectConclusionVO) && !ObjectUtils.isEmpty((Object)(conclusionCheckItems = projectConclusionVO.getConclusionCheckItems()))) {
            List inspectionItemPayloads = JSON.parseArray((String)conclusionCheckItems, PmsInspectionItemPayload.class);
            Map<String, PmsInspectionItemPayload> inspectionItemPayloadMap = inspectionItemPayloads.stream().collect(Collectors.toMap(PmsInspectionItemPayload::getCheckItem, pmsInspectionItemPayload -> pmsInspectionItemPayload));
            for (PmsInspectionItemConfigVO itemConfig : fromConfig) {
                String checkItem = itemConfig.getCheckItem();
                if (!inspectionItemPayloadMap.containsKey(checkItem)) continue;
                PmsInspectionItemPayload inspectionItemPayload = inspectionItemPayloadMap.get(checkItem);
                itemConfig.setCompleteStatus(inspectionItemPayload.getCompleteStatus());
                itemConfig.setRemark(inspectionItemPayload.getRemark());
            }
        }
        return fromConfig;
    }

    private void transfer(PmsProjectConclusionVO vo) {
        vo.setBudgetFilesData(this.fileUtil.getFileDatas(vo.getBudgetFiles()));
        if (!ObjectUtils.isEmpty((Object)vo.getEqvaPrice()) && !ObjectUtils.isEmpty((Object)vo.getTotalEqva())) {
            vo.setTotalEqvaAmt(vo.getEqvaPrice().multiply(vo.getTotalEqva()));
        }
        String main = vo.getProductClass();
        String sub = vo.getProductSubClass();
        if (!ObjectUtils.isEmpty((Object)main) || !ObjectUtils.isEmpty((Object)sub)) {
            PrdSystemSelectionVO systemSelectionVO = this.cacheUtil.querySystemSelection("con:sales_class", main);
            vo.setProductSubClassDesc(this.cacheUtil.transferSystemSelection(systemSelectionVO.getSelectionKey(), sub));
        }
    }

    public PmsProjectConclusionServiceImpl(PmsProjectConclusionRepo pmsProjectConclusionRepo, PmsProjectConclusionDAO pmsProjectConclusionDAO, PmsProjectService pmsProjectService, PmsInspectionItemConfigService pmsInspectionItemConfigService, WorkflowUtil workflowUtil, PrdSystemRoleService roleService, CacheUtil cacheUtil, CalAccountService calAccountService, FileUtil fileUtil, TaskCommonService taskCommonService, AdmBusitripApplyService admBusitripApplyService, AccReimService accReimService, ConReceivablePlanService conReceivablePlanService, PurchasePaymentService purchasePaymentService, PmsTimesheetService pmsTimesheetService, TransactionUtilService transactionUtilService, PmsProjectDAO pmsProjectDAO) {
        this.pmsProjectConclusionRepo = pmsProjectConclusionRepo;
        this.pmsProjectConclusionDAO = pmsProjectConclusionDAO;
        this.pmsProjectService = pmsProjectService;
        this.pmsInspectionItemConfigService = pmsInspectionItemConfigService;
        this.workflowUtil = workflowUtil;
        this.roleService = roleService;
        this.cacheUtil = cacheUtil;
        this.calAccountService = calAccountService;
        this.fileUtil = fileUtil;
        this.taskCommonService = taskCommonService;
        this.admBusitripApplyService = admBusitripApplyService;
        this.accReimService = accReimService;
        this.conReceivablePlanService = conReceivablePlanService;
        this.purchasePaymentService = purchasePaymentService;
        this.pmsTimesheetService = pmsTimesheetService;
        this.transactionUtilService = transactionUtilService;
        this.pmsProjectDAO = pmsProjectDAO;
    }
}

