/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.sale.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractCategoryPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractCategoryQuery;
import com.elitesland.tw.tw5.api.prd.sale.service.SaleContractCategoryService;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractCategoryVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sale"})
public class SaleContractCategoryController {
    private static final Logger log = LoggerFactory.getLogger(SaleContractCategoryController.class);
    private final SaleContractCategoryService service;

    @PostMapping(value={"/contractCategory"})
    public TwOutputUtil insert(SaleContractCategoryPayload payload) {
        return TwOutputUtil.ok(this.service.insert(payload));
    }

    @PutMapping(value={"/contractCategory"})
    public TwOutputUtil update(SaleContractCategoryPayload payload) {
        return TwOutputUtil.ok(this.service.update(payload));
    }

    @GetMapping(value={"/contractCategory/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        SaleContractCategoryVO vo = this.service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    @GetMapping(value={"/contractCategory/paging"})
    public TwOutputUtil paging(SaleContractCategoryQuery query) {
        PagingVO paging = this.service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @GetMapping(value={"/contractCategory/list"})
    public TwOutputUtil queryList(SaleContractCategoryQuery query) {
        List vos = this.service.queryList(query);
        return TwOutputUtil.ok(vos);
    }

    @DeleteMapping(value={"/contractCategory/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public SaleContractCategoryController(SaleContractCategoryService service) {
        this.service = service;
    }
}

