/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConAchievePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConAchieveQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConAchieveVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConAchieveDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QConAchieveDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QSaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConAchieveRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class ConAchieveDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final ConAchieveRepo repo;
    private final QConAchieveDO qdo = QConAchieveDO.conAchieveDO;
    private final QSaleConContractDO qdoCon = QSaleConContractDO.saleConContractDO;

    private JPAQuery<ConAchieveVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ConAchieveVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.contractId, this.qdo.achieveIdV4, this.qdo.obversionEffectiveAmt, this.qdo.achieveStatus, this.qdoCon.amt, this.qdoCon.effectiveAmt})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoCon)).on((Predicate)this.qdoCon.id.longValue().eq((Expression)this.qdo.contractId.longValue()));
    }

    private JPAQuery<ConAchieveVO> getJpaQueryWhere(ConAchieveQuery query) {
        JPAQuery<ConAchieveVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(ConAchieveQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(ConAchieveQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        list.add(this.qdo.deleteFlag.eq((Object)0));
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContractId())) {
            list.add(this.qdo.contractId.eq((Object)query.getContractId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getObversionEffectiveAmt())) {
            list.add(this.qdo.obversionEffectiveAmt.eq((Object)query.getObversionEffectiveAmt()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAchieveStatus())) {
            list.add(this.qdo.achieveStatus.eq((Object)query.getAchieveStatus()));
        }
        return ExpressionUtils.allOf(list);
    }

    public ConAchieveVO queryByKey(Long id) {
        JPAQuery<ConAchieveVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (ConAchieveVO)jpaQuery.fetchFirst();
    }

    public List<ConAchieveVO> queryListDynamic(ConAchieveQuery query) {
        JPAQuery<ConAchieveVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<ConAchieveVO> queryPaging(ConAchieveQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<ConAchieveVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public ConAchieveDO save(ConAchieveDO ado) {
        return (ConAchieveDO)this.repo.save(ado);
    }

    public List<ConAchieveDO> saveAll(List<ConAchieveDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(ConAchievePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getContractId() != null) {
            update.set(this.qdo.contractId, (Object)payload.getContractId());
        }
        if (payload.getObversionEffectiveAmt() != null) {
            update.set(this.qdo.obversionEffectiveAmt, (Object)payload.getObversionEffectiveAmt());
        }
        if (payload.getAchieveStatus() != null) {
            update.set((Path)this.qdo.achieveStatus, (Object)payload.getAchieveStatus());
        }
        if (payload.getAchieveIdV4() != null) {
            update.set(this.qdo.achieveIdV4, (Object)payload.getAchieveIdV4());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("contractId")) {
                update.setNull(this.qdo.contractId);
            }
            if (nullFields.contains("obversionEffectiveAmt")) {
                update.setNull(this.qdo.obversionEffectiveAmt);
            }
            if (nullFields.contains("achieveStatus")) {
                update.setNull((Path)this.qdo.achieveStatus);
            }
            if (nullFields.contains("achieveIdV4")) {
                update.setNull(this.qdo.achieveIdV4);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public ConAchieveVO queryByContractId(Long contractId) {
        JPAQuery<ConAchieveVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.contractId.eq((Object)contractId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.groupBy(this.qdo.id);
        return (ConAchieveVO)jpaQuery.fetchFirst();
    }

    public void updateConAmt(BigDecimal amt, BigDecimal effectiveAmt, Long contractId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoCon);
        update.set(this.qdoCon.amt, (Object)amt).set(this.qdoCon.effectiveAmt, (Object)effectiveAmt);
        update.where(new Predicate[]{this.qdoCon.id.eq((Object)contractId)}).execute();
    }

    public ConAchieveDAO(JPAQueryFactory jpaQueryFactory, ConAchieveRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

