/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingMonthPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingMonthQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvSettingMonthService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingMonthVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingMonthConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvSettingMonthDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingMonthDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvSettingMonthRepo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ConInvSettingMonthServiceImpl
extends BaseServiceImpl
implements ConInvSettingMonthService {
    private static final Logger log = LoggerFactory.getLogger(ConInvSettingMonthServiceImpl.class);
    private final ConInvSettingMonthRepo conInvSettingMonthRepo;
    private final ConInvSettingMonthDAO conInvSettingMonthDAO;
    private final ConInvBatchService invBatchService;
    private final ConReceivablePlanService conReceivablePlanService;

    public PagingVO<ConInvSettingMonthVO> queryPaging(ConInvSettingMonthQuery query) {
        return this.conInvSettingMonthDAO.queryPaging(query);
    }

    public List<ConInvSettingMonthVO> queryListDynamic(ConInvSettingMonthQuery query) {
        return this.conInvSettingMonthDAO.queryListDynamic(query);
    }

    public ConInvSettingMonthVO queryByKey(Long key) {
        ConInvSettingMonthDO entity = this.conInvSettingMonthRepo.findById(key).orElseGet(ConInvSettingMonthDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConInvSettingMonthVO vo = ConInvSettingMonthConvert.INSTANCE.toVo(entity);
        return vo;
    }

    public List<ConInvSettingMonthVO> queryByInvSetting(ConInvSettingVO invSettingVO) {
        List<Object> vo = new ArrayList();
        List<ConInvSettingMonthDO> entityList = this.conInvSettingMonthRepo.findByInvSettingId(invSettingVO.getId());
        if (!CollectionUtils.isEmpty(entityList)) {
            vo = ConInvSettingMonthConvert.INSTANCE.toVoList(entityList);
        }
        Long invOuId = invSettingVO.getInvOuId();
        Integer invYear = invSettingVO.getInvYear();
        LocalDate firstDay = LocalDate.of((int)invYear, 1, 1);
        LocalDate lastDay = LocalDate.of((int)invYear, 12, 31);
        ConReceivablePlanQuery conReceivablePlanQuery = new ConReceivablePlanQuery();
        conReceivablePlanQuery.setInvDate(Arrays.asList(firstDay, lastDay));
        conReceivablePlanQuery.setInvOuId(invOuId);
        conReceivablePlanQuery.setReceStatusList(Arrays.asList("2", "3", "4"));
        List conReceivablePlanVOS = this.conReceivablePlanService.queryListDynamic(conReceivablePlanQuery);
        ConInvBatchQuery invBatchQuery = new ConInvBatchQuery();
        invBatchQuery.setInvOuId(invOuId);
        invBatchQuery.setBatchDate(Arrays.asList(firstDay, lastDay));
        invBatchQuery.setBatchStatusList(Arrays.asList("1", "2", "3", "5"));
        List conInvBatchVOS = this.invBatchService.queryListDynamic(invBatchQuery);
        for (ConInvSettingMonthVO conInvSettingMonthVO : vo) {
            Integer invMonth = conInvSettingMonthVO.getInvMonth();
            LocalDate monthFirstDay = YearMonth.of((int)invYear, invMonth).atDay(1);
            LocalDate monthLastDay = YearMonth.of((int)invYear, invMonth).atEndOfMonth();
            List filteredReceivablePlans = conReceivablePlanVOS.stream().filter(plan -> plan.getInvDate() != null && !plan.getInvDate().isBefore(monthFirstDay) && !plan.getInvDate().isAfter(monthLastDay)).collect(Collectors.toList());
            BigDecimal invoicedAmt = filteredReceivablePlans.stream().map(ConReceivablePlanVO::getAlreadyInvAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            List filteredBatchVOS = conInvBatchVOS.stream().filter(batch -> batch.getBatchDate() != null && !batch.getBatchDate().isBefore(monthFirstDay) && !batch.getBatchDate().isAfter(monthLastDay)).collect(Collectors.toList());
            BigDecimal occupyAmt = filteredBatchVOS.stream().map(ConInvBatchVO::getInvAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal effectiveAmt = conInvSettingMonthVO.getInvLimit().subtract(invoicedAmt).subtract(occupyAmt);
            conInvSettingMonthVO.setInvoicedAmt(invoicedAmt);
            conInvSettingMonthVO.setOccupyAmt(occupyAmt);
            conInvSettingMonthVO.setEffectiveAmt(effectiveAmt);
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConInvSettingMonthVO insert(ConInvSettingMonthPayload payload) {
        Assert.notNull((Object)payload.getInvSettingId(), (String)"\u914d\u7f6e\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u4fdd\u5b58\u914d\u7f6e\u4e3b\u6570\u636e\uff01");
        ConInvSettingMonthDO entityDo = ConInvSettingMonthConvert.INSTANCE.toDo(payload);
        return ConInvSettingMonthConvert.INSTANCE.toVo((ConInvSettingMonthDO)this.conInvSettingMonthRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ConInvSettingMonthVO update(ConInvSettingMonthPayload payload) {
        ConInvSettingMonthDO entity = this.conInvSettingMonthRepo.findById(payload.getId()).orElseGet(ConInvSettingMonthDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConInvSettingMonthDO entityDo = ConInvSettingMonthConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConInvSettingMonthConvert.INSTANCE.toVo((ConInvSettingMonthDO)this.conInvSettingMonthRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(ConInvSettingMonthPayload payload) {
        ConInvSettingMonthDO entity = this.conInvSettingMonthRepo.findById(payload.getId()).orElseGet(ConInvSettingMonthDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.conInvSettingMonthDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.conInvSettingMonthDAO.deleteSoft(keys);
        }
    }

    public ConInvSettingMonthServiceImpl(ConInvSettingMonthRepo conInvSettingMonthRepo, ConInvSettingMonthDAO conInvSettingMonthDAO, ConInvBatchService invBatchService, ConReceivablePlanService conReceivablePlanService) {
        this.conInvSettingMonthRepo = conInvSettingMonthRepo;
        this.conInvSettingMonthDAO = conInvSettingMonthDAO;
        this.invBatchService = invBatchService;
        this.conReceivablePlanService = conReceivablePlanService;
    }
}

